/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.RankVariant;
import co.elastic.clients.elasticsearch._types.RrfRank;
import co.elastic.clients.json.JsonEnum;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class Rank
implements TaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<Rank> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Rank::setupRankDeserializer, Builder::build);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    public Rank(RankVariant value) {
        this._kind = ApiTypeHelper.requireNonNull(value._rankKind(), this, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
    }

    private Rank(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static Rank of(Function<Builder, ObjectBuilder<Rank>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isRrf() {
        return this._kind == Kind.Rrf;
    }

    public RrfRank rrf() {
        return (RrfRank)TaggedUnionUtils.get(this, Kind.Rrf);
    }

    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.writeKey(this._kind.jsonValue());
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    public String toString() {
        return JsonpUtils.toString((JsonpSerializable)this);
    }

    protected static void setupRankDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::rrf, RrfRank._DESERIALIZER, "rrf");
    }

    public static enum Kind implements JsonEnum
    {
        Rrf("rrf");

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        public String jsonValue() {
            return this.jsonValue;
        }
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Rank> {
        private Kind _kind;
        private Object _value;

        @Override
        protected Builder self() {
            return this;
        }

        public ObjectBuilder<Rank> rrf(RrfRank v) {
            this._kind = Kind.Rrf;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Rank> rrf(Function<RrfRank.Builder, ObjectBuilder<RrfRank>> fn) {
            return this.rrf(fn.apply(new RrfRank.Builder()).build());
        }

        @Override
        public Rank build() {
            this._checkSingleUse();
            return new Rank(this);
        }
    }
}

