/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.task.reduce;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.DecimalFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.task.reduce.MapOutput;
import org.apache.hadoop.mapreduce.task.reduce.MergeManager;
import org.apache.hadoop.mapreduce.task.reduce.OnDiskMapOutput;
import org.apache.hadoop.mapreduce.task.reduce.RssBypassWriter;
import org.apache.hadoop.mapreduce.task.reduce.ShuffleClientMetrics;
import org.apache.hadoop.util.Progress;
import org.apache.uniffle.client.api.ShuffleReadClient;
import org.apache.uniffle.client.response.CompressedShuffleBlock;
import org.apache.uniffle.com.google.common.annotations.VisibleForTesting;
import org.apache.uniffle.common.compression.Codec;
import org.apache.uniffle.common.config.RssConf;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.common.util.ByteUnit;

public class RssFetcher<K, V> {
    private static final Log LOG = LogFactory.getLog(RssFetcher.class);
    private final Reporter reporter;
    private static final String SHUFFLE_ERR_GRP_NAME = "Shuffle Errors";
    private static final double BYTES_PER_MILLIS_TO_MBS = 1000.0 / ByteUnit.MiB.toBytes(1L);
    private final DecimalFormat mbpsFormat = new DecimalFormat("0.00");
    private final JobConf jobConf;
    private final Counters.Counter connectionErrs;
    private final Counters.Counter ioErrs;
    private final Counters.Counter wrongLengthErrs;
    private final Counters.Counter badIdErrs;
    private final Counters.Counter wrongMapErrs;
    private final Counters.Counter wrongReduceErrs;
    private final TaskStatus status;
    private final MergeManager<K, V> merger;
    private final Progress progress;
    private final ShuffleClientMetrics metrics;
    private long totalBlockCount;
    private long copyBlockCount = 0L;
    private volatile boolean stopped = false;
    private ShuffleReadClient shuffleReadClient;
    private long readTime = 0L;
    private long decompressTime = 0L;
    private long serializeTime = 0L;
    private long waitTime = 0L;
    private long copyTime = 0L;
    private long unCompressionLength = 0L;
    private final TaskAttemptID reduceId;
    private int uniqueMapId = 0;
    private boolean hasPendingData = false;
    private long startWait;
    private int waitCount = 0;
    private byte[] uncompressedData = null;
    private RssConf rssConf;
    private Codec codec;

    RssFetcher(JobConf job, TaskAttemptID reduceId, TaskStatus status, MergeManager<K, V> merger, Progress progress, Reporter reporter, ShuffleClientMetrics metrics, ShuffleReadClient shuffleReadClient, long totalBlockCount, RssConf rssConf) {
        this.jobConf = job;
        this.reporter = reporter;
        this.status = status;
        this.merger = merger;
        this.progress = progress;
        this.metrics = metrics;
        this.reduceId = reduceId;
        this.ioErrs = reporter.getCounter(SHUFFLE_ERR_GRP_NAME, ShuffleErrors.IO_ERROR.toString());
        this.wrongLengthErrs = reporter.getCounter(SHUFFLE_ERR_GRP_NAME, ShuffleErrors.WRONG_LENGTH.toString());
        this.badIdErrs = reporter.getCounter(SHUFFLE_ERR_GRP_NAME, ShuffleErrors.BAD_ID.toString());
        this.wrongMapErrs = reporter.getCounter(SHUFFLE_ERR_GRP_NAME, ShuffleErrors.WRONG_MAP.toString());
        this.connectionErrs = reporter.getCounter(SHUFFLE_ERR_GRP_NAME, ShuffleErrors.CONNECTION.toString());
        this.wrongReduceErrs = reporter.getCounter(SHUFFLE_ERR_GRP_NAME, ShuffleErrors.WRONG_REDUCE.toString());
        this.shuffleReadClient = shuffleReadClient;
        this.totalBlockCount = totalBlockCount;
        this.rssConf = rssConf;
        this.codec = Codec.newInstance(rssConf);
    }

    public void fetchAllRssBlocks() throws IOException, InterruptedException {
        while (!this.stopped) {
            try {
                this.merger.waitForResource();
                this.metrics.threadBusy();
                this.copyFromRssServer();
            }
            finally {
                this.metrics.threadFree();
            }
        }
    }

    @VisibleForTesting
    public void copyFromRssServer() throws IOException {
        CompressedShuffleBlock compressedBlock = null;
        ByteBuffer compressedData = null;
        if (!this.hasPendingData) {
            long startFetch = System.currentTimeMillis();
            compressedBlock = this.shuffleReadClient.readShuffleBlockData();
            if (compressedBlock != null) {
                compressedData = compressedBlock.getByteBuffer();
            }
            long fetchDuration = System.currentTimeMillis() - startFetch;
            this.readTime += fetchDuration;
        }
        if (!this.hasPendingData && compressedData != null) {
            long startDecompress = System.currentTimeMillis();
            int uncompressedLen = compressedBlock.getUncompressLength();
            ByteBuffer decompressedBuffer = ByteBuffer.allocate(uncompressedLen);
            this.codec.decompress(compressedData, uncompressedLen, decompressedBuffer, 0);
            this.uncompressedData = decompressedBuffer.array();
            this.unCompressionLength += (long)compressedBlock.getUncompressLength();
            long decompressDuration = System.currentTimeMillis() - startDecompress;
            this.decompressTime += decompressDuration;
        }
        if (this.uncompressedData != null) {
            long startSerialization = System.currentTimeMillis();
            if (this.issueMapOutputMerge()) {
                long serializationDuration = System.currentTimeMillis() - startSerialization;
                this.serializeTime += serializationDuration;
                if (this.hasPendingData) {
                    this.waitTime += System.currentTimeMillis() - this.startWait;
                }
            } else {
                this.startWait = System.currentTimeMillis();
                return;
            }
            this.hasPendingData = false;
            this.uncompressedData = null;
            ++this.copyBlockCount;
            this.copyTime = this.readTime + this.decompressTime + this.serializeTime + this.waitTime;
            this.updateStatus();
            this.reporter.progress();
        } else {
            this.shuffleReadClient.close();
            this.shuffleReadClient.checkProcessedBlockIds();
            this.shuffleReadClient.logStatics();
            this.metrics.inputBytes(this.unCompressionLength);
            LOG.info((Object)("reduce task " + this.reduceId.toString() + " cost " + this.readTime + " ms to fetch and " + this.decompressTime + " ms to decompress with unCompressionLength[" + this.unCompressionLength + "] and " + this.serializeTime + " ms to serialize and " + this.waitTime + " ms to wait resource"));
            this.stopFetch();
        }
    }

    private boolean issueMapOutputMerge() throws IOException {
        TaskAttemptID mapId = this.getNextUniqueTaskAttemptID();
        MapOutput mapOutput = null;
        try {
            mapOutput = this.merger.reserve(mapId, (long)this.uncompressedData.length, 0);
        }
        catch (IOException ioe) {
            this.ioErrs.increment(1L);
            throw ioe;
        }
        if (mapOutput == null) {
            LOG.info((Object)"RssMRFetcher - MergeManager returned status WAIT ...");
            this.hasPendingData = true;
            ++this.waitCount;
            return false;
        }
        try {
            RssBypassWriter.write(mapOutput, this.uncompressedData);
            mapOutput.commit();
            if (mapOutput instanceof OnDiskMapOutput) {
                LOG.info((Object)("Reduce: " + this.reduceId + " allocates disk to accept block  with byte sizes: " + this.uncompressedData.length));
            }
        }
        catch (Throwable t) {
            this.ioErrs.increment(1L);
            mapOutput.abort();
            throw new RssException("Reduce: " + this.reduceId + " cannot write block to " + mapOutput.getClass().getSimpleName() + " due to: " + t.getClass().getName());
        }
        return true;
    }

    private TaskAttemptID getNextUniqueTaskAttemptID() {
        TaskID taskID = new TaskID(this.reduceId.getJobID(), TaskType.MAP, this.uniqueMapId++);
        return new TaskAttemptID(taskID, 0);
    }

    private void stopFetch() {
        this.stopped = true;
    }

    private void updateStatus() {
        this.progress.set((float)this.copyBlockCount / (float)this.totalBlockCount);
        String statusString = this.copyBlockCount + " / " + this.totalBlockCount + " copied.";
        this.status.setStateString(statusString);
        if (this.copyTime == 0L) {
            this.copyTime = 1L;
        }
        double bytesPerMillis = (double)this.unCompressionLength / (double)this.copyTime;
        double transferRate = bytesPerMillis * BYTES_PER_MILLIS_TO_MBS;
        this.progress.setStatus("copy(" + this.copyBlockCount + " of " + this.totalBlockCount + " at " + this.mbpsFormat.format(transferRate) + " MB/s)");
    }

    @VisibleForTesting
    public int getRetryCount() {
        return this.waitCount;
    }

    private static enum ShuffleErrors {
        IO_ERROR,
        WRONG_LENGTH,
        BAD_ID,
        WRONG_MAP,
        CONNECTION,
        WRONG_REDUCE;

    }
}

