/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.jsonrpc;

import com.metaparadigm.jsonrpc.JSONRPCBridge;
import java.io.CharArrayWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.jsonrpc.JSONProcessor;
import org.apache.turbine.services.jsonrpc.JsonRpcService;

public class TurbineJsonRpcService
extends TurbineBaseService
implements JsonRpcService {
    private static Log log = LogFactory.getLog(TurbineJsonRpcService.class);
    public static final String JSON_BRIDGE_KEY = "JSONRPCBridge";
    private static final boolean DEBUG = log.isDebugEnabled();

    @Override
    public Object processCall(CharArrayWriter cdata, JSONRPCBridge json_bridge, HttpServletRequest request) {
        return JSONProcessor.processCall(cdata, json_bridge, request);
    }

    @Override
    public void registerObjectGlobal(String key, Object value) {
        JSONRPCBridge.getGlobalBridge().setDebug(DEBUG);
        JSONRPCBridge.getGlobalBridge().registerObject((Object)key, value);
    }

    @Override
    public void registerObject(HttpSession session, String key, Object value) {
        JSONRPCBridge json_bridge = this.getBridge(session);
        json_bridge.setDebug(DEBUG);
        json_bridge.registerObject((Object)key, value);
    }

    @Override
    public JSONRPCBridge getBridge(HttpSession session) {
        JSONRPCBridge json_bridge = (JSONRPCBridge)session.getAttribute(JSON_BRIDGE_KEY);
        if (json_bridge == null) {
            json_bridge = new JSONRPCBridge();
            session.setAttribute(JSON_BRIDGE_KEY, (Object)json_bridge);
        }
        return json_bridge;
    }

    @Override
    public void clearBridge(HttpSession session) {
        session.removeAttribute(JSON_BRIDGE_KEY);
    }
}

