/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Stream;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;

public class ImplicitTypeDeclaration
extends TypeDeclaration {
    public ImplicitTypeDeclaration(CompilationResult result) {
        super(result);
        this.modifiers = 16;
        Path p = Paths.get(new String(result.fileName), new String[0]);
        String basename = p.getFileName().toString();
        String className = basename.endsWith(".java") ? basename.substring(0, basename.length() - 5) : basename;
        this.name = className.toCharArray();
    }

    @Override
    public boolean isImplicitType() {
        return true;
    }

    @Override
    public void resolve(CompilationUnitScope upperScope) {
        super.resolve(upperScope);
        boolean anyMatch = Stream.of(this.methods).anyMatch(m -> m.isCandidateMain());
        if (!anyMatch) {
            upperScope.problemReporter().implicitClassMissingMainMethod(this);
        }
    }
}

