# -------------------------------------------------------------
#
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
#
# -------------------------------------------------------------

# Autogenerated By   : src/main/python/generator/generator.py
# Autogenerated From : scripts/builtin/dmv.dml

from typing import Dict, Iterable

from systemds.operator import OperationNode, Matrix, Frame, List, MultiReturn, Scalar
from systemds.script_building.dag import OutputType
from systemds.utils.consts import VALID_INPUT_TYPES


def dmv(X: Frame,
        **kwargs: Dict[str, VALID_INPUT_TYPES]):
    """
     The dmv-function is used to find disguised missing values utilising syntactical pattern recognition.
    
    
    
    :param X: Input Frame
    :param threshold: Threshold value in interval [0, 1] for dominant pattern per column (e.g., 0.8 means
        that 80% of the entries per column must adhere this pattern to be dominant)
    :param replace: The string disguised missing values are replaced with
    :return: Frame X including detected disguised missing values
    """

    params_dict = {'X': X}
    params_dict.update(kwargs)
    return Matrix(X.sds_context,
        'dmv',
        named_input_nodes=params_dict)
