/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.kendo.ui.repeater;

import com.github.openjson.JSONArray;
import com.github.openjson.JSONObject;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.request.IRequestParameters;
import org.wicketstuff.jquery.core.behavior.AjaxCallbackBehavior;
import org.wicketstuff.jquery.core.renderer.ITextRenderer;
import org.wicketstuff.jquery.core.template.IJQueryTemplate;
import org.wicketstuff.jquery.core.utils.ListUtils;

public class DataProviderBehavior<T>
extends AjaxCallbackBehavior {
    private static final long serialVersionUID = 1L;
    private final IDataProvider<T> provider;
    private final ITextRenderer<? super T> renderer;
    private final IJQueryTemplate template;

    public DataProviderBehavior(IDataProvider<T> provider, ITextRenderer<? super T> renderer) {
        this(provider, renderer, null);
    }

    public DataProviderBehavior(IDataProvider<T> provider, ITextRenderer<? super T> renderer, IJQueryTemplate template) {
        this.provider = provider;
        this.renderer = renderer;
        this.template = template;
    }

    protected List<String> getProperties() {
        if (this.template != null) {
            return ListUtils.exclude((List)this.template.getTextProperties(), (List)this.renderer.getFields());
        }
        return Collections.emptyList();
    }

    protected String getResponse(IRequestParameters parameters) {
        int first = parameters.getParameterValue("skip").toInt(0);
        int count = parameters.getParameterValue("take").toInt(Short.MAX_VALUE);
        long size = this.provider.size();
        Iterator iterator = this.provider.iterator((long)first, (long)count);
        JSONObject payload = new JSONObject();
        payload.put("__count", size);
        JSONArray results = new JSONArray();
        payload.put("results", (Object)results);
        if (iterator != null) {
            while (iterator.hasNext()) {
                Object object = iterator.next();
                JSONObject result = this.renderer.render(object);
                for (String property : this.getProperties()) {
                    result.put(property, (Object)this.renderer.getText(object, property));
                }
                results.put((Object)result);
            }
        }
        return payload.toString();
    }

    public void detach(Component component) {
        super.detach(component);
        this.provider.detach();
    }
}

