/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.ad.crud;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.ModificationItem;
import net.tirasa.adsddl.ntsd.utils.GUID;
import net.tirasa.connid.bundles.ad.ADConfiguration;
import net.tirasa.connid.bundles.ad.ADConnection;
import net.tirasa.connid.bundles.ad.util.ADGuardedPasswordAttribute;
import net.tirasa.connid.bundles.ad.util.ADUtilities;
import net.tirasa.connid.bundles.ldap.LdapConnection;
import net.tirasa.connid.bundles.ldap.commons.LdapConstants;
import net.tirasa.connid.bundles.ldap.commons.LdapUtil;
import net.tirasa.connid.bundles.ldap.modify.LdapCreate;
import net.tirasa.connid.bundles.ldap.schema.GuardedPasswordAttribute;
import net.tirasa.connid.bundles.ldap.schema.LdapSchema;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.Uid;

public class ADCreate
extends LdapCreate {
    private static final Log LOG = Log.getLog(ADConnection.class);

    public ADCreate(ADConnection conn, ObjectClass oclass, Set<Attribute> attrs, OperationOptions options) {
        super((LdapConnection)conn, oclass, attrs, options);
    }

    protected Uid executeImpl() throws NamingException {
        Name name;
        Name nameAttr = AttributeUtil.getNameFromAttributes((Set)this.attrs);
        if (nameAttr == null) {
            throw new IllegalArgumentException("No Name attribute provided in the attributes");
        }
        Attribute cnAttr = AttributeUtil.find((String)"CN", (Set)this.attrs);
        if (cnAttr != null) {
            this.attrs.remove(cnAttr);
        }
        ADUtilities utils = new ADUtilities((ADConnection)this.conn);
        Uid uid = AttributeUtil.getUidAttribute((Set)this.attrs);
        if (ADUtilities.isDN(nameAttr.getNameValue())) {
            name = nameAttr;
        } else {
            if (uid == null && StringUtil.isNotBlank((String)nameAttr.getNameValue())) {
                uid = new Uid(nameAttr.getNameValue());
                this.attrs.add(uid);
            }
            name = new Name(utils.getDN(this.oclass, nameAttr, cnAttr));
        }
        String idAttrName = ObjectClass.ACCOUNT.equals((Object)this.oclass) ? this.conn.getConfiguration().getUidAttribute() : (ObjectClass.GROUP.equals((Object)this.oclass) ? this.conn.getConfiguration().getGidAttribute() : (LdapSchema.ANY_OBJECT_CLASS.equals((Object)this.oclass) ? this.conn.getConfiguration().getAoidAttribute() : ((ADConfiguration)((Object)ADConfiguration.class.cast(this.conn.getConfiguration()))).getDefaultIdAttribute()));
        Attribute idAttr = AttributeUtil.find((String)idAttrName, (Set)this.attrs);
        if ((idAttr == null || CollectionUtil.isEmpty((Collection)idAttr.getValue())) && uid != null) {
            this.attrs.add(AttributeBuilder.build((String)idAttrName, (Object[])new Object[]{uid.getUidValue()}));
        }
        List ldapGroups = null;
        String primaryGroupDN = null;
        ADGuardedPasswordAttribute pwdAttr = null;
        final BasicAttributes adAttrs = new BasicAttributes(true);
        int uacValue = 512;
        Boolean uccp = null;
        Boolean pne = null;
        Boolean pnr = null;
        Boolean status = null;
        for (Attribute attr : this.attrs) {
            javax.naming.directory.Attribute ldapAttr;
            List value;
            if (attr.is(Name.NAME)) continue;
            if (attr.is("userCannotChangePassword")) {
                value = attr.getValue();
                if (value == null || value.isEmpty()) continue;
                uccp = (Boolean)value.get(0);
                continue;
            }
            if (attr.is("passwordNeverExpires")) {
                value = attr.getValue();
                if (value == null || value.isEmpty()) continue;
                pne = (Boolean)value.get(0);
                continue;
            }
            if (attr.is("passwordNotRequired")) {
                value = attr.getValue();
                if (value == null || value.isEmpty()) continue;
                pnr = (Boolean)value.get(0);
                continue;
            }
            if (attr.is("primaryGroupDN")) {
                value = attr.getValue();
                primaryGroupDN = value == null || value.isEmpty() ? null : (String)String.class.cast(value.get(0));
                continue;
            }
            if (attr.is("pwdLastSet")) {
                value = attr.getValue();
                if (value == null || value.isEmpty() || !((Boolean)value.get(0)).booleanValue()) continue;
                adAttrs.put(new BasicAttribute("pwdLastSet", "0"));
                continue;
            }
            if (attr.is("lockoutTime")) {
                value = attr.getValue();
                if (value == null || value.isEmpty() || !((Boolean)value.get(0)).booleanValue()) continue;
                adAttrs.put(new BasicAttribute("lockoutTime", "0"));
                continue;
            }
            if (LdapConstants.isLdapGroups((String)attr.getName())) {
                ldapGroups = LdapUtil.checkedListByFilter((List)CollectionUtil.nullAsEmpty((List)attr.getValue()), String.class);
                continue;
            }
            if (attr.is(OperationalAttributes.PASSWORD_NAME)) {
                pwdAttr = ADGuardedPasswordAttribute.create(this.conn.getConfiguration().getPasswordAttribute(), attr);
                continue;
            }
            if (attr.is("userAccountControl") && this.oclass.is(ObjectClass.ACCOUNT_NAME)) {
                uacValue = attr.getValue() == null || attr.getValue().isEmpty() ? 512 : Integer.parseInt(attr.getValue().get(0).toString());
                continue;
            }
            if (attr.is(OperationalAttributes.ENABLE_NAME) && this.oclass.is(ObjectClass.ACCOUNT_NAME)) {
                status = attr.getValue() == null || attr.getValue().isEmpty() || Boolean.parseBoolean(attr.getValue().get(0).toString());
                continue;
            }
            if (attr.is("objectGUID") || (ldapAttr = this.conn.getSchema().encodeAttribute(this.oclass, attr)) == null || ldapAttr.size() <= 0) continue;
            adAttrs.put(ldapAttr);
        }
        String pwdAttrName = this.conn.getConfiguration().getPasswordAttribute();
        if (this.oclass.is(ObjectClass.ACCOUNT_NAME)) {
            if (pne != null) {
                if ((uacValue & 0x10000) == 65536 && !pne.booleanValue()) {
                    uacValue -= 65536;
                } else if ((uacValue & 0x10000) != 65536 && pne.booleanValue()) {
                    int n = uacValue = uacValue == -1 ? 65536 : uacValue + 65536;
                }
            }
            if (pnr != null) {
                if ((uacValue & 0x20) == 32 && !pnr.booleanValue()) {
                    uacValue -= 32;
                } else if ((uacValue & 0x20) != 32 && pnr.booleanValue()) {
                    int n = uacValue = uacValue == -1 ? 32 : uacValue + 32;
                }
            }
            if (status != null) {
                if ((uacValue & 2) == 2 && status.booleanValue()) {
                    uacValue -= 2;
                } else if ((uacValue & 2) != 2 && !status.booleanValue()) {
                    int n = uacValue = uacValue == -1 ? 2 : uacValue + 2;
                }
            }
            if (pwdAttr != null) {
                pwdAttr.access(new GuardedPasswordAttribute.Accessor(){

                    public void access(javax.naming.directory.Attribute attr) {
                        try {
                            if (attr.get() != null && !attr.get().toString().isEmpty()) {
                                adAttrs.put(attr);
                            }
                        }
                        catch (NamingException e) {
                            LOG.error((Throwable)e, "Error retrieving password value", new Object[0]);
                        }
                    }
                });
            }
            if (adAttrs.get(pwdAttrName) == null && (uacValue & 2) != 2) {
                uacValue += 2;
            }
            adAttrs.put("userAccountControl", Integer.toString(uacValue));
        }
        String entryDN = this.conn.getSchema().create(this.oclass, name, (Attributes)adAttrs);
        if (uccp != null) {
            this.conn.getInitialContext().modifyAttributes(entryDN, new ModificationItem[]{new ModificationItem(2, utils.userCannotChangePassword(entryDN, uccp))});
        }
        if (!CollectionUtil.isEmpty(ldapGroups)) {
            this.groupHelper.addLdapGroupMemberships(entryDN, ldapGroups);
        }
        if (StringUtil.isNotBlank(primaryGroupDN)) {
            this.conn.getInitialContext().modifyAttributes(entryDN, new ModificationItem[]{new ModificationItem(2, utils.getGroupID(primaryGroupDN))});
        }
        if ("objectGUID".equals(this.conn.getSchema().getLdapUidAttribute(this.oclass))) {
            Attributes profile = this.conn.getInitialContext().getAttributes(entryDN, new String[]{"objectGUID"});
            return new Uid(GUID.getGuidAsString((byte[])((byte[])profile.get("objectGUID").get())));
        }
        return this.conn.getSchema().createUid(this.oclass, entryDN);
    }
}

