/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.util.DataUtilities;
import java.io.IOException;
import java.io.OutputStream;

final class StringOutput {
    private final StringBuilder builder;
    private final OutputStream outputStream;

    public StringOutput(StringBuilder builder) {
        this.builder = builder;
        this.outputStream = null;
    }

    public StringOutput(OutputStream outputStream) {
        this.outputStream = outputStream;
        this.builder = null;
    }

    public void WriteString(String str) throws IOException {
        if (this.outputStream != null) {
            if (str.length() == 1) {
                this.WriteCodePoint(str.charAt(0));
            } else if (DataUtilities.WriteUtf8((String)str, (int)0, (int)str.length(), (OutputStream)this.outputStream, (boolean)false) < 0) {
                throw new IllegalArgumentException("str has an unpaired surrogate");
            }
        } else {
            this.builder.append(str);
        }
    }

    public void WriteString(String str, int index, int length) throws IOException {
        if (this.outputStream == null) {
            this.builder.append(str, index, index + length);
        } else if (length == 1) {
            this.WriteCodePoint(str.charAt(index));
        } else if (DataUtilities.WriteUtf8((String)str, (int)index, (int)length, (OutputStream)this.outputStream, (boolean)false) < 0) {
            throw new IllegalArgumentException("str has an unpaired surrogate");
        }
    }

    public void WriteAscii(byte[] bytes, int index, int length) throws IOException {
        if (bytes == null) {
            throw new NullPointerException("bytes");
        }
        if (index < 0) {
            throw new IllegalArgumentException("\"index\" (" + index + ") is not greater or equal to 0");
        }
        if (index > bytes.length) {
            throw new IllegalArgumentException("\"index\" (" + index + ") is not less or equal to " + bytes.length);
        }
        if (length < 0) {
            throw new IllegalArgumentException(" (" + length + ") is not greater or equal to 0");
        }
        if (length > bytes.length) {
            throw new IllegalArgumentException(" (" + length + ") is not less or equal to " + bytes.length);
        }
        if (bytes.length - index < length) {
            throw new IllegalArgumentException("\"bytes\" + \"'s length minus \" + index (" + (bytes.length - index) + ") is not greater or equal to " + length);
        }
        if (this.outputStream == null) {
            DataUtilities.ReadUtf8FromBytes((byte[])bytes, (int)index, (int)length, (StringBuilder)this.builder, (boolean)false);
        } else {
            for (int i = 0; i < length; ++i) {
                byte b = bytes[i + index];
                if ((b & 0x7F) == b) continue;
                throw new IllegalArgumentException("str is non-ASCII");
            }
            this.outputStream.write(bytes, index, length);
        }
    }

    public void WriteCodePoint(int codePoint) throws IOException {
        if (codePoint >> 7 == 0) {
            if (this.outputStream == null) {
                this.builder.append((char)codePoint);
            } else {
                this.outputStream.write((byte)codePoint);
            }
            return;
        }
        if (codePoint < 0) {
            throw new IllegalArgumentException("codePoint(" + codePoint + ") is less than 0");
        }
        if (codePoint > 0x10FFFF) {
            throw new IllegalArgumentException("codePoint(" + codePoint + ") is more than " + 0x10FFFF);
        }
        if (this.outputStream != null) {
            if (codePoint < 128) {
                this.outputStream.write((byte)codePoint);
            } else if (codePoint <= 2047) {
                this.outputStream.write((byte)(0xC0 | codePoint >> 6 & 0x1F));
                this.outputStream.write((byte)(0x80 | codePoint & 0x3F));
            } else if (codePoint <= 65535) {
                if ((codePoint & 0xF800) == 55296) {
                    throw new IllegalArgumentException("ch is a surrogate");
                }
                this.outputStream.write((byte)(0xE0 | codePoint >> 12 & 0xF));
                this.outputStream.write((byte)(0x80 | codePoint >> 6 & 0x3F));
                this.outputStream.write((byte)(0x80 | codePoint & 0x3F));
            } else {
                this.outputStream.write((byte)(0xF0 | codePoint >> 18 & 7));
                this.outputStream.write((byte)(0x80 | codePoint >> 12 & 0x3F));
                this.outputStream.write((byte)(0x80 | codePoint >> 6 & 0x3F));
                this.outputStream.write((byte)(0x80 | codePoint & 0x3F));
            }
        } else {
            if ((codePoint & 0xFFF800) == 55296) {
                throw new IllegalArgumentException("ch is a surrogate");
            }
            if (codePoint <= 65535) {
                this.builder.append((char)codePoint);
            } else if (codePoint <= 0x10FFFF) {
                this.builder.append((char)(codePoint - 65536 >> 10 & 0x3FF | 0xD800));
                this.builder.append((char)(codePoint - 65536 & 0x3FF | 0xDC00));
            }
        }
    }
}

