/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.services;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apereo.cas.configuration.support.RegularExpressionCapable;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicyContext;
import org.apereo.cas.support.saml.services.BaseSamlRegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceMetadataAdaptor;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceCachingMetadataResolver;
import org.apereo.cas.util.RegexUtils;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthnRequestRequesterIdAttributeReleasePolicy
extends BaseSamlRegisteredServiceAttributeReleasePolicy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthnRequestRequesterIdAttributeReleasePolicy.class);
    private static final long serialVersionUID = -4273777707124962357L;
    @RegularExpressionCapable
    private String requesterIdPattern;

    @Override
    protected Map<String, List<Object>> getAttributesForSamlRegisteredService(Map<String, List<Object>> attributes, SamlRegisteredServiceCachingMetadataResolver resolver, SamlRegisteredServiceMetadataAdaptor facade, EntityDescriptor entityDescriptor, RegisteredServiceAttributeReleasePolicyContext context) {
        HashMap releaseAttributes = new HashMap();
        AuthnRequestRequesterIdAttributeReleasePolicy.getSamlAuthnRequest(context).filter(authnRequest -> authnRequest.getScoping() != null).filter(authnRequest -> !authnRequest.getScoping().getRequesterIDs().isEmpty()).ifPresent(authnRequest -> {
            List requesterIds = authnRequest.getScoping().getRequesterIDs();
            boolean matched = requesterIds.stream().anyMatch(requesterId -> RegexUtils.find((String)this.requesterIdPattern, (String)requesterId.getURI()));
            if (matched) {
                releaseAttributes.putAll(attributes);
            }
        });
        return this.authorizeReleaseOfAllowedAttributes(context, releaseAttributes);
    }

    @Generated
    public String toString() {
        return "AuthnRequestRequesterIdAttributeReleasePolicy(super=" + super.toString() + ", requesterIdPattern=" + this.requesterIdPattern + ")";
    }

    @Generated
    public String getRequesterIdPattern() {
        return this.requesterIdPattern;
    }

    @Generated
    public void setRequesterIdPattern(String requesterIdPattern) {
        this.requesterIdPattern = requesterIdPattern;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthnRequestRequesterIdAttributeReleasePolicy)) {
            return false;
        }
        AuthnRequestRequesterIdAttributeReleasePolicy other = (AuthnRequestRequesterIdAttributeReleasePolicy)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$requesterIdPattern = this.requesterIdPattern;
        String other$requesterIdPattern = other.requesterIdPattern;
        return !(this$requesterIdPattern == null ? other$requesterIdPattern != null : !this$requesterIdPattern.equals(other$requesterIdPattern));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AuthnRequestRequesterIdAttributeReleasePolicy;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $requesterIdPattern = this.requesterIdPattern;
        result = result * 59 + ($requesterIdPattern == null ? 43 : $requesterIdPattern.hashCode());
        return result;
    }
}

