/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import jakarta.ws.rs.core.Response;
import java.io.ByteArrayInputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.zip.ZipInputStream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Strings;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.ExecTO;
import org.apache.syncope.common.lib.to.JobTO;
import org.apache.syncope.common.lib.to.ReportTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.JobAction;
import org.apache.syncope.common.lib.types.JobType;
import org.apache.syncope.common.rest.api.batch.BatchResponseItem;
import org.apache.syncope.common.rest.api.beans.ExecSpecs;
import org.apache.syncope.core.logic.AbstractExecutableLogic;
import org.apache.syncope.core.logic.AbstractJobLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.JobStatusDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.ReportDAO;
import org.apache.syncope.core.persistence.api.dao.ReportExecDAO;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.Report;
import org.apache.syncope.core.persistence.api.entity.ReportExec;
import org.apache.syncope.core.persistence.api.search.SyncopePage;
import org.apache.syncope.core.persistence.api.utils.ExceptionUtils2;
import org.apache.syncope.core.provisioning.api.data.ReportDataBinder;
import org.apache.syncope.core.provisioning.api.job.JobManager;
import org.apache.syncope.core.provisioning.api.job.JobNamer;
import org.apache.syncope.core.provisioning.java.job.SyncopeTaskScheduler;
import org.apache.syncope.core.provisioning.java.job.report.ReportJob;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

public class ReportLogic
extends AbstractExecutableLogic<ReportTO> {
    protected final ReportDAO reportDAO;
    protected final ReportExecDAO reportExecDAO;
    protected final ReportDataBinder binder;
    protected final EntityFactory entityFactory;

    public ReportLogic(JobManager jobManager, SyncopeTaskScheduler scheduler, JobStatusDAO jobStatusDAO, ReportDAO reportDAO, ReportExecDAO reportExecDAO, ReportDataBinder binder, EntityFactory entityFactory) {
        super(jobManager, scheduler, jobStatusDAO);
        this.reportDAO = reportDAO;
        this.reportExecDAO = reportExecDAO;
        this.binder = binder;
        this.entityFactory = entityFactory;
    }

    @PreAuthorize(value="hasRole('REPORT_CREATE')")
    public ReportTO create(ReportTO reportTO) {
        Report report = (Report)this.entityFactory.newEntity(Report.class);
        this.binder.getReport(report, reportTO);
        report = (Report)this.reportDAO.save((Entity)report);
        try {
            this.jobManager.register(report, AuthContextUtils.getUsername());
        }
        catch (Exception e) {
            LOG.error("While registering job for report {}", (Object)report.getKey(), (Object)e);
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Scheduling);
            sce.getElements().add(e.getMessage());
            throw sce;
        }
        return this.binder.getReportTO(report);
    }

    @PreAuthorize(value="hasRole('REPORT_UPDATE')")
    public ReportTO update(ReportTO reportTO) {
        Report report = (Report)this.reportDAO.findById(reportTO.getKey()).orElseThrow(() -> new NotFoundException("Report " + reportTO.getKey()));
        this.binder.getReport(report, reportTO);
        report = (Report)this.reportDAO.save((Entity)report);
        try {
            if (report.isActive()) {
                this.jobManager.register(report, AuthContextUtils.getUsername());
            } else {
                this.jobManager.unregister(report);
            }
        }
        catch (Exception e) {
            LOG.error("While (un)registering job for report {}", (Object)report.getKey(), (Object)e);
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Scheduling);
            sce.getElements().add(e.getMessage());
            throw sce;
        }
        return this.binder.getReportTO(report);
    }

    @PreAuthorize(value="hasRole('REPORT_LIST')")
    @Transactional(readOnly=true)
    public List<ReportTO> list() {
        return this.reportDAO.findAll().stream().map(arg_0 -> ((ReportDataBinder)this.binder).getReportTO(arg_0)).toList();
    }

    @PreAuthorize(value="hasRole('REPORT_READ')")
    @Transactional(readOnly=true)
    public ReportTO read(String key) {
        Report report = (Report)this.reportDAO.findById(key).orElseThrow(() -> new NotFoundException("Report " + key));
        return this.binder.getReportTO(report);
    }

    @Override
    @PreAuthorize(value="hasRole('REPORT_EXECUTE')")
    public ExecTO execute(ExecSpecs specs) {
        Report report = (Report)this.reportDAO.findById(specs.getKey()).orElseThrow(() -> new NotFoundException("Report " + specs.getKey()));
        if (!report.isActive()) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Scheduling);
            sce.getElements().add("Report " + specs.getKey() + " is not active");
            throw sce;
        }
        if (specs.getStartAt() != null && specs.getStartAt().isBefore(OffsetDateTime.now())) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Scheduling);
            sce.getElements().add("Cannot schedule in the past");
            throw sce;
        }
        try {
            this.jobManager.execute(report, Optional.ofNullable(specs.getStartAt()).orElseGet(OffsetDateTime::now), AuthContextUtils.getUsername(), specs.getDryRun().booleanValue());
        }
        catch (Exception e) {
            LOG.error("While executing report {}", (Object)report, (Object)e);
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Scheduling);
            sce.getElements().add(e.getMessage());
            throw sce;
        }
        ExecTO result = new ExecTO();
        result.setJobType(JobType.REPORT);
        result.setRefKey(report.getKey());
        result.setRefDesc(this.binder.buildRefDesc(report));
        result.setStart(OffsetDateTime.now());
        result.setStatus("JOB_FIRED");
        result.setMessage("Job fired; waiting for results...");
        result.setExecutor(AuthContextUtils.getUsername());
        return result;
    }

    @PreAuthorize(value="hasRole('REPORT_READ')")
    @Transactional(readOnly=true)
    public String getFilename(String executionKey) {
        ReportExec reportExec = (ReportExec)this.reportExecDAO.findById(executionKey).orElseThrow(() -> new NotFoundException("ReportExec " + executionKey));
        return reportExec.getReport().getName() + "." + Strings.CS.removeStart(reportExec.getReport().getFileExt(), (CharSequence)".");
    }

    @PreAuthorize(value="hasRole('REPORT_READ')")
    @Transactional(readOnly=true)
    public void exportExecutionResult(OutputStream os, String executionKey) {
        ReportExec reportExec = (ReportExec)this.reportExecDAO.findById(executionKey).orElseThrow(() -> new NotFoundException("ReportExec " + executionKey));
        if (reportExec.getExecResult() == null || !ReportJob.Status.SUCCESS.name().equals(reportExec.getStatus())) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidReportExec);
            sce.getElements().add(reportExec.getExecResult() == null ? "No report data produced" : "Report did not run successfully");
            throw sce;
        }
        try (ByteArrayInputStream bais = new ByteArrayInputStream(reportExec.getExecResult());
             ZipInputStream zis = new ZipInputStream(bais);){
            zis.getNextEntry();
            zis.transferTo(os);
        }
        catch (Exception e) {
            LOG.error("While exporting content", (Throwable)e);
        }
    }

    @PreAuthorize(value="hasRole('REPORT_DELETE')")
    public ReportTO delete(String key) {
        Report report = (Report)this.reportDAO.findById(key).orElseThrow(() -> new NotFoundException("Report " + key));
        ReportTO deletedReport = this.binder.getReportTO(report);
        this.jobManager.unregister(report);
        this.reportDAO.delete((Entity)report);
        return deletedReport;
    }

    @Override
    @PreAuthorize(value="hasRole('REPORT_READ')")
    public Page<ExecTO> listExecutions(String key, OffsetDateTime before, OffsetDateTime after, Pageable pageable) {
        Report report = (Report)this.reportDAO.findById(key).orElseThrow(() -> new NotFoundException("Report " + key));
        long count = this.reportExecDAO.count(report, before, after);
        List<ExecTO> result = this.reportExecDAO.findAll(report, before, after, pageable).stream().map(arg_0 -> ((ReportDataBinder)this.binder).getExecTO(arg_0)).toList();
        return new SyncopePage(result, pageable, count);
    }

    @Override
    @PreAuthorize(value="hasRole('REPORT_LIST')")
    public List<ExecTO> listRecentExecutions(int max) {
        return this.reportExecDAO.findRecent(max).stream().map(arg_0 -> ((ReportDataBinder)this.binder).getExecTO(arg_0)).toList();
    }

    @Override
    @PreAuthorize(value="hasRole('REPORT_DELETE')")
    public ExecTO deleteExecution(String executionKey) {
        ReportExec reportExec = (ReportExec)this.reportExecDAO.findById(executionKey).orElseThrow(() -> new NotFoundException("ReportExec " + executionKey));
        ExecTO reportExecToDelete = this.binder.getExecTO(reportExec);
        this.reportExecDAO.delete((Entity)reportExec);
        return reportExecToDelete;
    }

    @Override
    @PreAuthorize(value="hasRole('REPORT_DELETE')")
    public List<BatchResponseItem> deleteExecutions(String key, OffsetDateTime before, OffsetDateTime after) {
        Report report = (Report)this.reportDAO.findById(key).orElseThrow(() -> new NotFoundException("Report " + key));
        ArrayList<BatchResponseItem> batchResponseItems = new ArrayList<BatchResponseItem>();
        this.reportExecDAO.findAll(report, before, after, Pageable.unpaged()).forEach(exec -> {
            BatchResponseItem item = new BatchResponseItem();
            item.getHeaders().put("X-Syncope-Key", List.of(exec.getKey()));
            batchResponseItems.add(item);
            try {
                this.reportExecDAO.delete((Entity)exec);
                item.setStatus(Response.Status.OK.getStatusCode());
            }
            catch (Exception e) {
                LOG.error("Error deleting execution {} of report {}", new Object[]{exec.getKey(), key, e});
                item.setStatus(Response.Status.BAD_REQUEST.getStatusCode());
                item.setContent(ExceptionUtils2.getFullStackTrace((Throwable)e));
            }
        });
        return batchResponseItems;
    }

    @Override
    protected AbstractJobLogic.JobReference getReference(String jobName) {
        return JobNamer.getReportKeyFromJobName((String)jobName).flatMap(arg_0 -> ((ReportDAO)this.reportDAO).findById(arg_0)).map(r -> new AbstractJobLogic.JobReference(JobType.REPORT, r.getKey(), this.binder.buildRefDesc(r))).orElse(null);
    }

    @Override
    @PreAuthorize(value="hasRole('REPORT_LIST')")
    public List<JobTO> listJobs() {
        return super.doListJobs(false);
    }

    @Override
    @PreAuthorize(value="hasRole('REPORT_READ')")
    public JobTO getJob(String key) {
        Report report = (Report)this.reportDAO.findById(key).orElseThrow(() -> new NotFoundException("Report " + key));
        return this.getJobTO(JobNamer.getJobName((Report)report), false).orElseThrow(() -> new NotFoundException("Job for report " + key));
    }

    @Override
    @PreAuthorize(value="hasRole('REPORT_EXECUTE')")
    public void actionJob(String key, JobAction action) {
        Report report = (Report)this.reportDAO.findById(key).orElseThrow(() -> new NotFoundException("Report " + key));
        this.doActionJob(JobNamer.getJobName((Report)report), action);
    }

    @Override
    protected ReportTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        String key = null;
        if (ArrayUtils.isNotEmpty((Object[])args) && ("create".equals(method.getName()) || "update".equals(method.getName()) || "delete".equals(method.getName()))) {
            for (int i = 0; key == null && i < args.length; ++i) {
                Object object = args[i];
                if (object instanceof String) {
                    String string;
                    key = string = (String)object;
                    continue;
                }
                object = args[i];
                if (!(object instanceof ReportTO)) continue;
                ReportTO reportTO = (ReportTO)object;
                key = reportTO.getKey();
            }
        }
        if (key != null) {
            try {
                return this.binder.getReportTO((Report)this.reportDAO.findById(key).orElseThrow());
            }
            catch (Throwable ignore) {
                LOG.debug("Unresolved reference", ignore);
                throw new UnresolvedReferenceException(ignore);
            }
        }
        throw new UnresolvedReferenceException();
    }
}

