/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apereo.cas.util.spring.RestActuatorControllerEndpoint;
import org.apereo.cas.util.spring.RestActuatorEndpointDiscoverer;
import org.apereo.cas.util.spring.RestActuatorEndpointHandlerMapping;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.CorsEndpointProperties;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementPortType;
import org.springframework.boot.actuate.endpoint.EndpointFilter;
import org.springframework.boot.actuate.endpoint.EndpointsSupplier;
import org.springframework.boot.actuate.endpoint.web.EndpointLinksResolver;
import org.springframework.boot.actuate.endpoint.web.EndpointMapping;
import org.springframework.boot.actuate.endpoint.web.EndpointMediaTypes;
import org.springframework.boot.actuate.endpoint.web.PathMapper;
import org.springframework.boot.actuate.endpoint.web.WebEndpointsSupplier;
import org.springframework.boot.actuate.endpoint.web.servlet.WebMvcEndpointHandlerMapping;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

@Configuration(value="CasCoreActuatorsConfiguration", proxyBeanMethods=false)
@Lazy(value=false)
class CasCoreActuatorsConfiguration {
    CasCoreActuatorsConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean(name={"restControllerEndpointDiscoverer"})
    public RestActuatorEndpointDiscoverer restControllerEndpointDiscoverer(ConfigurableApplicationContext applicationContext, ObjectProvider<PathMapper> endpointPathMappers, ObjectProvider<Collection<EndpointFilter<RestActuatorControllerEndpoint>>> filters) {
        return new RestActuatorEndpointDiscoverer((ApplicationContext)applicationContext, endpointPathMappers.orderedStream().toList(), (Collection)filters.getIfAvailable(Collections::emptyList));
    }

    @Bean
    public WebMvcEndpointHandlerMapping webEndpointServletHandlerMapping(EndpointLinksResolver endpointLinksResolver, WebEndpointsSupplier webEndpointsSupplier, @Qualifier(value="restControllerEndpointDiscoverer") EndpointsSupplier<RestActuatorControllerEndpoint> restEndpointsSupplier, EndpointMediaTypes endpointMediaTypes, CorsEndpointProperties corsProperties, WebEndpointProperties webEndpointProperties, Environment environment) {
        Collection webEndpoints = webEndpointsSupplier.getEndpoints();
        String basePath = webEndpointProperties.getBasePath();
        EndpointMapping endpointMapping = new EndpointMapping(basePath);
        boolean shouldRegisterLinksMapping = CasCoreActuatorsConfiguration.shouldRegisterLinksMapping(webEndpointProperties, environment, basePath);
        return new WebMvcEndpointHandlerMapping(endpointMapping, webEndpoints, endpointMediaTypes, corsProperties.toCorsConfiguration(), endpointLinksResolver, shouldRegisterLinksMapping);
    }

    @Bean
    public EndpointLinksResolver endpointLinksResolver(WebEndpointsSupplier webEndpointsSupplier, @Qualifier(value="restControllerEndpointDiscoverer") EndpointsSupplier<RestActuatorControllerEndpoint> restEndpointsSupplier, EndpointMediaTypes endpointMediaTypes, CorsEndpointProperties corsProperties, WebEndpointProperties webEndpointProperties) {
        String basePath = webEndpointProperties.getBasePath();
        ArrayList allEndpoints = new ArrayList();
        Collection webEndpoints = webEndpointsSupplier.getEndpoints();
        allEndpoints.addAll(webEndpoints);
        allEndpoints.addAll(restEndpointsSupplier.getEndpoints());
        return new EndpointLinksResolver(allEndpoints, basePath);
    }

    @Bean
    @ConditionalOnMissingBean(name={"restControllerEndpointHandlerMapping"})
    public RestActuatorEndpointHandlerMapping restControllerEndpointHandlerMapping(@Qualifier(value="restControllerEndpointDiscoverer") EndpointsSupplier<RestActuatorControllerEndpoint> restEndpointsSupplier, CorsEndpointProperties corsProperties, WebEndpointProperties webEndpointProperties) {
        EndpointMapping endpointMapping = new EndpointMapping(webEndpointProperties.getBasePath());
        return new RestActuatorEndpointHandlerMapping(endpointMapping, restEndpointsSupplier.getEndpoints(), corsProperties.toCorsConfiguration());
    }

    private static boolean shouldRegisterLinksMapping(WebEndpointProperties webEndpointProperties, Environment environment, String basePath) {
        return webEndpointProperties.getDiscovery().isEnabled() && (StringUtils.hasText((String)basePath) || ManagementPortType.get((Environment)environment) == ManagementPortType.DIFFERENT);
    }
}

