/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.app;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.util.app.ApplicationEntrypointInitializer;
import org.springframework.boot.context.metrics.buffering.BufferingApplicationStartup;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.metrics.ApplicationStartup;
import org.springframework.core.metrics.jfr.FlightRecorderApplicationStartup;

public final class ApplicationUtils {
    private static final int APPLICATION_EVENTS_CAPACITY = 5000;

    public static List<ApplicationEntrypointInitializer> getApplicationEntrypointInitializers() {
        return ServiceLoader.load(ApplicationEntrypointInitializer.class).stream().map(ServiceLoader.Provider::get).filter(Objects::nonNull).sorted((Comparator<ApplicationEntrypointInitializer>)AnnotationAwareOrderComparator.INSTANCE).collect(Collectors.toList());
    }

    public static ApplicationStartup getApplicationStartup() {
        String type = (String)StringUtils.defaultIfBlank((CharSequence)System.getProperty("CAS_APP_STARTUP"), (CharSequence)"default");
        if (StringUtils.equalsIgnoreCase((CharSequence)"jfr", (CharSequence)type)) {
            return new FlightRecorderApplicationStartup();
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)"buffering", (CharSequence)type)) {
            return new BufferingApplicationStartup(5000);
        }
        return ApplicationStartup.DEFAULT;
    }

    @Generated
    private ApplicationUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

