/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wicket.markup.html.form;

import de.agilecoders.wicket.core.markup.html.bootstrap.components.TooltipConfig;
import java.util.Iterator;
import java.util.List;
import org.apache.syncope.client.ui.commons.Constants;
import org.apache.syncope.client.ui.commons.ajax.form.IndicatorAjaxFormComponentUpdatingBehavior;
import org.apache.syncope.client.ui.commons.ajax.form.IndicatorAutoCompleteBehavior;
import org.apache.syncope.client.ui.commons.markup.html.form.FieldPanel;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AutoCompleteBehavior;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AutoCompleteSettings;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AutoCompleteTextField;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.IAutoCompleteRenderer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.validation.IValidator;

public class AjaxCharacterFieldPanel
extends FieldPanel<Character>
implements Cloneable {
    private static final long serialVersionUID = 238940918106696068L;
    private Component questionMarkJexlHelp;
    private List<Character> choices = List.of();

    public AjaxCharacterFieldPanel(String id, String name, IModel<Character> model) {
        this(id, name, model, true);
    }

    public AjaxCharacterFieldPanel(String id, String name, IModel<Character> model, boolean enableOnChange) {
        super(id, name, model);
        this.questionMarkJexlHelp = Constants.getJEXLPopover((Component)this, (TooltipConfig.Placement)TooltipConfig.Placement.right);
        this.add(new Component[]{this.questionMarkJexlHelp.setVisible(false)});
        AutoCompleteSettings settings = new AutoCompleteSettings();
        settings.setShowCompleteListOnFocusGain(true);
        settings.setShowListOnEmptyInput(true);
        settings.setCssClassName("custom-autocomplete-box");
        this.field = new AutoCompleteTextField<Character>("textField", model, settings){
            private static final long serialVersionUID = -6648767303091874219L;

            protected Iterator<Character> getChoices(String input) {
                return AjaxCharacterFieldPanel.this.getChoices(input);
            }

            protected AutoCompleteBehavior<Character> newAutoCompleteBehavior(IAutoCompleteRenderer<Character> renderer, AutoCompleteSettings settings) {
                return new IndicatorAutoCompleteBehavior<Character>(renderer, settings){
                    private static final long serialVersionUID = 1070808433195962931L;

                    protected Iterator<Character> getChoices(String input) {
                        return AjaxCharacterFieldPanel.this.getChoices(input);
                    }
                };
            }
        };
        this.add(new Component[]{this.field.setLabel((IModel)new ResourceModel(name, name)).setOutputMarkupId(true)});
        if (enableOnChange && !this.isReadOnly()) {
            this.field.add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior("change"){
                private static final long serialVersionUID = -1107858522700306810L;

                protected void onUpdate(AjaxRequestTarget target) {
                }
            }});
        }
    }

    public void addValidator(IValidator<? super Character> validator) {
        this.field.add(validator);
    }

    public void setChoices(List<Character> choices) {
        if (choices != null) {
            this.choices = choices;
        }
    }

    public FieldPanel<Character> enableJexlHelp() {
        this.questionMarkJexlHelp.setVisible(true);
        return this;
    }

    public FieldPanel<Character> enableJexlHelp(String ... jexlExamples) {
        this.questionMarkJexlHelp = Constants.getJEXLPopover((Component)this, (TooltipConfig.Placement)TooltipConfig.Placement.bottom, (String[])jexlExamples);
        this.addOrReplace(new Component[]{this.questionMarkJexlHelp.setVisible(true)});
        return this;
    }

    protected Iterator<Character> getChoices(String input) {
        return this.choices.stream().filter(choice -> input != null && input.length() > 0 && input.toCharArray()[0] == choice.charValue()).iterator();
    }

    public FieldPanel<Character> clone() {
        AjaxCharacterFieldPanel panel = (AjaxCharacterFieldPanel)super.clone();
        panel.setChoices(this.choices);
        return panel;
    }
}

