/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form;

import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;

public class PasswordTextField
extends TextField<String> {
    private static final long serialVersionUID = 1L;
    private boolean resetPassword = true;

    public PasswordTextField(String id) {
        this(id, (IModel<String>)null);
    }

    public PasswordTextField(String id, IModel<String> model) {
        super(id, model);
        this.setRequired(true);
        this.setType(String.class);
    }

    public final boolean getResetPassword() {
        return this.resetPassword;
    }

    public final PasswordTextField setResetPassword(boolean resetPassword) {
        this.resetPassword = resetPassword;
        return this;
    }

    @Override
    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        if (this.getResetPassword()) {
            tag.put("value", "");
        }
    }

    @Override
    protected String[] getInputTypes() {
        return new String[]{"password"};
    }

    @Override
    protected void onDetach() {
        if (this.resetPassword) {
            this.clearInput();
            if (this.getModel() != null) {
                this.getModel().setObject(null);
            }
        }
        super.onDetach();
    }
}

