/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.to;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import jakarta.ws.rs.PathParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.wa.GoogleMfaAuthAccount;
import org.apache.syncope.common.lib.wa.GoogleMfaAuthToken;
import org.apache.syncope.common.lib.wa.ImpersonationAccount;
import org.apache.syncope.common.lib.wa.MfaTrustedDevice;
import org.apache.syncope.common.lib.wa.WebAuthnDeviceCredential;

public class AuthProfileTO
implements EntityTO {
    private static final long serialVersionUID = -6543425997956703057L;
    private String key;
    private String owner;
    private final List<ImpersonationAccount> impersonationAccounts = new ArrayList<ImpersonationAccount>();
    private final List<GoogleMfaAuthToken> googleMfaAuthTokens = new ArrayList<GoogleMfaAuthToken>();
    private final List<GoogleMfaAuthAccount> googleMfaAuthAccounts = new ArrayList<GoogleMfaAuthAccount>();
    private final List<MfaTrustedDevice> mfaTrustedDevices = new ArrayList<MfaTrustedDevice>();
    private final List<WebAuthnDeviceCredential> webAuthnDeviceCredentials = new ArrayList<WebAuthnDeviceCredential>();

    public String getKey() {
        return this.key;
    }

    @PathParam(value="key")
    public void setKey(String key) {
        this.key = key;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    @JacksonXmlElementWrapper(localName="impersonationAccounts")
    @JacksonXmlProperty(localName="impersonationAccount")
    public List<ImpersonationAccount> getImpersonationAccounts() {
        return this.impersonationAccounts;
    }

    @JacksonXmlElementWrapper(localName="googleMfaAuthTokens")
    @JacksonXmlProperty(localName="googleMfaAuthToken")
    public List<GoogleMfaAuthToken> getGoogleMfaAuthTokens() {
        return this.googleMfaAuthTokens;
    }

    @JacksonXmlElementWrapper(localName="googleMfaAuthAccounts")
    @JacksonXmlProperty(localName="googleMfaAuthAccount")
    public List<GoogleMfaAuthAccount> getGoogleMfaAuthAccounts() {
        return this.googleMfaAuthAccounts;
    }

    @JacksonXmlElementWrapper(localName="mfaTrustedDevices")
    @JacksonXmlProperty(localName="mfaTrustedDevice")
    public List<MfaTrustedDevice> getMfaTrustedDevices() {
        return this.mfaTrustedDevices;
    }

    @JacksonXmlElementWrapper(localName="credentials")
    @JacksonXmlProperty(localName="credential")
    public List<WebAuthnDeviceCredential> getWebAuthnDeviceCredentials() {
        return this.webAuthnDeviceCredentials;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.key).append((Object)this.owner).append(this.impersonationAccounts).append(this.googleMfaAuthTokens).append(this.googleMfaAuthAccounts).append(this.mfaTrustedDevices).append(this.webAuthnDeviceCredentials).build();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AuthProfileTO other = (AuthProfileTO)obj;
        return new EqualsBuilder().append((Object)this.key, (Object)other.key).append((Object)this.owner, (Object)other.owner).append(this.impersonationAccounts, other.impersonationAccounts).append(this.googleMfaAuthTokens, other.googleMfaAuthTokens).append(this.googleMfaAuthAccounts, other.googleMfaAuthAccounts).append(this.mfaTrustedDevices, other.mfaTrustedDevices).append(this.webAuthnDeviceCredentials, other.webAuthnDeviceCredentials).build();
    }

    public static class Builder {
        private final AuthProfileTO instance = new AuthProfileTO();

        public Builder key(String key) {
            this.instance.setKey(key);
            return this;
        }

        public Builder owner(String owner) {
            this.instance.setOwner(owner);
            return this;
        }

        public Builder googleMfaAuthToken(GoogleMfaAuthToken token) {
            this.instance.getGoogleMfaAuthTokens().add(token);
            return this;
        }

        public Builder googleMfaAuthTokens(GoogleMfaAuthToken ... tokens) {
            this.instance.getGoogleMfaAuthTokens().addAll(List.of(tokens));
            return this;
        }

        public Builder googleMfaAuthTokens(Collection<GoogleMfaAuthToken> tokens) {
            this.instance.getGoogleMfaAuthTokens().addAll(tokens);
            return this;
        }

        public Builder googleMfaAuthAccount(GoogleMfaAuthAccount account) {
            this.instance.getGoogleMfaAuthAccounts().add(account);
            return this;
        }

        public Builder googleMfaAuthAccounts(GoogleMfaAuthAccount ... accounts) {
            this.instance.getGoogleMfaAuthAccounts().addAll(List.of(accounts));
            return this;
        }

        public Builder googleMfaAuthAccounts(Collection<GoogleMfaAuthAccount> accounts) {
            this.instance.getGoogleMfaAuthAccounts().addAll(accounts);
            return this;
        }

        public Builder mfaTrustedDevice(MfaTrustedDevice device) {
            this.instance.getMfaTrustedDevices().add(device);
            return this;
        }

        public Builder mfaTrustedDevices(MfaTrustedDevice ... devices) {
            this.instance.getMfaTrustedDevices().addAll(List.of(devices));
            return this;
        }

        public Builder mfaTrustedDevices(Collection<MfaTrustedDevice> devices) {
            this.instance.getMfaTrustedDevices().addAll(devices);
            return this;
        }

        public Builder credential(WebAuthnDeviceCredential credential) {
            this.instance.getWebAuthnDeviceCredentials().add(credential);
            return this;
        }

        public Builder credentials(WebAuthnDeviceCredential ... credentials) {
            this.instance.getWebAuthnDeviceCredentials().addAll(List.of(credentials));
            return this;
        }

        public Builder credentials(Collection<WebAuthnDeviceCredential> credentials) {
            this.instance.getWebAuthnDeviceCredentials().addAll(credentials);
            return this;
        }

        public AuthProfileTO build() {
            return this.instance;
        }
    }
}

