/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.handler;

import org.ldaptive.LdapEntry;
import org.ldaptive.LdapUtils;
import org.ldaptive.SearchResponse;
import org.ldaptive.SearchResultReference;
import org.ldaptive.handler.SearchResultHandler;

public class MergeResultHandler
implements SearchResultHandler {
    private static final int HASH_CODE_SEED = 857;

    @Override
    public SearchResponse apply(SearchResponse searchResponse) {
        return this.merge(searchResponse);
    }

    private SearchResponse merge(SearchResponse searchResponse) {
        SearchResponse merged = (SearchResponse)((SearchResponse.Builder)SearchResponse.builder().copy(searchResponse)).build();
        LdapEntry mergedEntry = null;
        for (LdapEntry entry : searchResponse.getEntries()) {
            if (mergedEntry == null) {
                mergedEntry = LdapEntry.copy(entry);
                continue;
            }
            mergedEntry.mergeAttributes(entry.getAttributes());
        }
        if (mergedEntry != null) {
            merged.addEntries(mergedEntry);
        }
        SearchResultReference mergedReference = null;
        for (SearchResultReference reference : searchResponse.getReferences()) {
            if (mergedReference == null) {
                mergedReference = SearchResultReference.copy(reference);
                continue;
            }
            mergedReference.addUris(reference.getUris());
        }
        if (mergedReference != null) {
            merged.addReferences(mergedReference);
        }
        return merged;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof MergeResultHandler;
    }

    public int hashCode() {
        return LdapUtils.computeHashCode(857, new Object[0]);
    }

    public String toString() {
        return "[" + this.getClass().getName() + "@" + this.hashCode() + "]";
    }
}

