/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.panels;

import java.io.Serializable;
import java.util.List;
import org.apache.syncope.client.enduser.SyncopeEnduserSession;
import org.apache.syncope.client.enduser.SyncopeWebApplication;
import org.apache.syncope.client.enduser.commons.ProvisioningUtils;
import org.apache.syncope.client.enduser.layout.UserFormLayoutInfo;
import org.apache.syncope.client.enduser.pages.BasePage;
import org.apache.syncope.client.enduser.pages.SelfResult;
import org.apache.syncope.client.enduser.panels.AnyFormPanel;
import org.apache.syncope.client.enduser.panels.any.Details;
import org.apache.syncope.client.enduser.panels.any.UserDetails;
import org.apache.syncope.client.enduser.rest.UserSelfRestClient;
import org.apache.syncope.client.ui.commons.layout.UserForm;
import org.apache.syncope.client.ui.commons.panels.WizardModalPanel;
import org.apache.syncope.client.ui.commons.wizards.AjaxWizard;
import org.apache.syncope.client.ui.commons.wizards.ModalPanelBuilder;
import org.apache.syncope.client.ui.commons.wizards.any.AnyWrapper;
import org.apache.syncope.client.ui.commons.wizards.any.UserWrapper;
import org.apache.syncope.common.lib.AnyOperations;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.request.UserUR;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.ExecStatus;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class UserFormPanel
extends AnyFormPanel
implements UserForm {
    private static final long serialVersionUID = 6763365006334514387L;
    @SpringBean
    protected UserSelfRestClient userSelfRestClient;

    public UserFormPanel(String id, UserTO userTO, List<String> anyTypeClasses, UserFormLayoutInfo formLayoutInfo, PageReference pageReference) {
        super(id, new UserWrapper(userTO), anyTypeClasses, formLayoutInfo, pageReference);
        UserWrapper modelObj = (UserWrapper)this.newModelObject();
        this.buildLayout(modelObj);
    }

    public UserFormPanel(String id, UserTO previousUserTO, UserTO userTO, List<String> anyTypeClasses, UserFormLayoutInfo formLayoutInfo, PageReference pageReference) {
        super(id, new UserWrapper(previousUserTO, userTO), anyTypeClasses, formLayoutInfo, pageReference);
        UserWrapper modelObj = (UserWrapper)this.newModelObject();
        this.setFormModel(modelObj);
        this.buildLayout(modelObj);
    }

    @Override
    protected Details<UserTO> addOptionalDetailsPanel(UserWrapper modelObject) {
        return new UserDetails("contentPanel", (UserWrapper)UserWrapper.class.cast(modelObject), this.pageRef);
    }

    @Override
    protected void onFormSubmit(AjaxRequestTarget target) {
        boolean checked = true;
        if (SyncopeWebApplication.get().isCaptchaEnabled()) {
            checked = this.captcha.check();
        }
        if (!checked) {
            SyncopeEnduserSession.get().error((Serializable)((Object)this.getString("captcha_error")));
            ((BasePage)this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
        } else {
            try {
                AnyWrapper updatedWrapper = (AnyWrapper)this.form.getModelObject();
                UserTO userTO = (UserTO)updatedWrapper.getInnerObject();
                this.fixPlainAttrs((AnyTO)userTO, (AnyTO)((UserWrapper)this.getOriginalItem()).getInnerObject());
                UserUR updateReq = AnyOperations.diff((UserTO)userTO, (UserTO)((UserTO)((UserWrapper)this.getOriginalItem()).getInnerObject()), (boolean)false);
                ProvisioningResult<UserTO> provisioningResult = updateReq.isEmpty() ? new ProvisioningResult<UserTO>() : this.userSelfRestClient.update(((UserTO)((UserWrapper)this.getOriginalItem()).getInnerObject()).getETagValue(), updateReq);
                this.setResponsePage((IRequestablePage)new SelfResult(provisioningResult, ProvisioningUtils.managePageParams((Component)this, "profile.change", !SyncopeWebApplication.get().isReportPropagationErrors() || provisioningResult.getPropagationStatuses().stream().allMatch(ps -> ExecStatus.SUCCESS == ps.getStatus()))));
            }
            catch (SyncopeClientException e) {
                LOG.error("While changing password for {}", (Object)SyncopeEnduserSession.get().getSelfTO().getUsername(), (Object)e);
                SyncopeEnduserSession.get().onException((Exception)((Object)e));
                ((BasePage)this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }
    }

    public IEventSink getEventSink() {
        return null;
    }

    public ModalPanelBuilder<AnyWrapper<UserTO>> setEventSink(IEventSink eventSink) {
        return null;
    }

    public ModalPanelBuilder<AnyWrapper<UserTO>> setItem(AnyWrapper<UserTO> item) {
        return null;
    }

    public AnyWrapper<UserTO> getDefaultItem() {
        return null;
    }

    public WizardModalPanel<AnyWrapper<UserTO>> build(String id, int index, AjaxWizard.Mode mode) {
        return null;
    }
}

