/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.ObjectUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.ticket.AbstractTicket;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.OAuth20Token;
import org.apereo.cas.ticket.Ticket;

public abstract class BaseOAuth20Token
extends AbstractTicket
implements OAuth20Token {
    private static final long serialVersionUID = -8072724186202305800L;
    private Set<String> scopes = new HashSet<String>(0);
    private Map<String, Map<String, Object>> claims = new HashMap<String, Map<String, Object>>(0);
    private Ticket ticketGrantingTicket;
    private Service service;
    private Authentication authentication;
    private String codeChallenge;
    private String codeChallengeMethod;
    private String clientId;
    private OAuth20ResponseTypes responseType;
    private OAuth20GrantTypes grantType;

    public BaseOAuth20Token(String id, @NonNull Service service, Authentication authentication, @NonNull ExpirationPolicy expirationPolicy, Ticket ticketGrantingTicket, @NonNull Collection<String> scopes, String codeChallenge, String codeChallengeMethod, String clientId, Map<String, Map<String, Object>> requestClaims, OAuth20ResponseTypes responseType, OAuth20GrantTypes grantType) {
        super(id, expirationPolicy);
        if (service == null) {
            throw new NullPointerException("service is marked non-null but is null");
        }
        if (expirationPolicy == null) {
            throw new NullPointerException("expirationPolicy is marked non-null but is null");
        }
        if (scopes == null) {
            throw new NullPointerException("scopes is marked non-null but is null");
        }
        this.service = service;
        this.authentication = authentication;
        this.ticketGrantingTicket = ticketGrantingTicket;
        this.codeChallenge = codeChallenge;
        this.codeChallengeMethod = codeChallengeMethod;
        this.clientId = clientId;
        this.responseType = responseType;
        this.grantType = grantType;
        this.scopes.addAll(scopes);
        this.claims.putAll(requestClaims);
    }

    public String getPrefix() {
        return "OC";
    }

    public Set<String> getScopes() {
        return (Set)ObjectUtils.defaultIfNull(this.scopes, new HashSet(0));
    }

    @Generated
    public BaseOAuth20Token() {
    }

    @Generated
    public Map<String, Map<String, Object>> getClaims() {
        return this.claims;
    }

    @Generated
    public Ticket getTicketGrantingTicket() {
        return this.ticketGrantingTicket;
    }

    @Generated
    public Service getService() {
        return this.service;
    }

    @Generated
    public Authentication getAuthentication() {
        return this.authentication;
    }

    @Generated
    public String getCodeChallenge() {
        return this.codeChallenge;
    }

    @Generated
    public String getCodeChallengeMethod() {
        return this.codeChallengeMethod;
    }

    @Generated
    public String getClientId() {
        return this.clientId;
    }

    @Generated
    public OAuth20ResponseTypes getResponseType() {
        return this.responseType;
    }

    @Generated
    public OAuth20GrantTypes getGrantType() {
        return this.grantType;
    }
}

