/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.response.callback;

import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20ConfigurationContext;
import org.apereo.cas.support.oauth.web.response.OAuth20AuthorizationRequest;
import org.apereo.cas.support.oauth.web.response.accesstoken.OAuth20TokenGeneratedResult;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRequestContext;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20AccessTokenResponseResult;
import org.apereo.cas.support.oauth.web.response.callback.BaseOAuth20AuthorizationResponseBuilder;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20AuthorizationModelAndViewBuilder;
import org.apereo.inspektr.audit.annotation.Audit;
import org.springframework.web.servlet.ModelAndView;

public class OAuth20ResourceOwnerCredentialsResponseBuilder<T extends OAuth20ConfigurationContext>
extends BaseOAuth20AuthorizationResponseBuilder<T> {
    public OAuth20ResourceOwnerCredentialsResponseBuilder(T configurationContext, OAuth20AuthorizationModelAndViewBuilder authorizationModelAndViewBuilder) {
        super(configurationContext, authorizationModelAndViewBuilder);
    }

    @Audit(action="OAUTH2_AUTHORIZATION_RESPONSE", actionResolverName="OAUTH2_AUTHORIZATION_RESPONSE_ACTION_RESOLVER", resourceResolverName="OAUTH2_AUTHORIZATION_RESPONSE_RESOURCE_RESOLVER")
    public ModelAndView build(AccessTokenRequestContext holder) throws Throwable {
        OAuth20TokenGeneratedResult accessTokenResult = this.configurationContext.getAccessTokenGenerator().generate(holder);
        Long accessTokenTimeout = this.determineAccessTokenTimeoutInSeconds(accessTokenResult);
        OAuth20AccessTokenResponseResult result = OAuth20AccessTokenResponseResult.builder().registeredService((RegisteredService)holder.getRegisteredService()).service(holder.getService()).accessTokenTimeout(accessTokenTimeout.longValue()).responseType(holder.getResponseType()).grantType(holder.getGrantType()).casProperties(this.configurationContext.getCasProperties()).generatedToken(accessTokenResult).userProfile(holder.getUserProfile()).build();
        this.configurationContext.getAccessTokenResponseGenerator().generate(result);
        return new ModelAndView();
    }

    protected Long determineAccessTokenTimeoutInSeconds(OAuth20TokenGeneratedResult accessTokenResult) {
        return OAuth20Utils.getAccessTokenTimeout(accessTokenResult);
    }

    public boolean supports(OAuth20AuthorizationRequest context) {
        return OAuth20Utils.isGrantType(context.getGrantType(), OAuth20GrantTypes.PASSWORD);
    }
}

