/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.adaptive.AdaptiveAuthenticationPolicy;
import org.apereo.cas.authentication.principal.DelegatedAuthenticationCredentialExtractor;
import org.apereo.cas.authentication.principal.DelegatedClientAuthenticationCredentialResolver;
import org.apereo.cas.authentication.principal.GroovyDelegatedClientAuthenticationCredentialResolver;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.SpringResourceProperties;
import org.apereo.cas.configuration.model.support.cookie.CookieProperties;
import org.apereo.cas.configuration.model.support.pac4j.Pac4jDelegatedAuthenticationCookieProperties;
import org.apereo.cas.logout.LogoutExecutionPlan;
import org.apereo.cas.logout.slo.SingleLogoutRequestExecutor;
import org.apereo.cas.multitenancy.TenantExtractor;
import org.apereo.cas.multitenancy.UnknownTenantException;
import org.apereo.cas.pac4j.client.ChainingDelegatedClientIdentityProviderRedirectionStrategy;
import org.apereo.cas.pac4j.client.DefaultDelegatedClientIdentityProviderRedirectionStrategy;
import org.apereo.cas.pac4j.client.DelegatedClientAuthenticationFailureEvaluator;
import org.apereo.cas.pac4j.client.DelegatedClientAuthenticationRequestCustomizer;
import org.apereo.cas.pac4j.client.DelegatedClientIdentityProviderRedirectionStrategy;
import org.apereo.cas.pac4j.client.DelegatedClientNameExtractor;
import org.apereo.cas.pac4j.client.DelegatedIdentityProviderFactory;
import org.apereo.cas.pac4j.client.DelegatedIdentityProviders;
import org.apereo.cas.pac4j.client.GroovyDelegatedClientAuthenticationRequestCustomizer;
import org.apereo.cas.pac4j.client.GroovyDelegatedClientIdentityProviderRedirectionStrategy;
import org.apereo.cas.pac4j.client.authz.DefaultDelegatedClientIdentityProviderAuthorizer;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.services.web.support.MappedExceptionErrorViewResolver;
import org.apereo.cas.support.pac4j.authentication.clients.DelegatedClientsEndpoint;
import org.apereo.cas.support.pac4j.authentication.clients.DelegatedClientsEndpointContributor;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.nativex.CasRuntimeHintsRegistrar;
import org.apereo.cas.util.scripting.ExecutableCompiledScript;
import org.apereo.cas.util.scripting.ExecutableCompiledScriptFactory;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.util.spring.boot.ConditionalOnMissingGraalVMNativeImage;
import org.apereo.cas.web.CasWebSecurityConfigurer;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.cookie.CookieValueManager;
import org.apereo.cas.web.flow.CasDefaultFlowUrlHandler;
import org.apereo.cas.web.flow.CasFlowHandlerAdapter;
import org.apereo.cas.web.flow.CasFlowHandlerMapping;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowExecutionPlan;
import org.apereo.cas.web.flow.CasWebflowExecutionPlanConfigurer;
import org.apereo.cas.web.flow.CasWebflowIdExtractor;
import org.apereo.cas.web.flow.CasWebflowLoginContextProvider;
import org.apereo.cas.web.flow.DefaultDelegatedClientAuthenticationWebflowManager;
import org.apereo.cas.web.flow.DefaultDelegatedClientAuthenticationWebflowStateContributor;
import org.apereo.cas.web.flow.DefaultDelegatedClientIdentityProviderConfigurationProducer;
import org.apereo.cas.web.flow.DelegatedAuthenticationSingleSignOnEvaluator;
import org.apereo.cas.web.flow.DelegatedAuthenticationWebflowConfigurer;
import org.apereo.cas.web.flow.DelegatedClientAuthenticationConfigurationContext;
import org.apereo.cas.web.flow.DelegatedClientAuthenticationWebflowManager;
import org.apereo.cas.web.flow.DelegatedClientAuthenticationWebflowStateContributor;
import org.apereo.cas.web.flow.DelegatedClientIdentityProviderAuthorizer;
import org.apereo.cas.web.flow.DelegatedClientIdentityProviderConfigurationGroovyPostProcessor;
import org.apereo.cas.web.flow.DelegatedClientIdentityProviderConfigurationPostProcessor;
import org.apereo.cas.web.flow.DelegatedClientIdentityProviderConfigurationProducer;
import org.apereo.cas.web.flow.DelegationWebflowUtils;
import org.apereo.cas.web.flow.SingleSignOnParticipationStrategy;
import org.apereo.cas.web.flow.actions.ConsumerExecutionAction;
import org.apereo.cas.web.flow.actions.DelegatedAuthenticationClientRetryAction;
import org.apereo.cas.web.flow.actions.DelegatedAuthenticationGenerateClientsAction;
import org.apereo.cas.web.flow.actions.DelegatedClientAuthenticationAction;
import org.apereo.cas.web.flow.actions.DelegatedClientAuthenticationCredentialSelectionAction;
import org.apereo.cas.web.flow.actions.DelegatedClientAuthenticationCredentialSelectionFinalizeAction;
import org.apereo.cas.web.flow.actions.DelegatedClientAuthenticationFailureAction;
import org.apereo.cas.web.flow.actions.DelegatedClientAuthenticationRedirectAction;
import org.apereo.cas.web.flow.actions.DelegatedClientAuthenticationStoreWebflowStateAction;
import org.apereo.cas.web.flow.actions.WebflowActionBeanSupplier;
import org.apereo.cas.web.flow.actions.logout.DelegatedAuthenticationClientLogoutAction;
import org.apereo.cas.web.flow.actions.logout.DelegatedAuthenticationIdentityProviderFinalizeLogoutAction;
import org.apereo.cas.web.flow.actions.logout.DelegatedAuthenticationIdentityProviderLogoutAction;
import org.apereo.cas.web.flow.configurer.CasMultifactorWebflowCustomizer;
import org.apereo.cas.web.flow.controller.DefaultDelegatedAuthenticationNavigationController;
import org.apereo.cas.web.flow.error.DefaultDelegatedClientAuthenticationFailureEvaluator;
import org.apereo.cas.web.flow.executor.WebflowExecutorFactory;
import org.apereo.cas.web.flow.resolver.CasDelegatingWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.apereo.cas.web.support.CookieUtils;
import org.apereo.cas.web.support.WebUtils;
import org.apereo.cas.web.support.gen.CookieRetrievingCookieGenerator;
import org.apereo.cas.web.support.mgmr.NoOpCookieValueManager;
import org.pac4j.core.context.session.SessionStore;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.web.WebProperties;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcProperties;
import org.springframework.boot.autoconfigure.web.servlet.error.ErrorViewResolver;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.web.servlet.HandlerAdapter;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.webflow.config.FlowDefinitionRegistryBuilder;
import org.springframework.webflow.context.servlet.FlowUrlHandler;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.FlowBuilder;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.FlowExecutionListener;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.executor.FlowExecutor;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.DelegatedAuthentication})
@Configuration(value="DelegatedAuthenticationWebflowConfiguration", proxyBeanMethods=false)
class DelegatedAuthenticationWebflowConfiguration {
    DelegatedAuthenticationWebflowConfiguration() {
    }

    @Configuration(value="DelegatedAuthenticationWebflowUserInterfaceConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class DelegatedAuthenticationWebflowUserInterfaceConfiguration {
        DelegatedAuthenticationWebflowUserInterfaceConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"delegatedAuthenticationCasWebflowLoginContextProvider"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowLoginContextProvider delegatedAuthenticationCasWebflowLoginContextProvider() {
            return new CasWebflowLoginContextProvider(this){

                public boolean isLoginFormViewable(RequestContext requestContext) {
                    return DelegationWebflowUtils.getDelegatedAuthenticationProviderPrimary((RequestContext)requestContext) == null;
                }
            };
        }
    }

    @Configuration(value="DelegatedAuthenticationWebflowEndpointsConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class DelegatedAuthenticationWebflowEndpointsConfiguration {
        private static final FlowExecutionListener[] FLOW_EXECUTION_LISTENERS = new FlowExecutionListener[0];

        DelegatedAuthenticationWebflowEndpointsConfiguration() {
        }

        @Bean
        @ConditionalOnAvailableEndpoint
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public DelegatedClientsEndpoint delegatedClientsEndpoint(CasConfigurationProperties casProperties, @Qualifier(value="pac4jDelegatedClientFactory") ObjectProvider<DelegatedIdentityProviderFactory> pac4jDelegatedIdentityProviderFactory, ObjectProvider<List<DelegatedClientsEndpointContributor>> contributors) {
            return new DelegatedClientsEndpoint(casProperties, pac4jDelegatedIdentityProviderFactory, contributors);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"defaultDelegatedAuthenticationNavigationController"})
        public DefaultDelegatedAuthenticationNavigationController defaultDelegatedAuthenticationNavigationController(@Qualifier(value="delegatedClientAuthenticationConfigurationContext") DelegatedClientAuthenticationConfigurationContext delegatedClientAuthenticationConfigurationContext) {
            return new DefaultDelegatedAuthenticationNavigationController(delegatedClientAuthenticationConfigurationContext);
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public FlowUrlHandler delegatedClientWebflowUrlHandler(List<CasWebflowIdExtractor> flowIdExtractors) {
            return new CasDefaultFlowUrlHandler(flowIdExtractors);
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public HandlerAdapter delegatedClientRedirectWebflowHandlerAdapter(@Qualifier(value="delegatedClientWebflowUrlHandler") FlowUrlHandler delegatedClientWebflowUrlHandler, ConfigurableApplicationContext applicationContext, @Qualifier(value="casWebflowExecutionPlan") CasWebflowExecutionPlan webflowExecutionPlan, @Qualifier(value="delegatedClientRedirectFlowExecutor") FlowExecutor delegatedClientRedirectFlowExecutor) {
            CasFlowHandlerAdapter handler = new CasFlowHandlerAdapter("clientredirect", webflowExecutionPlan);
            handler.setFlowExecutor(delegatedClientRedirectFlowExecutor);
            handler.setFlowUrlHandler(delegatedClientWebflowUrlHandler);
            return handler;
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public HandlerMapping delegatedClientRedirectFlowHandlerMapping(@Qualifier(value="delegatedClientRedirectFlowRegistry") FlowDefinitionRegistry delegatedClientRedirectFlowRegistry) {
            CasFlowHandlerMapping handler = new CasFlowHandlerMapping();
            handler.setOrder(0);
            handler.setFlowRegistry(delegatedClientRedirectFlowRegistry);
            return handler;
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public FlowDefinitionRegistry delegatedClientRedirectFlowRegistry(ConfigurableApplicationContext applicationContext, @Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices, @Qualifier(value="flowBuilder") FlowBuilder flowBuilder) {
            FlowDefinitionRegistryBuilder builder = new FlowDefinitionRegistryBuilder((ApplicationContext)applicationContext, flowBuilderServices);
            builder.addFlowBuilder(flowBuilder, "clientredirect");
            return builder.build();
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public FlowExecutor delegatedClientRedirectFlowExecutor(@Qualifier(value="delegatedClientWebflowUrlHandler") FlowUrlHandler delegatedClientWebflowUrlHandler, CasConfigurationProperties casProperties, @Qualifier(value="delegatedClientRedirectFlowRegistry") FlowDefinitionRegistry delegatedClientRedirectFlowRegistry, @Qualifier(value="webflowCipherExecutor") CipherExecutor webflowCipherExecutor) {
            WebflowExecutorFactory factory = new WebflowExecutorFactory(casProperties.getWebflow(), delegatedClientRedirectFlowRegistry, webflowCipherExecutor, FLOW_EXECUTION_LISTENERS, delegatedClientWebflowUrlHandler);
            return factory.build();
        }
    }

    @Configuration(value="DelegatedAuthenticationWebflowContextConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class DelegatedAuthenticationWebflowContextConfiguration {
        DelegatedAuthenticationWebflowContextConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"delegatedClientAuthenticationConfigurationContext"})
        public DelegatedClientAuthenticationConfigurationContext delegatedClientAuthenticationConfigurationContext(@Qualifier(value="defaultSingleLogoutRequestExecutor") SingleLogoutRequestExecutor defaultSingleLogoutRequestExecutor, @Qualifier(value="registeredServiceDelegatedAuthenticationPolicyAuditableEnforcer") AuditableExecution registeredServiceDelegatedAuthenticationPolicyAuditableEnforcer, @Qualifier(value="serviceTicketRequestWebflowEventResolver") CasWebflowEventResolver serviceTicketRequestWebflowEventResolver, @Qualifier(value="initialAuthenticationAttemptWebflowEventResolver") CasDelegatingWebflowEventResolver initialAuthenticationAttemptWebflowEventResolver, @Qualifier(value="adaptiveAuthenticationPolicy") AdaptiveAuthenticationPolicy adaptiveAuthenticationPolicy, CasConfigurationProperties casProperties, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="delegatedIdentityProviders") DelegatedIdentityProviders identityProviders, @Qualifier(value="delegatedClientIdentityProviderConfigurationProducer") DelegatedClientIdentityProviderConfigurationProducer delegatedClientIdentityProviderConfigurationProducer, @Qualifier(value="delegatedClientIdentityProviderConfigurationPostProcessor") DelegatedClientIdentityProviderConfigurationPostProcessor delegatedClientIdentityProviderConfigurationPostProcessor, @Qualifier(value="delegatedClientDistributedSessionCookieGenerator") CasCookieBuilder delegatedClientDistributedSessionCookieGenerator, @Qualifier(value="centralAuthenticationService") CentralAuthenticationService centralAuthenticationService, @Qualifier(value="pac4jDelegatedClientNameExtractor") DelegatedClientNameExtractor pac4jDelegatedClientNameExtractor, @Qualifier(value="defaultAuthenticationSystemSupport") AuthenticationSystemSupport authenticationSystemSupport, @Qualifier(value="argumentExtractor") ArgumentExtractor argumentExtractor, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry, @Qualifier(value="delegatedClientDistributedSessionStore") SessionStore delegatedClientDistributedSessionStore, @Qualifier(value="defaultTicketFactory") TicketFactory ticketFactory, @Qualifier(value="registeredServiceAccessStrategyEnforcer") AuditableExecution registeredServiceAccessStrategyEnforcer, @Qualifier(value="delegatedClientIdentityProviderRedirectionStrategy") DelegatedClientIdentityProviderRedirectionStrategy delegatedClientIdentityProviderRedirectionStrategy, @Qualifier(value="singleSignOnParticipationStrategy") SingleSignOnParticipationStrategy webflowSingleSignOnParticipationStrategy, @Qualifier(value="authenticationServiceSelectionPlan") AuthenticationServiceSelectionPlan authenticationRequestServiceSelectionStrategies, @Qualifier(value="delegatedAuthenticationCookieGenerator") CasCookieBuilder delegatedAuthenticationCookieGenerator, ObjectProvider<List<DelegatedAuthenticationCredentialExtractor>> delegatedAuthenticationCredentialExtractors, ConfigurableApplicationContext applicationContext, @Qualifier(value="logoutExecutionPlan") LogoutExecutionPlan logoutExecutionPlan, ObjectProvider<List<DelegatedClientAuthenticationRequestCustomizer>> customizersProvider, ObjectProvider<List<DelegatedClientIdentityProviderAuthorizer>> delegatedClientAuthorizers) {
            List customizers = Optional.ofNullable((List)customizersProvider.getIfAvailable()).orElseGet(ArrayList::new).stream().filter(BeanSupplier::isNotProxy).collect(Collectors.toList());
            List authorizers = Optional.ofNullable((List)delegatedClientAuthorizers.getIfAvailable()).orElseGet(ArrayList::new).stream().filter(BeanSupplier::isNotProxy).collect(Collectors.toList());
            List<DelegatedAuthenticationCredentialExtractor> extractors = ((List)delegatedAuthenticationCredentialExtractors.getObject()).stream().filter(BeanSupplier::isNotProxy).toList();
            return DelegatedClientAuthenticationConfigurationContext.builder().credentialExtractors(extractors).initialAuthenticationAttemptWebflowEventResolver(initialAuthenticationAttemptWebflowEventResolver).serviceTicketRequestWebflowEventResolver(serviceTicketRequestWebflowEventResolver).adaptiveAuthenticationPolicy(adaptiveAuthenticationPolicy).identityProviders(identityProviders).ticketRegistry(ticketRegistry).applicationContext(applicationContext).servicesManager(servicesManager).delegatedAuthenticationPolicyEnforcer(registeredServiceDelegatedAuthenticationPolicyAuditableEnforcer).authenticationSystemSupport(authenticationSystemSupport).casProperties(casProperties).centralAuthenticationService(centralAuthenticationService).authenticationRequestServiceSelectionStrategies(authenticationRequestServiceSelectionStrategies).singleSignOnParticipationStrategy(webflowSingleSignOnParticipationStrategy).sessionStore(delegatedClientDistributedSessionStore).argumentExtractor(argumentExtractor).ticketFactory(ticketFactory).delegatedClientIdentityProvidersProducer(delegatedClientIdentityProviderConfigurationProducer).delegatedClientIdentityProviderConfigurationPostProcessor(delegatedClientIdentityProviderConfigurationPostProcessor).delegatedClientCookieGenerator(delegatedAuthenticationCookieGenerator).delegatedClientDistributedSessionCookieGenerator(delegatedClientDistributedSessionCookieGenerator).registeredServiceAccessStrategyEnforcer(registeredServiceAccessStrategyEnforcer).delegatedClientAuthenticationRequestCustomizers(customizers).delegatedClientNameExtractor(pac4jDelegatedClientNameExtractor).delegatedClientIdentityProviderAuthorizers(authorizers).delegatedClientIdentityProviderRedirectionStrategy(delegatedClientIdentityProviderRedirectionStrategy).singleLogoutRequestExecutor(defaultSingleLogoutRequestExecutor).logoutExecutionPlan(logoutExecutionPlan).build();
        }
    }

    @Configuration(value="DelegatedAuthenticationWebflowActionsConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class DelegatedAuthenticationWebflowActionsConfiguration {
        DelegatedAuthenticationWebflowActionsConfiguration() {
        }

        @ConditionalOnMissingBean(name={"delegatedAuthenticationClientCredentialSelectionFinalizeAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action delegatedAuthenticationClientCredentialSelectionFinalizeAction(@Qualifier(value="delegatedClientAuthenticationConfigurationContext") DelegatedClientAuthenticationConfigurationContext context, CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new DelegatedClientAuthenticationCredentialSelectionFinalizeAction(context)).withId("delegatedAuthenticationClientCredentialSelectionFinalizeAction").build().get();
        }

        @ConditionalOnMissingBean(name={"delegatedAuthenticationClientCredentialSelectionAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action delegatedAuthenticationClientCredentialSelectionAction(@Qualifier(value="delegatedClientAuthenticationConfigurationContext") DelegatedClientAuthenticationConfigurationContext context, CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new DelegatedClientAuthenticationCredentialSelectionAction(context)).withId("delegatedAuthenticationClientCredentialSelectionAction").build().get();
        }

        @ConditionalOnMissingBean(name={"delegatedAuthenticationFailureAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action delegatedAuthenticationFailureAction(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="delegatedClientAuthenticationFailureEvaluator") DelegatedClientAuthenticationFailureEvaluator delegatedClientAuthenticationFailureEvaluator) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new DelegatedClientAuthenticationFailureAction(delegatedClientAuthenticationFailureEvaluator)).withId("delegatedAuthenticationFailureAction").build().get();
        }

        @ConditionalOnMissingBean(name={"delegatedAuthenticationRedirectToClientAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action delegatedAuthenticationRedirectToClientAction(@Qualifier(value="delegatedClientWebflowManager") DelegatedClientAuthenticationWebflowManager delegatedClientWebflowManager, @Qualifier(value="delegatedClientAuthenticationConfigurationContext") DelegatedClientAuthenticationConfigurationContext delegatedClientAuthenticationConfigurationContext, CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new DelegatedClientAuthenticationRedirectAction(delegatedClientAuthenticationConfigurationContext, delegatedClientWebflowManager)).withId("delegatedAuthenticationRedirectToClientAction").build().get();
        }

        @ConditionalOnMissingBean(name={"delegatedAuthenticationStoreWebflowAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action delegatedAuthenticationStoreWebflowAction(@Qualifier(value="delegatedClientWebflowManager") DelegatedClientAuthenticationWebflowManager delegatedClientWebflowManager, @Qualifier(value="delegatedClientAuthenticationConfigurationContext") DelegatedClientAuthenticationConfigurationContext delegatedClientAuthenticationConfigurationContext, CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new DelegatedClientAuthenticationStoreWebflowStateAction(delegatedClientAuthenticationConfigurationContext, delegatedClientWebflowManager)).withId("delegatedAuthenticationStoreWebflowAction").build().get();
        }

        @ConditionalOnMissingBean(name={"delegatedAuthenticationIdentityProviderLogoutAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action delegatedAuthenticationIdentityProviderLogoutAction(@Qualifier(value="delegatedClientAuthenticationConfigurationContext") DelegatedClientAuthenticationConfigurationContext delegatedClientAuthenticationConfigurationContext, CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new DelegatedAuthenticationIdentityProviderLogoutAction(delegatedClientAuthenticationConfigurationContext)).withId("delegatedAuthenticationIdentityProviderLogoutAction").build().get();
        }

        @ConditionalOnMissingBean(name={"delegatedAuthenticationIdentityProviderFinalizeLogoutAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action delegatedAuthenticationIdentityProviderFinalizeLogoutAction(@Qualifier(value="delegatedClientAuthenticationConfigurationContext") DelegatedClientAuthenticationConfigurationContext delegatedClientAuthenticationConfigurationContext, CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new DelegatedAuthenticationIdentityProviderFinalizeLogoutAction(delegatedClientAuthenticationConfigurationContext)).withId("delegatedAuthenticationIdentityProviderFinalizeLogoutAction").build().get();
        }

        @ConditionalOnMissingBean(name={"delegatedAuthenticationClientLogoutAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action delegatedAuthenticationClientLogoutAction(@Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry, CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="delegatedIdentityProviders") DelegatedIdentityProviders identityProviders, @Qualifier(value="delegatedClientDistributedSessionStore") SessionStore delegatedClientDistributedSessionStore) {
            return (Action)BeanSupplier.of(Action.class).when(BeanCondition.on((String)"cas.slo.disabled").isFalse().evenIfMissing().given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new DelegatedAuthenticationClientLogoutAction(identityProviders, delegatedClientDistributedSessionStore, ticketRegistry)).withId("delegatedAuthenticationClientLogoutAction").build().get()).otherwise(() -> ConsumerExecutionAction.NONE).get();
        }

        @ConditionalOnMissingBean(name={"delegatedAuthenticationClientRetryAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action delegatedAuthenticationClientRetryAction(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="delegatedClientIdentityProviderConfigurationProducer") DelegatedClientIdentityProviderConfigurationProducer delegatedClientIdentityProviderConfigurationProducer, @Qualifier(value="delegatedIdentityProviders") DelegatedIdentityProviders identityProviders) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new DelegatedAuthenticationClientRetryAction(identityProviders, delegatedClientIdentityProviderConfigurationProducer)).withId("delegatedAuthenticationClientRetryAction").build().get();
        }

        @Bean
        @ConditionalOnMissingBean(name={"delegatedAuthenticationCreateClientsAction"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action delegatedAuthenticationCreateClientsAction(@Qualifier(value="delegatedClientAuthenticationConfigurationContext") DelegatedClientAuthenticationConfigurationContext delegatedClientAuthenticationConfigurationContext, CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> {
                DelegatedAuthenticationSingleSignOnEvaluator ssoEval = new DelegatedAuthenticationSingleSignOnEvaluator(delegatedClientAuthenticationConfigurationContext);
                return new DelegatedAuthenticationGenerateClientsAction(ssoEval);
            }).withId("delegatedAuthenticationCreateClientsAction").build().get();
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"delegatedAuthenticationAction"})
        @Bean
        public Action delegatedAuthenticationAction(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="delegatedClientAuthenticationFailureEvaluator") DelegatedClientAuthenticationFailureEvaluator delegatedClientAuthenticationFailureEvaluator, @Qualifier(value="delegatedClientAuthenticationConfigurationContext") DelegatedClientAuthenticationConfigurationContext delegatedClientAuthenticationConfigurationContext, @Qualifier(value="delegatedClientWebflowManager") DelegatedClientAuthenticationWebflowManager delegatedClientWebflowManager) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new DelegatedClientAuthenticationAction(delegatedClientAuthenticationConfigurationContext, delegatedClientWebflowManager, delegatedClientAuthenticationFailureEvaluator)).withId("delegatedAuthenticationAction").build().get();
        }
    }

    @Configuration(value="DelegatedAuthenticationWebflowClientConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class DelegatedAuthenticationWebflowClientConfiguration {
        DelegatedAuthenticationWebflowClientConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"delegatedClientEndpointConfigurer"})
        public CasWebSecurityConfigurer<Void> delegatedClientEndpointConfigurer() {
            return new CasWebSecurityConfigurer<Void>(this){

                public List<String> getIgnoredEndpoints() {
                    return List.of(StringUtils.prependIfMissing((String)"clientredirect", (CharSequence)"/", (CharSequence[])new CharSequence[0]));
                }
            };
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"groovyDelegatedClientAuthenticationCredentialResolver"})
        @ConditionalOnMissingGraalVMNativeImage
        public DelegatedClientAuthenticationCredentialResolver groovyDelegatedClientAuthenticationCredentialResolver(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="delegatedClientAuthenticationConfigurationContext") DelegatedClientAuthenticationConfigurationContext configContext) {
            return (DelegatedClientAuthenticationCredentialResolver)BeanSupplier.of(DelegatedClientAuthenticationCredentialResolver.class).when(BeanCondition.on((String)"cas.authn.pac4j.profile-selection.groovy.location").exists().given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                Resource resource = casProperties.getAuthn().getPac4j().getProfileSelection().getGroovy().getLocation();
                return new GroovyDelegatedClientAuthenticationCredentialResolver(configContext, resource);
            }).otherwiseProxy().get();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"delegatedClientIdentityProviderAuthorizer"})
        public DelegatedClientIdentityProviderAuthorizer delegatedClientIdentityProviderAuthorizer(@Qualifier(value="tenantExtractor") TenantExtractor tenantExtractor, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="registeredServiceDelegatedAuthenticationPolicyAuditableEnforcer") AuditableExecution registeredServiceDelegatedAuthenticationPolicyAuditableEnforcer) {
            return new DefaultDelegatedClientIdentityProviderAuthorizer(servicesManager, registeredServiceDelegatedAuthenticationPolicyAuditableEnforcer, tenantExtractor);
        }

        @Bean
        @ConditionalOnMissingBean(name={"delegatedClientAuthenticationFailureEvaluator"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public DelegatedClientAuthenticationFailureEvaluator delegatedClientAuthenticationFailureEvaluator(@Qualifier(value="delegatedClientAuthenticationConfigurationContext") DelegatedClientAuthenticationConfigurationContext configContext) {
            return new DefaultDelegatedClientAuthenticationFailureEvaluator(configContext);
        }

        @Bean
        @ConditionalOnMissingBean(name={"delegatedClientIdentityProviderConfigurationPostProcessor"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public DelegatedClientIdentityProviderConfigurationPostProcessor delegatedClientIdentityProviderConfigurationPostProcessor(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return (DelegatedClientIdentityProviderConfigurationPostProcessor)BeanSupplier.of(DelegatedClientIdentityProviderConfigurationPostProcessor.class).when(BeanCondition.on((String)"cas.authn.pac4j.core.groovy-provider-post-processor.location").exists().given((PropertyResolver)applicationContext.getEnvironment())).and(CasRuntimeHintsRegistrar::notInNativeImage).supply(() -> {
                Resource resource = casProperties.getAuthn().getPac4j().getCore().getGroovyProviderPostProcessor().getLocation();
                ExecutableCompiledScriptFactory scriptFactory = ExecutableCompiledScriptFactory.getExecutableCompiledScriptFactory();
                return new DelegatedClientIdentityProviderConfigurationGroovyPostProcessor(scriptFactory.fromResource(resource));
            }).otherwise(DelegatedClientIdentityProviderConfigurationPostProcessor::noOp).get();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"delegatedClientIdentityProviderConfigurationProducer"})
        public DelegatedClientIdentityProviderConfigurationProducer delegatedClientIdentityProviderConfigurationProducer(@Qualifier(value="delegatedClientAuthenticationConfigurationContext") ObjectProvider<DelegatedClientAuthenticationConfigurationContext> configurationContext) {
            return new DefaultDelegatedClientIdentityProviderConfigurationProducer(configurationContext);
        }

        @ConditionalOnMissingBean(name={"delegatedClientIdentityProviderRedirectionStrategy"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public DelegatedClientIdentityProviderRedirectionStrategy delegatedClientIdentityProviderRedirectionStrategy(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="delegatedAuthenticationCookieGenerator") CasCookieBuilder delegatedAuthenticationCookieGenerator, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
            ChainingDelegatedClientIdentityProviderRedirectionStrategy chain = new ChainingDelegatedClientIdentityProviderRedirectionStrategy();
            SpringResourceProperties strategy = casProperties.getAuthn().getPac4j().getCore().getGroovyRedirectionStrategy();
            FunctionUtils.doIfNotNull((Object)strategy.getLocation(), resource -> {
                ExecutableCompiledScriptFactory scriptFactory = ExecutableCompiledScriptFactory.getExecutableCompiledScriptFactory();
                chain.addStrategy((DelegatedClientIdentityProviderRedirectionStrategy)new GroovyDelegatedClientIdentityProviderRedirectionStrategy(servicesManager, scriptFactory.fromResource(resource), (ApplicationContext)applicationContext));
            });
            chain.addStrategy((DelegatedClientIdentityProviderRedirectionStrategy)new DefaultDelegatedClientIdentityProviderRedirectionStrategy(servicesManager, delegatedAuthenticationCookieGenerator, casProperties, applicationContext));
            return chain;
        }

        @ConditionalOnMissingBean(name={"delegatedAuthenticationCookieGenerator"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasCookieBuilder delegatedAuthenticationCookieGenerator(@Qualifier(value="tenantExtractor") TenantExtractor tenantExtractor, CasConfigurationProperties casProperties) {
            Pac4jDelegatedAuthenticationCookieProperties props = casProperties.getAuthn().getPac4j().getCookie();
            return new CookieRetrievingCookieGenerator(CookieUtils.buildCookieGenerationContext((CookieProperties)props), (CookieValueManager)new NoOpCookieValueManager(tenantExtractor));
        }

        @ConditionalOnMissingBean(name={"groovyDelegatedClientAuthenticationRequestCustomizer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingGraalVMNativeImage
        public DelegatedClientAuthenticationRequestCustomizer groovyDelegatedClientAuthenticationRequestCustomizer(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return (DelegatedClientAuthenticationRequestCustomizer)BeanSupplier.of(DelegatedClientAuthenticationRequestCustomizer.class).when(BeanCondition.on((String)"cas.authn.pac4j.core.groovy-authentication-request-customizer.location").exists().given((PropertyResolver)applicationContext.getEnvironment())).when(ExecutableCompiledScriptFactory.findExecutableCompiledScriptFactory().isPresent()).supply(() -> {
                SpringResourceProperties groovy = casProperties.getAuthn().getPac4j().getCore().getGroovyAuthenticationRequestCustomizer();
                ExecutableCompiledScriptFactory scriptFactory = ExecutableCompiledScriptFactory.getExecutableCompiledScriptFactory();
                ExecutableCompiledScript script = scriptFactory.fromResource(groovy.getLocation());
                return new GroovyDelegatedClientAuthenticationRequestCustomizer(script, (ApplicationContext)applicationContext);
            }).otherwiseProxy().get();
        }
    }

    @Configuration(value="DelegatedAuthenticationWebflowManagementConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class DelegatedAuthenticationWebflowManagementConfiguration {
        DelegatedAuthenticationWebflowManagementConfiguration() {
        }

        @ConditionalOnMissingBean(name={"delegatedClientWebflowManager"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public DelegatedClientAuthenticationWebflowManager delegatedClientWebflowManager(@Qualifier(value="delegatedClientAuthenticationConfigurationContext") DelegatedClientAuthenticationConfigurationContext delegatedClientAuthenticationConfigurationContext) {
            return new DefaultDelegatedClientAuthenticationWebflowManager(delegatedClientAuthenticationConfigurationContext);
        }

        @ConditionalOnMissingBean(name={"defaultDelegatedClientAuthenticationWebflowStateContributor"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public DelegatedClientAuthenticationWebflowStateContributor defaultDelegatedClientAuthenticationWebflowStateContributor(@Qualifier(value="delegatedClientAuthenticationConfigurationContext") DelegatedClientAuthenticationConfigurationContext delegatedClientAuthenticationConfigurationContext) {
            return new DefaultDelegatedClientAuthenticationWebflowStateContributor(delegatedClientAuthenticationConfigurationContext);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"delegatedAuthenticationCasMultifactorWebflowCustomizer"})
        public CasMultifactorWebflowCustomizer delegatedAuthenticationCasMultifactorWebflowCustomizer() {
            return new CasMultifactorWebflowCustomizer(this){

                public Collection<String> getCandidateStatesForMultifactorAuthentication() {
                    return List.of("delegatedAuthentication");
                }
            };
        }
    }

    @Configuration(value="DelegatedAuthenticationWebflowPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class DelegatedAuthenticationWebflowPlanConfiguration {
        DelegatedAuthenticationWebflowPlanConfiguration() {
        }

        @ConditionalOnMissingBean(name={"delegatedAuthenticationWebflowConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowConfigurer delegatedAuthenticationWebflowConfigurer(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="delegatedClientRedirectFlowRegistry") FlowDefinitionRegistry delegatedClientRedirectFlowRegistry, @Qualifier(value="flowDefinitionRegistry") FlowDefinitionRegistry flowDefinitionRegistry, @Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices) {
            return new DelegatedAuthenticationWebflowConfigurer(flowBuilderServices, flowDefinitionRegistry, delegatedClientRedirectFlowRegistry, applicationContext, casProperties);
        }
    }

    @Configuration(value="DelegatedAuthenticationWebflowExecutionPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class DelegatedAuthenticationWebflowExecutionPlanConfiguration {
        DelegatedAuthenticationWebflowExecutionPlanConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"delegatedCasWebflowExecutionPlanConfigurer"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowExecutionPlanConfigurer delegatedCasWebflowExecutionPlanConfigurer(@Qualifier(value="delegatedAuthenticationCasWebflowLoginContextProvider") CasWebflowLoginContextProvider delegatedAuthenticationCasWebflowLoginContextProvider, @Qualifier(value="delegatedAuthenticationWebflowConfigurer") CasWebflowConfigurer delegatedAuthenticationWebflowConfigurer) {
            return plan -> {
                plan.registerWebflowConfigurer(delegatedAuthenticationWebflowConfigurer);
                plan.registerWebflowLoginContextProvider(delegatedAuthenticationCasWebflowLoginContextProvider);
            };
        }
    }

    @Configuration(value="DelegatedAuthenticationWebflowErrorConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class, WebProperties.class, WebMvcProperties.class})
    static class DelegatedAuthenticationWebflowErrorConfiguration {
        DelegatedAuthenticationWebflowErrorConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"delegatedAuthenticationErrorViewResolver"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ErrorViewResolver delegatedAuthenticationErrorViewResolver(@Qualifier(value="delegatedClientAuthenticationFailureEvaluator") DelegatedClientAuthenticationFailureEvaluator delegatedClientAuthenticationFailureEvaluator, WebProperties webProperties, ConfigurableApplicationContext applicationContext) {
            Map<Class<UnknownTenantException>, ModelAndView> mappings = Map.of(UnauthorizedServiceException.class, WebUtils.toModelAndView((HttpStatus)HttpStatus.FORBIDDEN, (String)"delegated-authn/casDelegatedAuthnErrorView"), UnknownTenantException.class, WebUtils.toModelAndView((HttpStatus)HttpStatus.NOT_FOUND, (String)"error/casUnknownTenantView"));
            MappedExceptionErrorViewResolver resolver = new MappedExceptionErrorViewResolver((ApplicationContext)applicationContext, webProperties.getResources(), mappings, errorContext -> delegatedClientAuthenticationFailureEvaluator.evaluate(errorContext.request(), errorContext.status().value()));
            resolver.setOrder(0);
            return resolver;
        }
    }
}

