/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.kendo.ui.datatable.button;

import java.util.List;
import org.apache.wicket.ajax.attributes.CallbackParameter;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Generics;
import org.apache.wicket.util.string.Strings;
import org.wicketstuff.jquery.core.JQueryEvent;
import org.wicketstuff.jquery.core.ajax.IJQueryAjaxAware;
import org.wicketstuff.jquery.core.ajax.JQueryAjaxBehavior;
import org.wicketstuff.jquery.core.utils.RequestCycleUtils;
import org.wicketstuff.kendo.ui.datatable.button.ToolbarButton;

public class ToolbarAjaxBehavior
extends JQueryAjaxBehavior {
    private static final long serialVersionUID = 1L;
    private final ToolbarButton button;

    public ToolbarAjaxBehavior(IJQueryAjaxAware source) {
        this(source, null);
    }

    public ToolbarAjaxBehavior(IJQueryAjaxAware source, ToolbarButton button) {
        super(source);
        this.button = (ToolbarButton)Args.notNull((Object)button, (String)"button");
    }

    public String getButtonName() {
        return this.button.getName();
    }

    protected CallbackParameter[] getCallbackParameters() {
        return new CallbackParameter[]{CallbackParameter.context((String)"e"), CallbackParameter.resolved((String)"values", (String)"values")};
    }

    public CharSequence getCallbackFunctionBody(CallbackParameter ... parameters) {
        String property = this.button.getProperty();
        Object statement = "var values = [];\n";
        if (property != null) {
            statement = (String)statement + "var $grid = jQuery(e.target).closest('.k-grid').data('kendoGrid');\n";
            statement = (String)statement + "jQuery.each($grid.select(), function(index, row) { values.push($grid.dataItem(row)." + property + "); }\n";
            statement = (String)statement + ");\n";
        }
        return (String)statement + String.valueOf(super.getCallbackFunctionBody(parameters));
    }

    protected JQueryEvent newEvent() {
        return new ToolbarClickEvent(this.button);
    }

    public static class ToolbarClickEvent
    extends JQueryEvent {
        private final ToolbarButton button;
        private final List<String> values;

        public ToolbarClickEvent(ToolbarButton button) {
            this.button = button;
            this.values = Generics.newArrayList();
            String values = RequestCycleUtils.getQueryParameterValue((String)"values").toString("");
            if (!Strings.isEmpty((String)values)) {
                for (String value : values.split(",")) {
                    this.values.add(value);
                }
            }
        }

        public ToolbarButton getButton() {
            return this.button;
        }

        public List<String> getValues() {
            return this.values;
        }
    }
}

