/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cqengine.query.logical;

import com.googlecode.cqengine.query.Query;
import com.googlecode.cqengine.query.logical.LogicalQuery;
import com.googlecode.cqengine.query.option.QueryOptions;
import java.util.Collection;
import java.util.Iterator;

public class And<O>
extends LogicalQuery<O> {
    public And(Collection<Query<O>> childQueries) {
        super(childQueries);
        if (this.size() < 2) {
            throw new IllegalStateException("An 'And' query cannot have fewer than 2 child queries, " + childQueries.size() + " were supplied");
        }
    }

    @Override
    public boolean matches(O object, QueryOptions queryOptions) {
        if (super.hasComparativeQueries()) {
            throw new UnsupportedOperationException("This method is not supported on logical queries which encapsulate comparative queries");
        }
        for (Query query : super.getSimpleQueries()) {
            if (query.matches(object, queryOptions)) continue;
            return false;
        }
        for (Query<O> query : super.getLogicalQueries()) {
            if (query.matches(object, queryOptions)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof And)) {
            return false;
        }
        And and = (And)o;
        return this.childQueries.equals(and.childQueries);
    }

    @Override
    protected int calcHashCode() {
        return this.childQueries.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("and(");
        Iterator iterator = this.childQueries.iterator();
        while (iterator.hasNext()) {
            Query childQuery = (Query)iterator.next();
            sb.append(childQuery);
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }
}

