/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cqengine.query.comparative;

import com.googlecode.cqengine.attribute.Attribute;
import com.googlecode.cqengine.attribute.SimpleAttribute;
import com.googlecode.cqengine.persistence.support.ObjectSet;
import com.googlecode.cqengine.query.ComparativeQuery;
import com.googlecode.cqengine.query.option.QueryOptions;

public abstract class SimpleComparativeQuery<O, A>
implements ComparativeQuery<O, A> {
    protected final boolean attributeIsSimple;
    protected final Attribute<O, A> attribute;
    protected final SimpleAttribute<O, A> simpleAttribute;
    private transient int cachedHashCode = 0;

    public SimpleComparativeQuery(Attribute<O, A> attribute) {
        if (attribute == null) {
            throw new IllegalArgumentException("The attribute argument was null.");
        }
        this.attribute = attribute;
        if (attribute instanceof SimpleAttribute) {
            this.attributeIsSimple = true;
            this.simpleAttribute = (SimpleAttribute)attribute;
        } else {
            this.attributeIsSimple = false;
            this.simpleAttribute = null;
        }
    }

    public Class<A> getAttributeType() {
        return this.attribute.getAttributeType();
    }

    public String getAttributeName() {
        return this.attribute.getAttributeName();
    }

    @Override
    public Attribute<O, A> getAttribute() {
        return this.attribute;
    }

    public int hashCode() {
        int h = this.cachedHashCode;
        if (h == 0) {
            h = this.calcHashCode();
            if (h == 0) {
                h = -1838660945;
            }
            this.cachedHashCode = h;
        }
        return h;
    }

    protected abstract int calcHashCode();

    @Override
    public Iterable<O> getMatches(ObjectSet<O> objectsInCollection, QueryOptions queryOptions) {
        return this.attributeIsSimple ? this.getMatchesForSimpleAttribute(this.simpleAttribute, objectsInCollection, queryOptions) : this.getMatchesForNonSimpleAttribute(this.attribute, objectsInCollection, queryOptions);
    }

    public abstract Iterable<O> getMatchesForSimpleAttribute(SimpleAttribute<O, A> var1, ObjectSet<O> var2, QueryOptions var3);

    public abstract Iterable<O> getMatchesForNonSimpleAttribute(Attribute<O, A> var1, ObjectSet<O> var2, QueryOptions var3);
}

