/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.inspektr.common.web;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import lombok.Generated;
import org.apereo.cas.multitenancy.TenantDefinition;
import org.apereo.cas.multitenancy.TenantExtractor;
import org.apereo.inspektr.common.web.ClientInfo;
import org.apereo.inspektr.common.web.ClientInfoExtractionOptions;
import org.apereo.inspektr.common.web.ClientInfoHolder;

public class ClientInfoThreadLocalFilter
implements Filter {
    private final ClientInfoExtractionOptions options;
    private final TenantExtractor tenantExtractor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        try {
            if (request instanceof HttpServletRequest) {
                HttpServletRequest httpServletRequest = (HttpServletRequest)request;
                String tenantId = this.tenantExtractor.extract(httpServletRequest).map(TenantDefinition::getId).orElse(null);
                ClientInfo clientInfo = ClientInfo.from((HttpServletRequest)httpServletRequest, (ClientInfoExtractionOptions)this.options).setTenant(tenantId);
                ClientInfoHolder.setClientInfo((ClientInfo)clientInfo);
            }
            filterChain.doFilter(request, response);
        }
        finally {
            ClientInfoHolder.clear();
        }
    }

    @Generated
    public ClientInfoThreadLocalFilter(ClientInfoExtractionOptions options, TenantExtractor tenantExtractor) {
        this.options = options;
        this.tenantExtractor = tenantExtractor;
    }
}

