/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.egrid.component;

import java.io.Serializable;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.FormComponent;

public abstract class EditableTableSubmitLink
extends AjaxSubmitLink {
    private static final long serialVersionUID = 1L;
    private final WebMarkupContainer encapsulatingContainer;

    public EditableTableSubmitLink(String id, WebMarkupContainer encapsulatingComponent) {
        super(id);
        this.encapsulatingContainer = encapsulatingComponent;
    }

    protected void onSubmit(AjaxRequestTarget target) {
        if (this.areAllFormComponentsValid()) {
            try {
                this.updateFormComponentModels();
                this.onSuccess(target);
            }
            catch (RuntimeException e) {
                this.error((Serializable)((Object)this.getString("editableTableSubmitLink.updateModelsError")));
                this.onError(target);
            }
        } else {
            this.onError(target);
        }
    }

    protected boolean areAllFormComponentsValid() {
        boolean[] error = new boolean[]{false};
        this.encapsulatingContainer.visitChildren(FormComponent.class, (formComponent, visit) -> {
            if (!error[0] && this.isFormComponentActive((FormComponent<?>)formComponent)) {
                formComponent.validate();
                if (formComponent.isValid()) {
                    if (!formComponent.processChildren()) {
                        visit.dontGoDeeper();
                    }
                } else {
                    error[0] = true;
                    visit.dontGoDeeper();
                }
            }
            visit.dontGoDeeper();
        });
        return !error[0];
    }

    protected void updateFormComponentModels() {
        this.encapsulatingContainer.visitChildren(FormComponent.class, (formComponent, visit) -> {
            if (this.isFormComponentActive((FormComponent<?>)formComponent)) {
                formComponent.updateModel();
                if (!formComponent.processChildren()) {
                    visit.dontGoDeeper();
                }
            }
            visit.dontGoDeeper();
        });
    }

    protected boolean isFormComponentActive(FormComponent<?> formComponent) {
        return formComponent.isVisibleInHierarchy() && formComponent.isEnabledInHierarchy();
    }

    protected abstract void onSuccess(AjaxRequestTarget var1);

    protected abstract void onError(AjaxRequestTarget var1);

    protected WebMarkupContainer getEncapsulatingContainer() {
        return this.encapsulatingContainer;
    }
}

