/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.util.CommandContextUtil;

public class DispatchEventCommand
implements Command<Void> {
    protected FlowableEvent event;

    public DispatchEventCommand(FlowableEvent event) {
        this.event = event;
    }

    public Void execute(CommandContext commandContext) {
        if (this.event == null) {
            throw new FlowableIllegalArgumentException("event is null");
        }
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        FlowableEventDispatcher eventDispatcher = processEngineConfiguration.getEventDispatcher();
        if (eventDispatcher == null || !eventDispatcher.isEnabled()) {
            throw new FlowableException("Message dispatcher is disabled, cannot dispatch " + String.valueOf(this.event));
        }
        eventDispatcher.dispatchEvent(this.event, processEngineConfiguration.getEngineCfgKey());
        return null;
    }
}

