/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.store;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.pac4j.core.store.AbstractStore;
import org.pac4j.core.util.CommonHelper;

public class GuavaStore<K, O>
extends AbstractStore<K, O> {
    private Cache<K, O> cache;
    private int size = 0;
    private int timeout = -1;
    private TimeUnit timeUnit;

    public GuavaStore() {
    }

    public GuavaStore(int size, int timeout, TimeUnit timeUnit) {
        this.size = size;
        this.timeout = timeout;
        this.timeUnit = timeUnit;
    }

    @Override
    protected void internalInit(boolean forceReinit) {
        CommonHelper.assertTrue(this.size > 0, "size mut be greater than zero");
        CommonHelper.assertTrue(this.timeout >= 0, "timeout must be greater than zero");
        CommonHelper.assertNotNull("timeUnit", (Object)this.timeUnit);
        this.cache = CacheBuilder.newBuilder().maximumSize((long)this.size).expireAfterWrite((long)this.timeout, this.timeUnit).build();
    }

    @Override
    protected Optional<O> internalGet(K key) {
        return Optional.ofNullable(this.cache.getIfPresent(key));
    }

    @Override
    protected void internalSet(K key, O value) {
        this.cache.put(key, value);
    }

    @Override
    protected void internalRemove(K key) {
        this.cache.invalidate(key);
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "GuavaStore(cache=" + this.cache + ", size=" + this.size + ", timeout=" + this.timeout + ", timeUnit=" + this.timeUnit + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Cache<K, O> getCache() {
        return this.cache;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getSize() {
        return this.size;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setSize(int size) {
        this.size = size;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getTimeout() {
        return this.timeout;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }
}

