/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.entity.policy;

import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import jakarta.validation.constraints.NotNull;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.policy.AccountPolicy;
import org.apache.syncope.core.persistence.jpa.entity.JPAImplementation;
import org.apache.syncope.core.persistence.jpa.entity.policy.AbstractPolicy;

@Entity
@Table(name="AccountPolicy")
public class JPAAccountPolicy
extends AbstractPolicy
implements AccountPolicy,
PersistenceCapable {
    private static final long serialVersionUID = -2767606675667839060L;
    public static final String TABLE = "AccountPolicy";
    @NotNull
    private Boolean propagateSuspension = false;
    private int maxAuthenticationAttempts;
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="AccountPolicyRule", joinColumns={@JoinColumn(name="policy_id")}, inverseJoinColumns={@JoinColumn(name="implementation_id")}, uniqueConstraints={@UniqueConstraint(columnNames={"policy_id", "implementation_id"})})
    private List<JPAImplementation> rules = new ArrayList<JPAImplementation>();
    private static int pcInheritedFieldCount = AbstractPolicy.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;

    public boolean isPropagateSuspension() {
        return JPAAccountPolicy.pcGetpropagateSuspension(this);
    }

    public void setPropagateSuspension(boolean propagateSuspension) {
        JPAAccountPolicy.pcSetpropagateSuspension(this, propagateSuspension);
    }

    public int getMaxAuthenticationAttempts() {
        return JPAAccountPolicy.pcGetmaxAuthenticationAttempts(this);
    }

    public void setMaxAuthenticationAttempts(int maxAuthenticationAttempts) {
        JPAAccountPolicy.pcSetmaxAuthenticationAttempts(this, maxAuthenticationAttempts);
    }

    public boolean add(Implementation rule) {
        this.checkType(rule, JPAImplementation.class);
        this.checkImplementationType(rule, "ACCOUNT_RULE");
        return JPAAccountPolicy.pcGetrules(this).contains((JPAImplementation)rule) || JPAAccountPolicy.pcGetrules(this).add((JPAImplementation)rule);
    }

    public List<? extends Implementation> getRules() {
        return JPAAccountPolicy.pcGetrules(this);
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 255933283;
    }

    static {
        pcPCSuperclass = AbstractPolicy.class;
        pcFieldNames = new String[]{"maxAuthenticationAttempts", "propagateSuspension", "rules"};
        pcFieldTypes = new Class[]{Integer.TYPE, Boolean.class, List.class};
        pcFieldFlags = new byte[]{26, 26, 10};
        PCRegistry.register(JPAAccountPolicy.class, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"JPAAccountPolicy", (PersistenceCapable)new JPAAccountPolicy());
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.maxAuthenticationAttempts = 0;
        this.propagateSuspension = null;
        this.rules = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        JPAAccountPolicy jPAAccountPolicy = new JPAAccountPolicy();
        if (bl) {
            jPAAccountPolicy.pcClearFields();
        }
        jPAAccountPolicy.pcStateManager = stateManager;
        jPAAccountPolicy.pcCopyKeyFieldsFromObjectId(object);
        return jPAAccountPolicy;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        JPAAccountPolicy jPAAccountPolicy = new JPAAccountPolicy();
        if (bl) {
            jPAAccountPolicy.pcClearFields();
        }
        jPAAccountPolicy.pcStateManager = stateManager;
        return jPAAccountPolicy;
    }

    protected static int pcGetManagedFieldCount() {
        return 3 + AbstractPolicy.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.maxAuthenticationAttempts = this.pcStateManager.replaceIntField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.propagateSuspension = (Boolean)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.rules = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcReplaceField(nArray[i]);
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedIntField((PersistenceCapable)this, n, this.maxAuthenticationAttempts);
                return;
            }
            case 1: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.propagateSuspension);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.rules);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcProvideField(nArray[i]);
        }
    }

    protected void pcCopyField(JPAAccountPolicy jPAAccountPolicy, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(jPAAccountPolicy, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.maxAuthenticationAttempts = jPAAccountPolicy.maxAuthenticationAttempts;
                return;
            }
            case 1: {
                this.propagateSuspension = jPAAccountPolicy.propagateSuspension;
                return;
            }
            case 2: {
                this.rules = jPAAccountPolicy.rules;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        JPAAccountPolicy jPAAccountPolicy = (JPAAccountPolicy)object;
        if (jPAAccountPolicy.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < nArray.length; ++i) {
            this.pcCopyField(jPAAccountPolicy, nArray[i]);
        }
    }

    @Override
    public Class pcGetIDOwningClass() {
        return JPAAccountPolicy.class;
    }

    private static final int pcGetmaxAuthenticationAttempts(JPAAccountPolicy jPAAccountPolicy) {
        if (jPAAccountPolicy.pcStateManager == null) {
            return jPAAccountPolicy.maxAuthenticationAttempts;
        }
        int n = pcInheritedFieldCount + 0;
        jPAAccountPolicy.pcStateManager.accessingField(n);
        return jPAAccountPolicy.maxAuthenticationAttempts;
    }

    private static final void pcSetmaxAuthenticationAttempts(JPAAccountPolicy jPAAccountPolicy, int n) {
        if (jPAAccountPolicy.pcStateManager == null) {
            jPAAccountPolicy.maxAuthenticationAttempts = n;
            return;
        }
        jPAAccountPolicy.pcStateManager.settingIntField((PersistenceCapable)jPAAccountPolicy, pcInheritedFieldCount + 0, jPAAccountPolicy.maxAuthenticationAttempts, n, 0);
    }

    private static final Boolean pcGetpropagateSuspension(JPAAccountPolicy jPAAccountPolicy) {
        if (jPAAccountPolicy.pcStateManager == null) {
            return jPAAccountPolicy.propagateSuspension;
        }
        int n = pcInheritedFieldCount + 1;
        jPAAccountPolicy.pcStateManager.accessingField(n);
        return jPAAccountPolicy.propagateSuspension;
    }

    private static final void pcSetpropagateSuspension(JPAAccountPolicy jPAAccountPolicy, Boolean bl) {
        if (jPAAccountPolicy.pcStateManager == null) {
            jPAAccountPolicy.propagateSuspension = bl;
            return;
        }
        jPAAccountPolicy.pcStateManager.settingObjectField((PersistenceCapable)jPAAccountPolicy, pcInheritedFieldCount + 1, (Object)jPAAccountPolicy.propagateSuspension, (Object)bl, 0);
    }

    private static final List pcGetrules(JPAAccountPolicy jPAAccountPolicy) {
        if (jPAAccountPolicy.pcStateManager == null) {
            return jPAAccountPolicy.rules;
        }
        int n = pcInheritedFieldCount + 2;
        jPAAccountPolicy.pcStateManager.accessingField(n);
        return jPAAccountPolicy.rules;
    }

    private static final void pcSetrules(JPAAccountPolicy jPAAccountPolicy, List list) {
        if (jPAAccountPolicy.pcStateManager == null) {
            jPAAccountPolicy.rules = list;
            return;
        }
        jPAAccountPolicy.pcStateManager.settingObjectField((PersistenceCapable)jPAAccountPolicy, pcInheritedFieldCount + 2, jPAAccountPolicy.rules, (Object)list, 0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }
}

