/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.entity.am;

import com.fasterxml.jackson.core.type.TypeReference;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Lob;
import jakarta.persistence.PostLoad;
import jakarta.persistence.PostPersist;
import jakarta.persistence.PostUpdate;
import jakarta.persistence.PrePersist;
import jakarta.persistence.PreUpdate;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import jakarta.validation.constraints.NotNull;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.syncope.common.lib.auth.AuthModuleConf;
import org.apache.syncope.common.lib.to.Item;
import org.apache.syncope.common.lib.types.AuthModuleState;
import org.apache.syncope.core.persistence.api.entity.am.AuthModule;
import org.apache.syncope.core.persistence.jpa.entity.AbstractProvidedKeyEntity;
import org.apache.syncope.core.provisioning.api.serialization.POJOHelper;

@Entity
@Table(name="AuthModule")
public class JPAAuthModule
extends AbstractProvidedKeyEntity
implements AuthModule,
PersistenceCapable {
    private static final long serialVersionUID = 5681033638234853077L;
    public static final String TABLE = "AuthModule";
    protected static final TypeReference<List<Item>> TYPEREF = new TypeReference<List<Item>>(){};
    private String description;
    @Enumerated(value=EnumType.STRING)
    @NotNull
    private AuthModuleState authModuleState;
    @NotNull
    private Integer authModuleOrder = 0;
    @Lob
    private String items;
    @Transient
    private final List<Item> itemList = new ArrayList<Item>();
    @Lob
    private String jsonConf;
    private static int pcInheritedFieldCount = AbstractProvidedKeyEntity.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;

    public String getDescription() {
        return JPAAuthModule.pcGetdescription(this);
    }

    public void setDescription(String description) {
        JPAAuthModule.pcSetdescription(this, description);
    }

    public AuthModuleState getState() {
        return JPAAuthModule.pcGetauthModuleState(this);
    }

    public void setState(AuthModuleState state) {
        JPAAuthModule.pcSetauthModuleState(this, state);
    }

    public int getOrder() {
        return Optional.ofNullable(JPAAuthModule.pcGetauthModuleOrder(this)).orElse(0);
    }

    public void setOrder(int order) {
        JPAAuthModule.pcSetauthModuleOrder(this, order);
    }

    public List<Item> getItems() {
        return this.itemList;
    }

    public AuthModuleConf getConf() {
        AuthModuleConf conf = null;
        if (!StringUtils.isBlank((CharSequence)JPAAuthModule.pcGetjsonConf(this))) {
            conf = (AuthModuleConf)POJOHelper.deserialize((String)JPAAuthModule.pcGetjsonConf(this), AuthModuleConf.class);
        }
        return conf;
    }

    public void setConf(AuthModuleConf conf) {
        JPAAuthModule.pcSetjsonConf(this, POJOHelper.serialize((Object)conf));
    }

    protected void json2list(boolean clearFirst) {
        if (clearFirst) {
            this.getItems().clear();
        }
        if (JPAAuthModule.pcGetitems(this) != null) {
            this.getItems().addAll((Collection)POJOHelper.deserialize((String)JPAAuthModule.pcGetitems(this), TYPEREF));
        }
    }

    @PostLoad
    public void postLoad() {
        this.json2list(false);
    }

    @PostPersist
    @PostUpdate
    public void postSave() {
        this.json2list(true);
    }

    @PrePersist
    @PreUpdate
    public void list2json() {
        JPAAuthModule.pcSetitems(this, POJOHelper.serialize(this.getItems()));
    }

    static {
        pcPCSuperclass = AbstractProvidedKeyEntity.class;
        pcFieldNames = new String[]{"authModuleOrder", "authModuleState", "description", "items", "jsonConf"};
        pcFieldTypes = new Class[]{Integer.class, AuthModuleState.class, String.class, String.class, String.class};
        pcFieldFlags = new byte[]{26, 26, 26, 26, 26};
        PCRegistry.register(JPAAuthModule.class, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"JPAAuthModule", (PersistenceCapable)new JPAAuthModule());
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 255933283;
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.authModuleOrder = null;
        this.authModuleState = null;
        this.description = null;
        this.items = null;
        this.jsonConf = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        JPAAuthModule jPAAuthModule = new JPAAuthModule();
        if (bl) {
            jPAAuthModule.pcClearFields();
        }
        jPAAuthModule.pcStateManager = stateManager;
        jPAAuthModule.pcCopyKeyFieldsFromObjectId(object);
        return jPAAuthModule;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        JPAAuthModule jPAAuthModule = new JPAAuthModule();
        if (bl) {
            jPAAuthModule.pcClearFields();
        }
        jPAAuthModule.pcStateManager = stateManager;
        return jPAAuthModule;
    }

    protected static int pcGetManagedFieldCount() {
        return 5 + AbstractProvidedKeyEntity.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.authModuleOrder = (Integer)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.authModuleState = (AuthModuleState)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.description = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.items = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.jsonConf = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcReplaceField(nArray[i]);
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.authModuleOrder);
                return;
            }
            case 1: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.authModuleState);
                return;
            }
            case 2: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.description);
                return;
            }
            case 3: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.items);
                return;
            }
            case 4: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.jsonConf);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcProvideField(nArray[i]);
        }
    }

    protected void pcCopyField(JPAAuthModule jPAAuthModule, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(jPAAuthModule, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.authModuleOrder = jPAAuthModule.authModuleOrder;
                return;
            }
            case 1: {
                this.authModuleState = jPAAuthModule.authModuleState;
                return;
            }
            case 2: {
                this.description = jPAAuthModule.description;
                return;
            }
            case 3: {
                this.items = jPAAuthModule.items;
                return;
            }
            case 4: {
                this.jsonConf = jPAAuthModule.jsonConf;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        JPAAuthModule jPAAuthModule = (JPAAuthModule)object;
        if (jPAAuthModule.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < nArray.length; ++i) {
            this.pcCopyField(jPAAuthModule, nArray[i]);
        }
    }

    @Override
    public Class pcGetIDOwningClass() {
        return JPAAuthModule.class;
    }

    private static final Integer pcGetauthModuleOrder(JPAAuthModule jPAAuthModule) {
        if (jPAAuthModule.pcStateManager == null) {
            return jPAAuthModule.authModuleOrder;
        }
        int n = pcInheritedFieldCount + 0;
        jPAAuthModule.pcStateManager.accessingField(n);
        return jPAAuthModule.authModuleOrder;
    }

    private static final void pcSetauthModuleOrder(JPAAuthModule jPAAuthModule, Integer n) {
        if (jPAAuthModule.pcStateManager == null) {
            jPAAuthModule.authModuleOrder = n;
            return;
        }
        jPAAuthModule.pcStateManager.settingObjectField((PersistenceCapable)jPAAuthModule, pcInheritedFieldCount + 0, (Object)jPAAuthModule.authModuleOrder, (Object)n, 0);
    }

    private static final AuthModuleState pcGetauthModuleState(JPAAuthModule jPAAuthModule) {
        if (jPAAuthModule.pcStateManager == null) {
            return jPAAuthModule.authModuleState;
        }
        int n = pcInheritedFieldCount + 1;
        jPAAuthModule.pcStateManager.accessingField(n);
        return jPAAuthModule.authModuleState;
    }

    private static final void pcSetauthModuleState(JPAAuthModule jPAAuthModule, AuthModuleState authModuleState) {
        if (jPAAuthModule.pcStateManager == null) {
            jPAAuthModule.authModuleState = authModuleState;
            return;
        }
        jPAAuthModule.pcStateManager.settingObjectField((PersistenceCapable)jPAAuthModule, pcInheritedFieldCount + 1, (Object)jPAAuthModule.authModuleState, (Object)authModuleState, 0);
    }

    private static final String pcGetdescription(JPAAuthModule jPAAuthModule) {
        if (jPAAuthModule.pcStateManager == null) {
            return jPAAuthModule.description;
        }
        int n = pcInheritedFieldCount + 2;
        jPAAuthModule.pcStateManager.accessingField(n);
        return jPAAuthModule.description;
    }

    private static final void pcSetdescription(JPAAuthModule jPAAuthModule, String string) {
        if (jPAAuthModule.pcStateManager == null) {
            jPAAuthModule.description = string;
            return;
        }
        jPAAuthModule.pcStateManager.settingStringField((PersistenceCapable)jPAAuthModule, pcInheritedFieldCount + 2, jPAAuthModule.description, string, 0);
    }

    private static final String pcGetitems(JPAAuthModule jPAAuthModule) {
        if (jPAAuthModule.pcStateManager == null) {
            return jPAAuthModule.items;
        }
        int n = pcInheritedFieldCount + 3;
        jPAAuthModule.pcStateManager.accessingField(n);
        return jPAAuthModule.items;
    }

    private static final void pcSetitems(JPAAuthModule jPAAuthModule, String string) {
        if (jPAAuthModule.pcStateManager == null) {
            jPAAuthModule.items = string;
            return;
        }
        jPAAuthModule.pcStateManager.settingStringField((PersistenceCapable)jPAAuthModule, pcInheritedFieldCount + 3, jPAAuthModule.items, string, 0);
    }

    private static final String pcGetjsonConf(JPAAuthModule jPAAuthModule) {
        if (jPAAuthModule.pcStateManager == null) {
            return jPAAuthModule.jsonConf;
        }
        int n = pcInheritedFieldCount + 4;
        jPAAuthModule.pcStateManager.accessingField(n);
        return jPAAuthModule.jsonConf;
    }

    private static final void pcSetjsonConf(JPAAuthModule jPAAuthModule, String string) {
        if (jPAAuthModule.pcStateManager == null) {
            jPAAuthModule.jsonConf = string;
            return;
        }
        jPAAuthModule.pcStateManager.settingStringField((PersistenceCapable)jPAAuthModule, pcInheritedFieldCount + 4, jPAAuthModule.jsonConf, string, 0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }
}

