/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.messaging.handler;

import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.Prototype;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.PredicateSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.MessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.slf4j.Logger;

@Prototype
public abstract class AbstractMessageHandler
extends AbstractInitializableComponent
implements MessageHandler {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(AbstractMessageHandler.class);
    @Nonnull
    private Predicate<MessageContext> activationCondition = PredicateSupport.alwaysTrue();
    private boolean preInvokeCalled;

    @Nonnull
    public Predicate<MessageContext> getActivationCondition() {
        return this.activationCondition;
    }

    public void setActivationCondition(@Nonnull Predicate<MessageContext> condition) {
        this.checkSetterPreconditions();
        this.activationCondition = (Predicate)Constraint.isNotNull(condition, (String)"Predicate cannot be null");
    }

    @Override
    public void invoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        this.checkComponentActive();
        Constraint.isNotNull((Object)messageContext, (String)"Message context cannot be null");
        if (this.doPreInvoke(messageContext)) {
            this.preInvokeCalled = true;
            try {
                this.doInvoke(messageContext);
            }
            catch (MessageHandlerException e) {
                try {
                    this.doPostInvoke(messageContext, e);
                }
                catch (Throwable t) {
                    this.log.warn("{} Unchecked exception/error thrown by doPostInvoke, superseding a MessageHandlerException ", (Object)this.getLogPrefix(), (Object)e);
                    t.addSuppressed(e);
                    throw t;
                }
                throw e;
            }
            catch (Throwable t) {
                try {
                    this.doPostInvoke(messageContext);
                }
                catch (Throwable t2) {
                    this.log.warn("{} Unchecked exception/error thrown by doPostInvoke, superseding an unchecked exception/error ", (Object)this.getLogPrefix(), (Object)t);
                    t2.addSuppressed(t);
                    throw t2;
                }
                throw t;
            }
            this.doPostInvoke(messageContext);
        }
    }

    protected boolean doPreInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        if (this.activationCondition.test(messageContext)) {
            this.log.debug("{} Activation condition for handler returned true", (Object)this.getLogPrefix());
            return true;
        }
        this.log.debug("{} Activation condition for handler returned false", (Object)this.getLogPrefix());
        return false;
    }

    protected abstract void doInvoke(@Nonnull MessageContext var1) throws MessageHandlerException;

    protected void doPostInvoke(@Nonnull MessageContext messageContext) {
    }

    protected void doPostInvoke(@Nonnull MessageContext messageContext, @Nonnull Exception e) {
        this.doPostInvoke(messageContext);
    }

    protected boolean isPreInvokeCalled() {
        return this.preInvokeCalled;
    }

    @Nonnull
    @NotEmpty
    protected String getLogPrefix() {
        return "Message Handler: ";
    }
}

