/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.proxy.optimization;

import io.github.bucket4j.BucketExceptions;
import io.github.bucket4j.distributed.proxy.optimization.DelayParameters;
import java.time.Duration;

public class PredictionParameters {
    public static final int DEFAULT_MIN_SAMPLES = 2;
    public static final int DEFAULT_MAX_SAMPLES = 10;
    public final int minSamples;
    public final int maxSamples;
    public final long sampleMaxAgeNanos;

    public PredictionParameters(int minSamples, int maxSamples, Duration sampleMaxAge) {
        this(minSamples, maxSamples, sampleMaxAge.toNanos());
    }

    public PredictionParameters(int minSamples, int maxSamples, long maxUnsynchronizedTimeoutNanos) {
        if (minSamples < 2) {
            throw BucketExceptions.wrongValueOfMinSamplesForPredictionParameters(minSamples);
        }
        this.minSamples = minSamples;
        if (maxSamples < minSamples) {
            throw BucketExceptions.maxSamplesForPredictionParametersCanNotBeLessThanMinSamples(minSamples, maxSamples);
        }
        this.maxSamples = maxSamples;
        if (maxUnsynchronizedTimeoutNanos <= 0L) {
            throw BucketExceptions.nonPositiveSampleMaxAgeForPredictionParameters(maxUnsynchronizedTimeoutNanos);
        }
        this.sampleMaxAgeNanos = maxUnsynchronizedTimeoutNanos;
    }

    public static PredictionParameters createDefault(DelayParameters delayParameters) {
        long sampleMaxAge = delayParameters.maxUnsynchronizedTimeoutNanos * 2L;
        return new PredictionParameters(2, 10, sampleMaxAge);
    }

    public int getMinSamples() {
        return this.minSamples;
    }

    public int getMaxSamples() {
        return this.maxSamples;
    }

    public long getSampleMaxAgeNanos() {
        return this.sampleMaxAgeNanos;
    }
}

