/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.common.objects;

import java.util.HashMap;
import java.util.Map;
import org.identityconnectors.framework.common.objects.ScriptContext;

public final class ScriptContextBuilder {
    private String scriptLanguage;
    private String scriptText;
    private final Map<String, Object> scriptArguments = new HashMap<String, Object>();

    public ScriptContextBuilder() {
    }

    public ScriptContextBuilder(String scriptLanguage, String scriptText) {
        this.scriptLanguage = scriptLanguage;
        this.scriptText = scriptText;
    }

    public String getScriptLanguage() {
        return this.scriptLanguage;
    }

    public ScriptContextBuilder setScriptLanguage(String scriptLanguage) {
        this.scriptLanguage = scriptLanguage;
        return this;
    }

    public String getScriptText() {
        return this.scriptText;
    }

    public ScriptContextBuilder setScriptText(String scriptText) {
        this.scriptText = scriptText;
        return this;
    }

    public ScriptContextBuilder addScriptArgument(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 'name' cannot be null.");
        }
        this.scriptArguments.put(name, value);
        return this;
    }

    public void removeScriptArgument(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 'name' cannot be null.");
        }
        this.scriptArguments.remove(name);
    }

    public Map<String, Object> getScriptArguments() {
        return this.scriptArguments;
    }

    public ScriptContext build() {
        return new ScriptContext(this.scriptLanguage, this.scriptText, this.scriptArguments);
    }
}

