/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.common.objects;

import java.util.HashMap;
import java.util.Objects;
import org.identityconnectors.common.Assertions;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.Uid;

public class LiveSyncDelta {
    private final ObjectClass objectClass;
    private final Uid uid;
    private final ConnectorObject object;

    LiveSyncDelta(ObjectClass objectClass, Uid uid, ConnectorObject object) {
        Assertions.nullCheck(uid, "uid");
        if (object != null && !uid.attributeEquals(object.getUid())) {
            throw new IllegalArgumentException("Uid does not match that of the object.");
        }
        if (object != null && !objectClass.equals(object.getObjectClass())) {
            throw new IllegalArgumentException("ObjectClass does not match that of the object.");
        }
        this.objectClass = objectClass;
        this.uid = uid;
        this.object = object;
    }

    public ObjectClass getObjectClass() {
        return this.objectClass;
    }

    public Uid getUid() {
        return this.uid;
    }

    public ConnectorObject getObject() {
        return this.object;
    }

    public String toString() {
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("ObjectClass", this.objectClass);
        values.put("Uid", this.uid);
        values.put("Object", this.object);
        return ((Object)values).toString();
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + Objects.hashCode(this.objectClass);
        hash = 67 * hash + Objects.hashCode(this.uid);
        hash = 67 * hash + Objects.hashCode(this.object);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LiveSyncDelta other = (LiveSyncDelta)obj;
        if (!Objects.equals(this.objectClass, other.objectClass)) {
            return false;
        }
        if (!Objects.equals(this.uid, other.uid)) {
            return false;
        }
        return Objects.equals(this.object, other.object);
    }
}

