/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.export.ExporterFilter;
import net.sf.jasperreports.engine.export.JRExporterContext;
import net.sf.jasperreports.engine.export.MatcherExportFilterMapping;
import net.sf.jasperreports.export.Exporter;

public class MatcherExporterFilter
implements ExporterFilter {
    public static final String PROPERTY_MATCHER_EXPORT_FILTER_KEY = "net.sf.jasperreports.export.matcher.filter.key";
    private Set<String> includes;
    private Set<String> excludes;

    @Override
    public boolean isToExport(JRPrintElement element) {
        String matcherKey;
        if (element.hasProperties() && element.getPropertiesMap().containsProperty(PROPERTY_MATCHER_EXPORT_FILTER_KEY) && (matcherKey = element.getPropertiesMap().getProperty(PROPERTY_MATCHER_EXPORT_FILTER_KEY)) != null) {
            if (this.includes == null || this.includes.size() == 0) {
                if (this.excludes == null || this.excludes.size() == 0) {
                    return true;
                }
                return !this.excludes.contains(matcherKey);
            }
            if (this.excludes == null || this.excludes.size() == 0) {
                return this.includes.contains(matcherKey);
            }
            return this.includes.contains(matcherKey) && !this.excludes.contains(matcherKey);
        }
        return true;
    }

    public MatcherExporterFilter(Set<String> includes, Set<String> excludes) {
        this.includes = includes;
        this.excludes = excludes;
    }

    public static MatcherExporterFilter getInstance(JRExporterContext exporterContext) {
        String exporterKey;
        JRAbstractExporter typedExporter;
        MatcherExporterFilter filter = null;
        Exporter exporter = exporterContext.getExporterRef();
        JRAbstractExporter jRAbstractExporter = typedExporter = exporter instanceof JRAbstractExporter ? (JRAbstractExporter)exporter : null;
        if (typedExporter != null && (exporterKey = typedExporter.getExporterKey()) != null) {
            HashSet<String> includes = new HashSet<String>();
            HashSet<String> excludes = new HashSet<String>();
            List<MatcherExportFilterMapping> mappings = exporterContext.getJasperReportsContext().getExtensions(MatcherExportFilterMapping.class);
            for (MatcherExportFilterMapping mapping : mappings) {
                if (!exporterKey.equals(mapping.getExporterKey())) continue;
                if (mapping.isIncludes()) {
                    includes.add(mapping.getValue());
                    continue;
                }
                excludes.add(mapping.getValue());
            }
            filter = new MatcherExporterFilter(includes, excludes);
        }
        return filter;
    }
}

