/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.internal.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ReflectPermission;
import java.security.AccessController;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.oval.Validator;
import net.sf.oval.exception.AccessingFieldValueFailedException;
import net.sf.oval.exception.ConstraintsViolatedException;
import net.sf.oval.exception.InvokingMethodFailedException;
import net.sf.oval.exception.ReflectionException;
import net.sf.oval.internal.ContextCache;
import net.sf.oval.internal.Log;
import net.sf.oval.internal.util.ArrayUtils;
import net.sf.oval.internal.util.SetAccessibleAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReflectionUtils {
    private static final Log LOG = Log.getLog(ReflectionUtils.class);
    private static final ReflectPermission SUPPRESS_ACCESS_CHECKS_PERMISSION = new ReflectPermission("suppressAccessChecks");

    public static void assertPrivateAccessAllowed() {
        SecurityManager manager = System.getSecurityManager();
        if (manager != null) {
            try {
                manager.checkPermission(SUPPRESS_ACCESS_CHECKS_PERMISSION);
            }
            catch (SecurityException ex) {
                throw new ReflectionException("Current security manager configuration does not allow access to private fields and methods.", ex);
            }
        }
    }

    public static Annotation[] getAnnotations(Class<?> clazz, boolean inspectInterfaces) {
        if (!inspectInterfaces) {
            return clazz.getAnnotations();
        }
        List<Annotation> annotations = ArrayUtils.asList(clazz.getAnnotations());
        for (Class<?> next : ReflectionUtils.getInterfacesRecursive(clazz)) {
            Annotation[] declaredAnnotations = next.getDeclaredAnnotations();
            annotations.addAll(ArrayUtils.asList(declaredAnnotations));
        }
        return annotations.toArray(new Annotation[annotations.size()]);
    }

    public static Annotation[] getAnnotations(Method method, boolean inspectInterfaces) {
        if (!inspectInterfaces || !ReflectionUtils.isPublic(method)) {
            return method.getAnnotations();
        }
        String methodName = method.getName();
        Class<?>[] methodParameterTypes = method.getParameterTypes();
        List<Annotation> annotations = ArrayUtils.asList(method.getAnnotations());
        for (Class<?> nextClass : ReflectionUtils.getInterfacesRecursive(method.getDeclaringClass())) {
            try {
                ArrayUtils.addAll(annotations, nextClass.getDeclaredMethod(methodName, methodParameterTypes).getDeclaredAnnotations());
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        return annotations.toArray(new Annotation[annotations.size()]);
    }

    public static Field getField(Class<?> clazz, String fieldName) {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
    }

    public static Field getFieldForSetter(Method setter) {
        if (!ReflectionUtils.isSetter(setter)) {
            return null;
        }
        Class<?>[] methodParameterTypes = setter.getParameterTypes();
        String methodName = setter.getName();
        Class<?> clazz = setter.getDeclaringClass();
        String fieldName = methodName.substring(3, 4).toLowerCase(Validator.getLocaleProvider().getLocale());
        if (methodName.length() > 4) {
            fieldName = String.valueOf(fieldName) + methodName.substring(4);
        }
        Field field = null;
        try {
            field = clazz.getDeclaredField(fieldName);
            if (!field.getType().equals(methodParameterTypes[0])) {
                LOG.warn("Found field <{1}> in class <{2}>that matches setter <{3}> name, but mismatches parameter type.", (Object)fieldName, (Object)clazz.getName(), methodName);
                field = null;
            }
        }
        catch (NoSuchFieldException e) {
            LOG.debug("Field not found", e);
        }
        if (field == null && (Boolean.TYPE.equals(methodParameterTypes[0]) || Boolean.class.equals(methodParameterTypes[0]))) {
            fieldName = "is" + methodName.substring(3);
            try {
                field = clazz.getDeclaredField(fieldName);
                if (!Boolean.TYPE.equals(field.getType()) && Boolean.class.equals(field.getType())) {
                    LOG.warn("Found field <{1}> in class <{2}>that matches setter <{3}> name, but mismatches parameter type.", (Object)fieldName, (Object)clazz.getName(), methodName);
                    field = null;
                }
            }
            catch (NoSuchFieldException ex) {
                LOG.debug("Field not found", ex);
            }
        }
        return field;
    }

    public static Field getFieldRecursive(Class<?> clazz, String fieldName) {
        Field f = ReflectionUtils.getField(clazz, fieldName);
        if (f != null) {
            return f;
        }
        Class<?> superclazz = clazz.getSuperclass();
        if (superclazz == null) {
            return null;
        }
        return ReflectionUtils.getFieldRecursive(superclazz, fieldName);
    }

    public static Object getFieldValue(Field field, Object target) throws AccessingFieldValueFailedException {
        try {
            if (!field.isAccessible()) {
                AccessController.doPrivileged(new SetAccessibleAction(field));
            }
            return field.get(target);
        }
        catch (Exception ex) {
            throw new AccessingFieldValueFailedException(field.getName(), target, ContextCache.getFieldContext(field), ex);
        }
    }

    public static Method getGetter(Class<?> clazz, String propertyName) {
        String appendix = String.valueOf(propertyName.substring(0, 1).toUpperCase(Validator.getLocaleProvider().getLocale())) + propertyName.substring(1);
        try {
            return clazz.getDeclaredMethod("get" + appendix, new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            LOG.trace("getXXX method not found.", ex);
            try {
                return clazz.getDeclaredMethod("is" + appendix, new Class[0]);
            }
            catch (NoSuchMethodException ex2) {
                LOG.trace("isXXX method not found.", ex2);
                return null;
            }
        }
    }

    public static Method getGetterRecursive(Class<?> clazz, String propertyName) {
        Method m = ReflectionUtils.getGetter(clazz, propertyName);
        if (m != null) {
            return m;
        }
        Class<?> superclazz = clazz.getSuperclass();
        if (superclazz == null) {
            return null;
        }
        return ReflectionUtils.getGetterRecursive(superclazz, propertyName);
    }

    public static List<Method> getInterfaceMethods(Method method) {
        if (ReflectionUtils.isStatic(method)) {
            return null;
        }
        Class<?>[] interfaces = method.getDeclaringClass().getInterfaces();
        if (interfaces.length == 0) {
            return null;
        }
        String methodName = method.getName();
        Class<?>[] parameterTypes = method.getParameterTypes();
        List<Method> methods = Validator.getCollectionFactory().createList(interfaces.length);
        Class<?>[] classArray = interfaces;
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> iface = classArray[n2];
            Method m = ReflectionUtils.getMethod(iface, methodName, parameterTypes);
            if (m != null) {
                methods.add(m);
            }
            ++n2;
        }
        return methods;
    }

    public static Set<Class<?>> getInterfacesRecursive(Class<?> clazz) {
        Set<Class<?>> interfaces = Validator.getCollectionFactory().createSet(2);
        return ReflectionUtils.getInterfacesRecursive(clazz, interfaces);
    }

    private static Set<Class<?>> getInterfacesRecursive(Class<?> clazz, Set<Class<?>> interfaces) {
        while (clazz != null) {
            Class<?>[] classArray = clazz.getInterfaces();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> next = classArray[n2];
                interfaces.add(next);
                ReflectionUtils.getInterfacesRecursive(next, interfaces);
                ++n2;
            }
            clazz = clazz.getSuperclass();
        }
        return interfaces;
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        try {
            return clazz.getDeclaredMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static Method getMethodRecursive(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        Method m = ReflectionUtils.getMethod(clazz, methodName, parameterTypes);
        if (m != null) {
            return m;
        }
        Class<?> superclazz = clazz.getSuperclass();
        if (superclazz == null) {
            return null;
        }
        return ReflectionUtils.getMethodRecursive(superclazz, methodName, parameterTypes);
    }

    public static Annotation[][] getParameterAnnotations(Method method, boolean inspectInterfaces) {
        if (!inspectInterfaces || !ReflectionUtils.isPublic(method)) {
            return method.getParameterAnnotations();
        }
        String methodName = method.getName();
        Class<?>[] methodParameterTypes = method.getParameterTypes();
        int methodParameterTypesCount = methodParameterTypes.length;
        HashSet[] methodParameterAnnotations = new HashSet[methodParameterTypesCount];
        Class<?> clazz = method.getDeclaringClass();
        Set<Class<?>> classes = ReflectionUtils.getInterfacesRecursive(clazz);
        classes.add(clazz);
        for (Class<?> nextClass : classes) {
            try {
                Method nextMethod = nextClass.getDeclaredMethod(methodName, methodParameterTypes);
                int i = 0;
                while (i < methodParameterTypesCount) {
                    Annotation[] paramAnnos = nextMethod.getParameterAnnotations()[i];
                    if (paramAnnos.length > 0) {
                        HashSet<Annotation> cummulatedParamAnnos = methodParameterAnnotations[i];
                        if (cummulatedParamAnnos == null) {
                            methodParameterAnnotations[i] = cummulatedParamAnnos = new HashSet<Annotation>();
                        }
                        Annotation[] annotationArray = paramAnnos;
                        int n = paramAnnos.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Annotation anno = annotationArray[n2];
                            cummulatedParamAnnos.add(anno);
                            ++n2;
                        }
                    }
                    ++i;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        Annotation[][] result = new Annotation[methodParameterTypesCount][];
        int i = 0;
        while (i < methodParameterTypesCount) {
            HashSet paramAnnos = methodParameterAnnotations[i];
            result[i] = paramAnnos == null ? new Annotation[]{} : methodParameterAnnotations[i].toArray(new Annotation[methodParameterAnnotations[i].size()]);
            ++i;
        }
        return result;
    }

    public static Method getSetter(Class<?> clazz, String propertyName) {
        Method[] declaredMethods;
        String methodName = "set" + propertyName.substring(0, 1).toUpperCase(Validator.getLocaleProvider().getLocale()) + propertyName.substring(1);
        Method[] methodArray = declaredMethods = clazz.getDeclaredMethods();
        int n = declaredMethods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (methodName.equals(method.getName()) && method.getParameterTypes().length == 1) {
                return method;
            }
            ++n2;
        }
        LOG.trace("No setter for {} not found on class {}.", (Object)propertyName, clazz);
        return null;
    }

    public static Method getSetterRecursive(Class<?> clazz, String propertyName) {
        Method m = ReflectionUtils.getSetter(clazz, propertyName);
        if (m != null) {
            return m;
        }
        Class<?> superclazz = clazz.getSuperclass();
        if (superclazz == null) {
            return null;
        }
        return ReflectionUtils.getSetterRecursive(superclazz, propertyName);
    }

    public static Method getSuperMethod(Method method) {
        if (ReflectionUtils.isStatic(method)) {
            return null;
        }
        String methodName = method.getName();
        Class<?>[] parameterTypes = method.getParameterTypes();
        Class<?> currentClass = method.getDeclaringClass();
        while (currentClass != null && currentClass != Object.class) {
            Method m = ReflectionUtils.getMethod(currentClass = currentClass.getSuperclass(), methodName, parameterTypes);
            if (m == null || ReflectionUtils.isPrivate(m)) continue;
            return m;
        }
        return null;
    }

    public static String guessFieldName(Method getter) {
        String fieldName = getter.getName();
        if (fieldName.startsWith("get") && fieldName.length() > 3) {
            fieldName = (fieldName = fieldName.substring(3)).length() == 1 ? fieldName.toLowerCase(Validator.getLocaleProvider().getLocale()) : String.valueOf(Character.toLowerCase(fieldName.charAt(0))) + fieldName.substring(1);
        } else if (fieldName.startsWith("is") && fieldName.length() > 2) {
            fieldName = (fieldName = fieldName.substring(2)).length() == 1 ? fieldName.toLowerCase(Validator.getLocaleProvider().getLocale()) : String.valueOf(Character.toLowerCase(fieldName.charAt(0))) + fieldName.substring(1);
        }
        return fieldName;
    }

    public static boolean hasField(Class<?> clazz, String fieldName) {
        return ReflectionUtils.getField(clazz, fieldName) != null;
    }

    public static boolean hasMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        return ReflectionUtils.getMethod(clazz, methodName, parameterTypes) != null;
    }

    public static <T> T invokeMethod(Method method, Object obj, Object ... args) throws InvokingMethodFailedException, ConstraintsViolatedException {
        try {
            if (!method.isAccessible()) {
                AccessController.doPrivileged(new SetAccessibleAction(method));
            }
            return (T)method.invoke(obj, args);
        }
        catch (Exception ex) {
            if (ex.getCause() instanceof ConstraintsViolatedException) {
                throw (ConstraintsViolatedException)ex.getCause();
            }
            throw new InvokingMethodFailedException("Executing method " + method.getName() + " failed.", obj, ContextCache.getMethodReturnValueContext(method), ex);
        }
    }

    public static boolean isAnnotationPresent(Method method, Class<? extends Annotation> annotationClass, boolean inspectInterfaces) {
        if (method.isAnnotationPresent(annotationClass)) {
            return true;
        }
        if (!inspectInterfaces || !ReflectionUtils.isPublic(method)) {
            return false;
        }
        String methodName = method.getName();
        Class<?>[] methodParameterTypes = method.getParameterTypes();
        for (Class<?> next : ReflectionUtils.getInterfacesRecursive(method.getDeclaringClass())) {
            try {
                if (!next.getDeclaredMethod(methodName, methodParameterTypes).isAnnotationPresent(annotationClass)) continue;
                return true;
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        return false;
    }

    public static boolean isClassPresent(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static boolean isFinal(Member member) {
        return (member.getModifiers() & 0x10) != 0;
    }

    public static boolean isGetter(Method method) {
        return method.getParameterTypes().length == 0 && (method.getName().startsWith("is") || method.getName().startsWith("get"));
    }

    public static boolean isNonStaticInnerClass(Class<?> clazz) {
        return clazz.getName().indexOf(36) > -1 && (clazz.getModifiers() & 8) == 0;
    }

    public static boolean isPackage(Member member) {
        return (member.getModifiers() & 7) == 0;
    }

    public static boolean isPrivate(Member member) {
        return (member.getModifiers() & 2) != 0;
    }

    public static boolean isPrivateAccessAllowed() {
        SecurityManager manager = System.getSecurityManager();
        if (manager != null) {
            try {
                manager.checkPermission(SUPPRESS_ACCESS_CHECKS_PERMISSION);
            }
            catch (SecurityException securityException) {
                return false;
            }
        }
        return true;
    }

    public static boolean isProtected(Member member) {
        return (member.getModifiers() & 4) != 0;
    }

    public static boolean isPublic(Member member) {
        return (member.getModifiers() & 1) != 0;
    }

    public static boolean isSetter(Method method) {
        Class<?>[] methodParameterTypes = method.getParameterTypes();
        if (methodParameterTypes.length != 1) {
            return false;
        }
        String methodName = method.getName();
        int methodNameLen = methodName.length();
        return methodNameLen >= 4 && methodName.startsWith("set");
    }

    public static boolean isStatic(Member member) {
        return (member.getModifiers() & 8) != 0;
    }

    public static boolean isTransient(Member member) {
        return (member.getModifiers() & 0x80) != 0;
    }

    public static boolean isVoidMethod(Method method) {
        return method.getReturnType() == Void.TYPE;
    }

    public static boolean setViaSetter(Object target, String propertyName, Object propertyValue) {
        assert (target != null);
        assert (propertyName != null);
        Method setter = ReflectionUtils.getSetterRecursive(target.getClass(), propertyName);
        if (setter != null) {
            try {
                setter.invoke(target, propertyValue);
            }
            catch (IllegalArgumentException ex) {
                LOG.debug("Setting {1} failed on {2} failed.", (Object)propertyName, target, ex);
                return false;
            }
            catch (IllegalAccessException ex) {
                LOG.debug("Setting {1} failed on {2} failed.", (Object)propertyName, target, ex);
                return false;
            }
            catch (InvocationTargetException ex) {
                LOG.debug("Setting {1} failed on {2} failed.", (Object)propertyName, target, ex);
                return false;
            }
        }
        return false;
    }

    private ReflectionUtils() {
    }
}

