/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.sort;

import java.util.Iterator;
import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypePairComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.memory.MemoryAllocationException;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.operators.sort.AbstractMergeIterator;
import org.apache.flink.util.Collector;
import org.apache.flink.util.MutableObjectIterator;

public abstract class AbstractMergeInnerJoinIterator<T1, T2, O>
extends AbstractMergeIterator<T1, T2, O> {
    public AbstractMergeInnerJoinIterator(MutableObjectIterator<T1> input1, MutableObjectIterator<T2> input2, TypeSerializer<T1> serializer1, TypeComparator<T1> comparator1, TypeSerializer<T2> serializer2, TypeComparator<T2> comparator2, TypePairComparator<T1, T2> pairComparator, MemoryManager memoryManager, IOManager ioManager, int numMemoryPages, AbstractInvokable parentTask) throws MemoryAllocationException {
        super(input1, input2, serializer1, comparator1, serializer2, comparator2, pairComparator, memoryManager, ioManager, numMemoryPages, parentTask);
    }

    @Override
    public boolean callWithNextKey(FlatJoinFunction<T1, T2, O> joinFunction, Collector<O> collector) throws Exception {
        int comp;
        if (!this.iterator1.nextKey() || !this.iterator2.nextKey()) {
            while (this.iterator1.nextKey()) {
            }
            while (this.iterator2.nextKey()) {
            }
            return false;
        }
        TypePairComparator comparator = this.pairComparator;
        comparator.setReference(this.iterator1.getCurrent());
        Object current2 = this.iterator2.getCurrent();
        while ((comp = comparator.compareToReference(current2)) != 0) {
            if (comp < 0) {
                if (!this.iterator2.nextKey()) {
                    return false;
                }
                current2 = this.iterator2.getCurrent();
                continue;
            }
            if (!this.iterator1.nextKey()) {
                return false;
            }
            comparator.setReference(this.iterator1.getCurrent());
        }
        Iterator values1 = this.iterator1.getValues();
        Iterator values2 = this.iterator2.getValues();
        this.crossMatchingGroup(values1, values2, joinFunction, collector);
        return true;
    }
}

