/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceIDRetrievable;
import org.apache.flink.runtime.resourcemanager.exceptions.ResourceManagerException;
import org.apache.flink.util.Preconditions;

public class KubernetesWorkerNode
implements ResourceIDRetrievable {
    private final ResourceID resourceID;
    private static final Pattern TASK_MANAGER_POD_PATTERN = Pattern.compile("\\S+-taskmanager-([\\d]+)-([\\d]+)");

    KubernetesWorkerNode(ResourceID resourceID) {
        this.resourceID = (ResourceID)Preconditions.checkNotNull((Object)resourceID);
    }

    public ResourceID getResourceID() {
        return this.resourceID;
    }

    public long getAttempt() throws ResourceManagerException {
        Matcher matcher = TASK_MANAGER_POD_PATTERN.matcher(this.resourceID.toString());
        if (matcher.find()) {
            return Long.parseLong(matcher.group(1));
        }
        throw new ResourceManagerException("Error to parse KubernetesWorkerNode from " + this.resourceID + ".");
    }
}

