/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.uk.org.lidalia.sysoutslf4j.context.exceptionhandlers;

import java.io.PrintStream;
import org.apache.storm.shade.uk.org.lidalia.sysoutslf4j.context.LogLevel;
import org.apache.storm.shade.uk.org.lidalia.sysoutslf4j.context.exceptionhandlers.ExceptionHandlingStrategy;
import org.apache.storm.shade.uk.org.lidalia.sysoutslf4j.context.exceptionhandlers.ExceptionHandlingStrategyFactory;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public final class LogPerLineExceptionHandlingStrategyFactory
implements ExceptionHandlingStrategyFactory {
    private static final ExceptionHandlingStrategyFactory INSTANCE = new LogPerLineExceptionHandlingStrategyFactory();

    public static ExceptionHandlingStrategyFactory getInstance() {
        return INSTANCE;
    }

    private LogPerLineExceptionHandlingStrategyFactory() {
    }

    @Override
    public ExceptionHandlingStrategy makeExceptionHandlingStrategy(LogLevel logLevel, PrintStream originalPrintStream) {
        return new LogPerLineExceptionHandlingStrategy(logLevel);
    }

    private static final class LogPerLineExceptionHandlingStrategy
    implements ExceptionHandlingStrategy {
        private static final Marker MARKER = MarkerFactory.getMarker((String)"stacktrace");
        private final LogLevel logLevel;

        LogPerLineExceptionHandlingStrategy(LogLevel logLevel) {
            this.logLevel = logLevel;
        }

        @Override
        public void notifyNotStackTrace() {
        }

        @Override
        public void handleExceptionLine(String line, Logger log) {
            this.logLevel.log(log, MARKER, line);
        }
    }
}

