/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.security.auth.authorizer;

import java.lang.reflect.Field;
import java.security.Principal;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.storm.security.auth.ClientAuthUtils;
import org.apache.storm.security.auth.IPrincipalToLocal;
import org.apache.storm.security.auth.ReqContext;
import org.apache.storm.security.auth.authorizer.DRPCAuthorizerBase;
import org.apache.storm.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DRPCSimpleACLAuthorizer
extends DRPCAuthorizerBase {
    public static final Logger LOG = LoggerFactory.getLogger(DRPCSimpleACLAuthorizer.class);
    public static final String CLIENT_USERS_KEY = "client.users";
    public static final String INVOCATION_USER_KEY = "invocation.user";
    public static final String FUNCTION_KEY = "function.name";
    protected String aclFileName = "";
    protected IPrincipalToLocal ptol;
    protected boolean permitWhenMissingFunctionEntry = false;
    private volatile Map<String, AclFunctionEntry> acl = null;
    private volatile long lastUpdate = 0L;

    protected Map<String, AclFunctionEntry> readAclFromConfig() {
        long now = System.currentTimeMillis();
        if (now - 5000L > this.lastUpdate || this.acl == null) {
            Map confAcl;
            HashMap<String, AclFunctionEntry> acl = new HashMap<String, AclFunctionEntry>();
            Map<String, Object> conf = Utils.findAndReadConfigFile(this.aclFileName);
            if (conf.containsKey("drpc.authorizer.acl") && (confAcl = (Map)conf.get("drpc.authorizer.acl")) != null) {
                for (Map.Entry entry : confAcl.entrySet()) {
                    Map val = (Map)entry.getValue();
                    Collection clientUsers = val.containsKey(CLIENT_USERS_KEY) ? (Collection)val.get(CLIENT_USERS_KEY) : null;
                    String invocationUser = val.containsKey(INVOCATION_USER_KEY) ? (String)val.get(INVOCATION_USER_KEY) : null;
                    acl.put((String)entry.getKey(), new AclFunctionEntry(clientUsers, invocationUser));
                }
            }
            this.acl = acl;
            if (this.acl.isEmpty() && !this.permitWhenMissingFunctionEntry) {
                LOG.warn("Requiring explicit ACL entries, but none given. Therefore, all operations will be denied.");
            }
            this.lastUpdate = System.currentTimeMillis();
        }
        return this.acl;
    }

    @Override
    public void prepare(Map<String, Object> conf) {
        Boolean isStrict = (Boolean)conf.get("drpc.authorizer.acl.strict");
        this.permitWhenMissingFunctionEntry = isStrict != null && isStrict == false;
        this.aclFileName = (String)conf.get("drpc.authorizer.acl.filename");
        this.ptol = ClientAuthUtils.getPrincipalToLocalPlugin(conf);
    }

    private String getUserFromContext(ReqContext context) {
        Principal princ;
        if (context != null && (princ = context.principal()) != null) {
            return princ.getName();
        }
        return null;
    }

    private String getLocalUserFromContext(ReqContext context) {
        if (context != null) {
            return this.ptol.toLocal(context.principal());
        }
        return null;
    }

    protected boolean permitClientOrInvocationRequest(ReqContext context, Map<String, Object> params, String fieldName) {
        Map<String, AclFunctionEntry> acl = this.readAclFromConfig();
        String function = (String)params.get(FUNCTION_KEY);
        if (function != null && !function.isEmpty()) {
            AclFunctionEntry entry = acl.get(function);
            if (entry == null && this.permitWhenMissingFunctionEntry) {
                return true;
            }
            if (entry != null) {
                Object value;
                try {
                    Field field = AclFunctionEntry.class.getDeclaredField(fieldName);
                    value = field.get(entry);
                }
                catch (Exception ex) {
                    LOG.warn("Caught Exception while accessing ACL", (Throwable)ex);
                    return false;
                }
                String principal = this.getUserFromContext(context);
                String user = this.getLocalUserFromContext(context);
                if (value == null) {
                    LOG.warn("Configuration for function '" + function + "' is invalid: it should have both an invocation user and a list of client users defined.");
                } else {
                    if (value instanceof Set && (((Set)value).contains(principal) || ((Set)value).contains(user))) {
                        return true;
                    }
                    if (value instanceof String && (value.equals(principal) || value.equals(user))) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @Override
    protected boolean permitClientRequest(ReqContext context, String operation, Map<String, Object> params) {
        return this.permitClientOrInvocationRequest(context, params, "clientUsers");
    }

    @Override
    protected boolean permitInvocationRequest(ReqContext context, String operation, Map<String, Object> params) {
        return this.permitClientOrInvocationRequest(context, params, "invocationUser");
    }

    @VisibleForTesting
    public static class AclFunctionEntry {
        public final Set<String> clientUsers;
        public final String invocationUser;

        public AclFunctionEntry(Collection<String> clientUsers, String invocationUser) {
            this.clientUsers = clientUsers != null ? new HashSet<String>(clientUsers) : new HashSet();
            this.invocationUser = invocationUser;
        }
    }
}

