/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.apache.zookeeper.server;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.zip.CheckedInputStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.storm.shade.org.apache.jute.BinaryInputArchive;
import org.apache.storm.shade.org.apache.zookeeper.server.DataNode;
import org.apache.storm.shade.org.apache.zookeeper.server.DataTree;
import org.apache.storm.shade.org.apache.zookeeper.server.ExitCode;
import org.apache.storm.shade.org.apache.zookeeper.server.persistence.FileSnap;
import org.apache.storm.shade.org.apache.zookeeper.server.persistence.SnapStream;
import org.apache.storm.shade.org.apache.zookeeper.util.ServiceUtils;

public class SnapshotComparer {
    private final Options options = new Options();
    private static final String leftOption = "left";
    private static final String rightOption = "right";
    private static final String byteThresholdOption = "bytes";
    private static final String nodeThresholdOption = "nodes";
    private static final String debugOption = "debug";
    private static final String interactiveOption = "interactive";

    private SnapshotComparer() {
        this.options.addOption(Option.builder((String)"l").hasArg().required(true).longOpt(leftOption).desc("(Required) The left snapshot file.").argName("LEFT").type(File.class).build());
        this.options.addOption(Option.builder((String)"r").hasArg().required(true).longOpt(rightOption).desc("(Required) The right snapshot file.").argName("RIGHT").type(File.class).build());
        this.options.addOption(Option.builder((String)"b").hasArg().required(true).longOpt(byteThresholdOption).desc("(Required) The node data delta size threshold, in bytes, for printing the node.").argName("BYTETHRESHOLD").type(String.class).build());
        this.options.addOption(Option.builder((String)"n").hasArg().required(true).longOpt(nodeThresholdOption).desc("(Required) The descendant node delta size threshold, in nodes, for printing the node.").argName("NODETHRESHOLD").type(String.class).build());
        this.options.addOption("d", debugOption, false, "Use debug output.");
        this.options.addOption("i", interactiveOption, false, "Enter interactive mode.");
    }

    private void usage() {
        HelpFormatter help = new HelpFormatter();
        help.printHelp(120, "java -cp <classPath> " + SnapshotComparer.class.getName(), "", this.options, "");
    }

    public static void main(String[] args) throws Exception {
        SnapshotComparer app = new SnapshotComparer();
        app.compareSnapshots(args);
    }

    private void compareSnapshots(String[] args) throws Exception {
        CommandLine parsedOptions;
        try {
            parsedOptions = new DefaultParser().parse(this.options, args);
        }
        catch (ParseException e) {
            System.err.println(e.getMessage());
            this.usage();
            ServiceUtils.requestSystemExit(ExitCode.INVALID_INVOCATION.getValue());
            return;
        }
        File left = (File)parsedOptions.getParsedOptionValue(leftOption);
        File right = (File)parsedOptions.getParsedOptionValue(rightOption);
        int byteThreshold = Integer.parseInt((String)parsedOptions.getParsedOptionValue(byteThresholdOption));
        int nodeThreshold = Integer.parseInt((String)parsedOptions.getParsedOptionValue(nodeThresholdOption));
        boolean debug = parsedOptions.hasOption(debugOption);
        boolean interactive = parsedOptions.hasOption(interactiveOption);
        System.out.println("Successfully parsed options!");
        TreeInfo leftTree = new TreeInfo(left);
        TreeInfo rightTree = new TreeInfo(right);
        System.out.println(leftTree.toString());
        System.out.println(rightTree.toString());
        SnapshotComparer.compareTrees(leftTree, rightTree, byteThreshold, nodeThreshold, debug, interactive);
    }

    private static DataTree getSnapshot(File file) throws Exception {
        DataTree dataTree = new DataTree();
        HashMap<Long, Integer> sessions = new HashMap<Long, Integer>();
        CheckedInputStream snapIS = SnapStream.getInputStream(file);
        long beginning = System.nanoTime();
        BinaryInputArchive ia = BinaryInputArchive.getArchive(snapIS);
        FileSnap.deserialize(dataTree, sessions, ia);
        long end = System.nanoTime();
        System.out.println(String.format("Deserialized snapshot in %s in %f seconds", file.getName(), (double)(end - beginning) / 1000000.0 / 1000.0));
        return dataTree;
    }

    private static void printThresholdInfo(int byteThreshold, int nodeThreshold) {
        System.out.println(String.format("Printing analysis for nodes difference larger than %d bytes or node count difference larger than %d.", byteThreshold, nodeThreshold));
    }

    private static void compareTrees(TreeInfo left, TreeInfo right, int byteThreshold, int nodeThreshold, boolean debug, boolean interactive) {
        int maxDepth = Math.max(left.nodesAtDepths.size(), right.nodesAtDepths.size());
        if (!interactive) {
            SnapshotComparer.printThresholdInfo(byteThreshold, nodeThreshold);
            for (int i = 0; i < maxDepth; ++i) {
                System.out.println(String.format("Analysis for depth %d", i));
                SnapshotComparer.compareLine(left, right, i, byteThreshold, nodeThreshold, debug, interactive);
            }
        } else {
            Scanner scanner = new Scanner(System.in);
            int currentDepth = 0;
            while (currentDepth < maxDepth) {
                System.out.println(String.format("Current depth is %d", currentDepth));
                System.out.println("- Press enter to move to print current depth layer;\n- Type a number to jump to and print all nodes at a given depth;\n- Enter an ABSOLUTE path to print the immediate subtree of a node. Path must start with '/'.");
                String input = scanner.nextLine();
                SnapshotComparer.printThresholdInfo(byteThreshold, nodeThreshold);
                if (input.isEmpty()) {
                    System.out.println(String.format("Analysis for depth %d", currentDepth));
                    SnapshotComparer.compareLine(left, right, currentDepth, byteThreshold, nodeThreshold, debug, interactive);
                    ++currentDepth;
                } else if (input.startsWith("/")) {
                    System.out.println(String.format("Analysis for node %s", input));
                    SnapshotComparer.compareSubtree(left, right, input, byteThreshold, nodeThreshold, debug, interactive);
                } else {
                    try {
                        int depth = Integer.parseInt(input);
                        if (depth < 0 || depth >= maxDepth) {
                            System.out.println(String.format("Depth must be in range [%d, %d]", 0, maxDepth - 1));
                            continue;
                        }
                        currentDepth = depth;
                        System.out.println(String.format("Analysis for depth %d", currentDepth));
                        SnapshotComparer.compareLine(left, right, currentDepth, byteThreshold, nodeThreshold, debug, interactive);
                    }
                    catch (NumberFormatException ex) {
                        System.out.println(String.format("Input %s is not valid. Depth must be in range [%d, %d]. Path must be an absolute path which starts with '/'.", input, 0, maxDepth - 1));
                    }
                }
                System.out.println("");
            }
        }
        System.out.println("All layers compared.");
    }

    private static void compareSubtree(TreeInfo left, TreeInfo right, String path, int byteThreshold, int nodeThreshold, boolean debug, boolean interactive) {
        ArrayList<TreeInfo.TreeNode> rightList;
        TreeInfo.TreeNode leftRoot = left.nodesByName.get(path);
        TreeInfo.TreeNode rightRoot = right.nodesByName.get(path);
        ArrayList<TreeInfo.TreeNode> leftList = leftRoot == null ? new ArrayList() : leftRoot.children;
        List<Object> list = rightList = rightRoot == null ? new ArrayList() : rightRoot.children;
        if (leftRoot == null && rightRoot == null) {
            System.out.println(String.format("Path %s is neither found in left tree nor right tree.", path));
        } else {
            SnapshotComparer.compareNodes(leftList, rightList, byteThreshold, nodeThreshold, debug, interactive);
        }
    }

    private static void compareLine(TreeInfo left, TreeInfo right, int depth, int byteThreshold, int nodeThreshold, boolean debug, boolean interactive) {
        ArrayList<TreeInfo.TreeNode> leftList = depth >= left.nodesAtDepths.size() ? new ArrayList<TreeInfo.TreeNode>() : (List)left.nodesAtDepths.get(depth);
        ArrayList<TreeInfo.TreeNode> rightList = depth >= right.nodesAtDepths.size() ? new ArrayList<TreeInfo.TreeNode>() : (List)right.nodesAtDepths.get(depth);
        SnapshotComparer.compareNodes(leftList, rightList, byteThreshold, nodeThreshold, debug, interactive);
    }

    private static void compareNodes(List<TreeInfo.TreeNode> leftList, List<TreeInfo.TreeNode> rightList, int byteThreshold, int nodeThreshold, boolean debug, boolean interactive) {
        boolean rightRemaining;
        Comparator<TreeInfo.TreeNode> alphabeticComparator = TreeInfo.MakeAlphabeticComparator();
        Collections.sort(leftList, alphabeticComparator);
        Collections.sort(rightList, alphabeticComparator);
        int leftIndex = 0;
        int rightIndex = 0;
        boolean leftRemaining = leftList.size() > leftIndex;
        boolean bl = rightRemaining = rightList.size() > rightIndex;
        while (leftRemaining || rightRemaining) {
            TreeInfo.TreeNode leftNode = null;
            if (leftRemaining) {
                leftNode = leftList.get(leftIndex);
            }
            TreeInfo.TreeNode rightNode = null;
            if (rightRemaining) {
                rightNode = rightList.get(rightIndex);
            }
            if (leftNode != null && rightNode != null) {
                int result;
                if (debug) {
                    System.out.println(String.format("Comparing %s to %s", leftNode.label, rightNode.label));
                }
                if ((result = leftNode.label.compareTo(rightNode.label)) < 0) {
                    if (debug) {
                        System.out.println("left is less");
                    }
                    SnapshotComparer.printLeftOnly(leftNode, byteThreshold, nodeThreshold, debug, interactive);
                    ++leftIndex;
                } else if (result > 0) {
                    if (debug) {
                        System.out.println("right is less");
                    }
                    SnapshotComparer.printRightOnly(rightNode, byteThreshold, nodeThreshold, debug, interactive);
                    ++rightIndex;
                } else {
                    if (debug) {
                        System.out.println("same");
                    }
                    SnapshotComparer.printBoth(leftNode, rightNode, byteThreshold, nodeThreshold, debug, interactive);
                    ++leftIndex;
                    ++rightIndex;
                }
            } else if (leftNode != null) {
                SnapshotComparer.printLeftOnly(leftNode, byteThreshold, nodeThreshold, debug, interactive);
                ++leftIndex;
            } else {
                SnapshotComparer.printRightOnly(rightNode, byteThreshold, nodeThreshold, debug, interactive);
                ++rightIndex;
            }
            leftRemaining = leftList.size() > leftIndex;
            rightRemaining = rightList.size() > rightIndex;
        }
    }

    static void printLeftOnly(TreeInfo.TreeNode node, int byteThreshold, int nodeThreshold, boolean debug, boolean interactive) {
        if (node.descendantSize > (long)byteThreshold || node.descendantCount > (long)nodeThreshold) {
            StringBuilder builder = new StringBuilder();
            builder.append(String.format("Node %s found only in left tree. ", node.label));
            SnapshotComparer.printNode(node, builder);
            System.out.println(builder.toString());
        } else if (debug || interactive) {
            System.out.println(String.format("Filtered left node %s of size %d", node.label, node.descendantSize));
        }
    }

    static void printRightOnly(TreeInfo.TreeNode node, int byteThreshold, int nodeThreshold, boolean debug, boolean interactive) {
        if (node.descendantSize > (long)byteThreshold || node.descendantCount > (long)nodeThreshold) {
            StringBuilder builder = new StringBuilder();
            builder.append(String.format("Node %s found only in right tree. ", node.label));
            SnapshotComparer.printNode(node, builder);
            System.out.println(builder.toString());
        } else if (debug || interactive) {
            System.out.println(String.format("Filtered right node %s of size %d", node.label, node.descendantSize));
        }
    }

    static void printBoth(TreeInfo.TreeNode leftNode, TreeInfo.TreeNode rightNode, int byteThreshold, int nodeThreshold, boolean debug, boolean interactive) {
        if (Math.abs(rightNode.descendantSize - leftNode.descendantSize) > (long)byteThreshold || Math.abs(rightNode.descendantCount - leftNode.descendantCount) > (long)nodeThreshold) {
            System.out.println(String.format("Node %s found in both trees. Delta: %d bytes, %d descendants", leftNode.label, rightNode.descendantSize - leftNode.descendantSize, rightNode.descendantCount - leftNode.descendantCount));
        } else if (debug || interactive) {
            System.out.println(String.format("Filtered node %s of left size %d, right size %d", leftNode.label, leftNode.descendantSize, rightNode.descendantSize));
        }
    }

    static void printNode(TreeInfo.TreeNode node, StringBuilder builder) {
        builder.append(String.format("Descendant size: %d. Descendant count: %d", node.descendantSize, node.descendantCount));
    }

    private static class TreeInfo {
        final TreeNode root;
        long count;
        List<ArrayList<TreeNode>> nodesAtDepths = new ArrayList<ArrayList<TreeNode>>();
        Map<String, TreeNode> nodesByName = new HashMap<String, TreeNode>();

        TreeInfo(File snapshot) throws Exception {
            DataTree dataTree = SnapshotComparer.getSnapshot(snapshot);
            this.count = 0L;
            long beginning = System.nanoTime();
            DataNode root = dataTree.getNode("");
            long size = root.data == null ? 0L : (long)root.data.length;
            this.root = new TreeNode("", size);
            this.root.populateChildren("", dataTree, this);
            long end = System.nanoTime();
            System.out.println(String.format("Processed data tree in %f seconds", ((double)end - (double)beginning) / 1000000.0 / 1000.0));
        }

        void registerNode(TreeNode node, int depth) {
            while (depth > this.nodesAtDepths.size()) {
                this.nodesAtDepths.add(new ArrayList());
            }
            this.nodesAtDepths.get(depth - 1).add(node);
            this.nodesByName.put(node.label, node);
            ++this.count;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(String.format("Node count: %d%n", this.count));
            builder.append(String.format("Total size: %d%n", this.root.descendantSize));
            builder.append(String.format("Max depth: %d%n", this.nodesAtDepths.size()));
            for (int i = 0; i < this.nodesAtDepths.size(); ++i) {
                builder.append(String.format("Count of nodes at depth %d: %d%n", i, this.nodesAtDepths.get(i).size()));
            }
            return builder.toString();
        }

        public static Comparator<TreeNode> MakeAlphabeticComparator() {
            return new TreeNode.AlphabeticComparator();
        }

        public static class TreeNode {
            final String label;
            final long size;
            final List<TreeNode> children;
            long descendantSize;
            long descendantCount;

            public TreeNode(String label, long size) {
                this.label = label;
                this.size = size;
                this.children = new ArrayList<TreeNode>();
            }

            void populateChildren(String path, DataTree dataTree, TreeInfo treeInfo) throws Exception {
                this.populateChildren(path, dataTree, treeInfo, 1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void populateChildren(String path, DataTree dataTree, TreeInfo treeInfo, int currentDepth) throws Exception {
                List<String> childLabels = null;
                childLabels = dataTree.getChildren(path, null, null);
                if (childLabels != null && !childLabels.isEmpty()) {
                    for (String childName : childLabels) {
                        long size;
                        DataNode childNode;
                        String childPath = path + "/" + childName;
                        DataNode dataNode = childNode = dataTree.getNode(childPath);
                        synchronized (dataNode) {
                            size = childNode.data == null ? 0L : (long)childNode.data.length;
                        }
                        TreeNode childTreeNode = new TreeNode(childPath, size);
                        childTreeNode.populateChildren(childPath, dataTree, treeInfo, currentDepth + 1);
                        this.children.add(childTreeNode);
                    }
                }
                this.descendantSize = 0L;
                this.descendantCount = 0L;
                for (TreeNode child : this.children) {
                    this.descendantSize += child.descendantSize;
                    this.descendantCount += child.descendantCount;
                }
                this.descendantSize += this.size;
                this.descendantCount += (long)this.children.size();
                treeInfo.registerNode(this, currentDepth);
            }

            public static class AlphabeticComparator
            implements Comparator<TreeNode>,
            Serializable {
                private static final long serialVersionUID = 2601197766392565593L;

                @Override
                public int compare(TreeNode left, TreeNode right) {
                    if (left == right) {
                        return 0;
                    }
                    if (left == null) {
                        return -1;
                    }
                    if (right == null) {
                        return 1;
                    }
                    return left.label.compareTo(right.label);
                }
            }
        }
    }
}

