/*
 * Decompiled with CFR 0.152.
 */
package spire.math;

import java.io.Serializable;
import java.math.BigInteger;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.runtime.ModuleSerializationProxy;
import spire.math.NumberTag;
import spire.math.SafeLong;
import spire.math.SafeLongBigInteger;
import spire.math.SafeLongInstances;
import spire.math.SafeLongInstances$SafeLongAlgebra$;
import spire.math.SafeLongInstances$SafeLongIsReal$;
import spire.math.SafeLongLong;
import spire.math.package$;

public final class SafeLong$
implements SafeLongInstances,
Serializable {
    public static final SafeLong$ MODULE$ = new SafeLong$();
    private static final SafeLong minusOne;
    private static final SafeLong zero;
    private static final SafeLong one;
    private static final SafeLong two;
    private static final SafeLong three;
    private static final SafeLong ten;
    private static final BigInteger big64;
    private static final SafeLong safe64;
    private static volatile SafeLongInstances$SafeLongAlgebra$ SafeLongAlgebra$module;
    private static volatile SafeLongInstances$SafeLongIsReal$ SafeLongIsReal$module;
    private static NumberTag<SafeLong> SafeLongTag;

    static {
        SafeLongInstances.$init$(MODULE$);
        minusOne = new SafeLongLong(-1L);
        zero = new SafeLongLong(0L);
        one = new SafeLongLong(1L);
        two = new SafeLongLong(2L);
        three = new SafeLongLong(3L);
        ten = new SafeLongLong(10L);
        big64 = BigInteger.ONE.shiftLeft(63);
        safe64 = MODULE$.apply(BigInt$.MODULE$.javaBigInteger2bigInt(MODULE$.big64()));
    }

    @Override
    public SafeLongInstances$SafeLongAlgebra$ SafeLongAlgebra() {
        if (SafeLongAlgebra$module == null) {
            this.SafeLongAlgebra$lzycompute$1();
        }
        return SafeLongAlgebra$module;
    }

    @Override
    public SafeLongInstances$SafeLongIsReal$ SafeLongIsReal() {
        if (SafeLongIsReal$module == null) {
            this.SafeLongIsReal$lzycompute$1();
        }
        return SafeLongIsReal$module;
    }

    @Override
    public final NumberTag<SafeLong> SafeLongTag() {
        return SafeLongTag;
    }

    @Override
    public final void spire$math$SafeLongInstances$_setter_$SafeLongTag_$eq(NumberTag<SafeLong> x$1) {
        SafeLongTag = x$1;
    }

    public final SafeLong minusOne() {
        return minusOne;
    }

    public final SafeLong zero() {
        return zero;
    }

    public final SafeLong one() {
        return one;
    }

    public final SafeLong two() {
        return two;
    }

    public final SafeLong three() {
        return three;
    }

    public final SafeLong ten() {
        return ten;
    }

    public final BigInteger big64() {
        return big64;
    }

    public final SafeLong safe64() {
        return safe64;
    }

    public SafeLong apply(int x) {
        return new SafeLongLong(x);
    }

    public SafeLong apply(long x) {
        return new SafeLongLong(x);
    }

    public SafeLong apply(BigInt x) {
        return x.isValidLong() ? new SafeLongLong(x.toLong()) : new SafeLongBigInteger(x.bigInteger());
    }

    public SafeLong apply(String s) {
        SafeLong safeLong;
        try {
            safeLong = this.apply(Long.parseLong(s));
        }
        catch (Exception exception) {
            safeLong = this.apply(BigInt$.MODULE$.javaBigInteger2bigInt(new BigInteger(s)));
        }
        return safeLong;
    }

    public SafeLong longGcd(long x, long y) {
        return x == 0L ? SafeLong$.absWrap$1(y) : (y == 0L ? SafeLong$.absWrap$1(x) : (x == Long.MIN_VALUE ? (y == Long.MIN_VALUE ? this.safe64() : this.apply(package$.MODULE$.gcd(y, x % y))) : (y == Long.MIN_VALUE ? new SafeLongLong(package$.MODULE$.gcd(x, y % x)) : new SafeLongLong(package$.MODULE$.gcd(x, y % x)))));
    }

    public SafeLong mixedGcd(long x, BigInteger y) {
        return y.signum() == 0 ? (x >= 0L ? new SafeLongLong(x) : (x == Long.MIN_VALUE ? this.safe64() : new SafeLongLong(-x))) : (x == 0L ? this.apply(BigInt$.MODULE$.javaBigInteger2bigInt(y.abs())) : (x == Long.MIN_VALUE ? this.apply(BigInt$.MODULE$.javaBigInteger2bigInt(this.big64().gcd(y))) : new SafeLongLong(package$.MODULE$.gcd(x, y.remainder(BigInteger.valueOf(x)).longValue()))));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SafeLong$.class);
    }

    private final void SafeLongAlgebra$lzycompute$1() {
        SafeLong$ safeLong$ = this;
        synchronized (safeLong$) {
            if (SafeLongAlgebra$module == null) {
                SafeLongAlgebra$module = new SafeLongInstances$SafeLongAlgebra$(this);
            }
        }
    }

    private final void SafeLongIsReal$lzycompute$1() {
        SafeLong$ safeLong$ = this;
        synchronized (safeLong$) {
            if (SafeLongIsReal$module == null) {
                SafeLongIsReal$module = new SafeLongInstances$SafeLongIsReal$(this);
            }
        }
    }

    private static final SafeLong absWrap$1(long x) {
        return x >= 0L ? MODULE$.apply(x) : (x == Long.MIN_VALUE ? MODULE$.safe64() : MODULE$.apply(-x));
    }

    private SafeLong$() {
    }
}

