/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.BoundReference;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.MutableProjection;
import org.apache.spark.sql.catalyst.expressions.MutableProjection$;
import org.apache.spark.sql.catalyst.expressions.variant.VariantCastArgs;
import org.apache.spark.sql.execution.datasources.parquet.ParquetVariantReader;
import org.apache.spark.sql.execution.datasources.parquet.ScalarCastHelper;
import org.apache.spark.sql.execution.datasources.parquet.SparkShreddingUtils$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.types.variant.VariantSchema;
import org.apache.spark.unsafe.types.UTF8String;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005e3aa\u0002\u0005!\u0002\u001b9\u0002\"\u0003\u000f\u0001\u0005\u0003\u0005\u000b\u0011B\u000f&\u0011%1\u0003A!A!\u0002\u00139C\u0006C\u0005.\u0001\t\u0005\t\u0015!\u0003/o!)\u0001\b\u0001C\u0001s!1a\b\u0001Q\u0001\n}BQa\u0011\u0001\u0005B\u0011\u0013AbU2bY\u0006\u0014(+Z1eKJT!!\u0003\u0006\u0002\u000fA\f'/];fi*\u00111\u0002D\u0001\fI\u0006$\u0018m]8ve\u000e,7O\u0003\u0002\u000e\u001d\u0005IQ\r_3dkRLwN\u001c\u0006\u0003\u001fA\t1a]9m\u0015\t\t\"#A\u0003ta\u0006\u00148N\u0003\u0002\u0014)\u00051\u0011\r]1dQ\u0016T\u0011!F\u0001\u0004_J<7\u0001A\n\u0003\u0001a\u0001\"!\u0007\u000e\u000e\u0003!I!a\u0007\u0005\u0003)A\u000b'/];fiZ\u000b'/[1oiJ+\u0017\rZ3s\u0003\u0019\u00198\r[3nCB\u0011adI\u0007\u0002?)\u0011\u0001%I\u0001\bm\u0006\u0014\u0018.\u00198u\u0015\t\u0011\u0003#A\u0003usB,7/\u0003\u0002%?\tia+\u0019:jC:$8k\u00195f[\u0006L!\u0001\b\u000e\u0002\u0015Q\f'oZ3u)f\u0004X\r\u0005\u0002)U5\t\u0011F\u0003\u0002#\u001d%\u00111&\u000b\u0002\t\t\u0006$\u0018\rV=qK&\u0011aEG\u0001\tG\u0006\u001cH/\u0011:hgB\u0011q&N\u0007\u0002a)\u0011\u0001%\r\u0006\u0003eM\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011AGD\u0001\tG\u0006$\u0018\r\\=ti&\u0011a\u0007\r\u0002\u0010-\u0006\u0014\u0018.\u00198u\u0007\u0006\u001cH/\u0011:hg&\u0011QFG\u0001\u0007y%t\u0017\u000e\u001e \u0015\tiZD(\u0010\t\u00033\u0001AQ\u0001\b\u0003A\u0002uAQA\n\u0003A\u0002\u001dBQ!\f\u0003A\u00029\n1bY1tiB\u0013xN[3diB\u0011\u0001)Q\u0007\u0002c%\u0011!)\r\u0002\u0012\u001bV$\u0018M\u00197f!J|'.Z2uS>t\u0017!\u0004:fC\u00124%o\\7UsB,G\rF\u0002F\u0017F\u0003\"AR%\u000e\u0003\u001dS\u0011\u0001S\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0015\u001e\u00131!\u00118z\u0011\u0015ae\u00011\u0001N\u0003\r\u0011xn\u001e\t\u0003\u001d>k\u0011aM\u0005\u0003!N\u00121\"\u00138uKJt\u0017\r\u001c*po\")!K\u0002a\u0001'\u0006\u0001Bo\u001c9MKZ,G.T3uC\u0012\fG/\u0019\t\u0004\rR3\u0016BA+H\u0005\u0015\t%O]1z!\t1u+\u0003\u0002Y\u000f\n!!)\u001f;f\u0001")
public final class ScalarReader
extends ParquetVariantReader {
    private final MutableProjection castProject;

    @Override
    public Object readFromTyped(InternalRow row, byte[] topLevelMetadata) {
        if (this.castProject == null) {
            if (super.targetType() instanceof StringType) {
                return UTF8String.fromString((String)this.rebuildVariant(row, topLevelMetadata).toJson(super.castArgs().zoneId()));
            }
            return this.invalidCast(row, topLevelMetadata);
        }
        InternalRow result = (InternalRow)this.castProject.apply((Object)row);
        if (result.isNullAt(0)) {
            return null;
        }
        return result.get(0, super.targetType());
    }

    public ScalarReader(VariantSchema schema, DataType targetType, VariantCastArgs castArgs) {
        super(schema, targetType, castArgs);
        MutableProjection mutableProjection;
        if (super.schema().scalarSchema != null) {
            DataType scalarType = SparkShreddingUtils$.MODULE$.scalarSchemaToSparkType(super.schema().scalarSchema);
            BoundReference input = new BoundReference(super.schema().typedIdx, scalarType, false);
            mutableProjection = MutableProjection$.MODULE$.create((Seq)new .colon.colon((Object)new ScalarCastHelper((Expression)input, super.targetType(), super.castArgs()), (List)Nil$.MODULE$));
        } else {
            mutableProjection = null;
        }
        this.castProject = mutableProjection;
    }
}

