/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.rules;

import java.io.Serializable;
import java.util.Map;
import org.apache.spark.SparkException;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.catalyst.QueryPlanningTracker;
import org.apache.spark.sql.catalyst.QueryPlanningTracker$;
import org.apache.spark.sql.catalyst.rules.PlanChangeLogger;
import org.apache.spark.sql.catalyst.rules.QueryExecutionMetering;
import org.apache.spark.sql.catalyst.rules.QueryExecutionMetrics;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.catalyst.rules.RuleExecutor$;
import org.apache.spark.sql.catalyst.rules.RuleExecutor$Batch$;
import org.apache.spark.sql.catalyst.rules.RuleExecutor$FixedPoint$;
import org.apache.spark.sql.catalyst.rules.RuleExecutor$Once$;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LazyBoolean;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\r\u0005r!\u0002.\\\u0011\u0003Ag!\u00026\\\u0011\u0003Y\u0007\"\u0002:\u0002\t\u0003\u0019\bb\u0002;\u0002\u0005\u0004%\t\"\u001e\u0005\u0007s\u0006\u0001\u000b\u0011\u0002<\t\u000bi\fA\u0011A>\t\u000f\u0005=\u0011\u0001\"\u0001\u0002\u0012!9\u0011\u0011D\u0001\u0005\u0002\u0005maA\u00026\\\u0003\u0003\t\u0019\u0003\u0003\u0004s\u0011\u0011\u0005\u00111\u0007\u0005\b\u0003GBA\u0011CA3\r\u001d\t9\u0007CA\u0001\u0003SBaA]\u0006\u0005\u0002\u0005-\u0004bBA9\u0017\u0019\u0005\u00111\u000f\u0005\b\u0003wZA\u0011AA?\u0011\u001d\t)i\u0003C\u0001\u0003K:q!a\"\t\u0011\u0003\u000bIIB\u0004\u0002\f\"A\t)!$\t\rI\fB\u0011AAT\u0011%\t\t(\u0005b\u0001\n\u0003\t\u0019\b\u0003\u0005\u0002*F\u0001\u000b\u0011BA;\u0011%\tY+EA\u0001\n\u0003\ni\u000bC\u0005\u0002>F\t\t\u0011\"\u0001\u0002t!I\u0011qX\t\u0002\u0002\u0013\u0005\u0011\u0011\u0019\u0005\n\u0003\u000f\f\u0012\u0011!C!\u0003\u0013D\u0011\"a6\u0012\u0003\u0003%\t!!7\t\u0013\u0005u\u0017#!A\u0005B\u0005}\u0007\"CAq#\u0005\u0005I\u0011IAr\r\u0019\t)\u000f\u0003!\u0002h\"Q\u0011\u0011\u000f\u000f\u0003\u0016\u0004%\t%a\u001d\t\u0015\u0005%FD!E!\u0002\u0013\t)\b\u0003\u0006\u0002|q\u0011)\u001a!C!\u0003{B!\"!;\u001d\u0005#\u0005\u000b\u0011BA@\u0011)\t)\t\bBK\u0002\u0013\u0005\u0013Q\r\u0005\n\u0003Wd\"\u0011#Q\u0001\nqDaA\u001d\u000f\u0005\u0002\u00055\b\"CA|9\u0005\u0005I\u0011AA}\u0011%\u0011\t\u0001HI\u0001\n\u0003\u0011\u0019\u0001C\u0005\u0003\u001aq\t\n\u0011\"\u0001\u0003\u001c!I!q\u0004\u000f\u0012\u0002\u0013\u0005!\u0011\u0005\u0005\n\u0003Wc\u0012\u0011!C!\u0003[C\u0011\"!0\u001d\u0003\u0003%\t!a\u001d\t\u0013\u0005}F$!A\u0005\u0002\t\u0015\u0002\"CAd9\u0005\u0005I\u0011IAe\u0011%\t9\u000eHA\u0001\n\u0003\u0011I\u0003C\u0005\u0003.q\t\t\u0011\"\u0011\u00030!I\u0011Q\u001c\u000f\u0002\u0002\u0013\u0005\u0013q\u001c\u0005\n\u0003Cd\u0012\u0011!C!\u0003GD\u0011Ba\r\u001d\u0003\u0003%\tE!\u000e\b\u0013\te\u0002\"!A\t\u0002\tmb!CAs\u0011\u0005\u0005\t\u0012\u0001B\u001f\u0011\u0019\u0011(\u0007\"\u0001\u0003V!I\u0011\u0011\u001d\u001a\u0002\u0002\u0013\u0015\u00131\u001d\u0005\n\u0005/\u0012\u0014\u0011!CA\u00053B\u0011B!\u00193#\u0003%\tAa\u0007\t\u0013\t\r$'%A\u0005\u0002\t\u0005\u0002\"\u0003B3e\u0005\u0005I\u0011\u0011B4\u0011%\u0011IHMI\u0001\n\u0003\u0011Y\u0002C\u0005\u0003|I\n\n\u0011\"\u0001\u0003\"\u00199!Q\u0010\u0005I;\n}\u0004BCA2w\tU\r\u0011\"\u0001\u0002f!I!\u0011Q\u001e\u0003\u0012\u0003\u0006I\u0001 \u0005\u000b\u0005\u0007[$Q3A\u0005\u0002\t\u0015\u0005B\u0003BDw\tE\t\u0015!\u0003\u0002n!IAl\u000fBK\u0002\u0013\u0005!\u0011\u0012\u0005\u000b\u0005/[$\u0011#Q\u0001\n\t-\u0005B\u0002:<\t\u0003\u0011I\nC\u0005\u0002,n\n\t\u0011\"\u0011\u0002.\"I\u0011QX\u001e\u0002\u0002\u0013\u0005\u00111\u000f\u0005\n\u0003\u007f[\u0014\u0011!C\u0001\u0005GC\u0011\"a2<\u0003\u0003%\t%!3\t\u0013\u0005]7(!A\u0005\u0002\t\u001d\u0006\"\u0003B\u0017w\u0005\u0005I\u0011\tBV\u0011%\tinOA\u0001\n\u0003\ny\u000eC\u0005\u0002bn\n\t\u0011\"\u0011\u0002d\"I!1G\u001e\u0002\u0002\u0013\u0005#qV\u0004\u000b\u0005gC\u0011\u0011!E\t;\nUfA\u0003B?\u0011\u0005\u0005\t\u0012C/\u00038\"1!/\u0014C\u0001\u0005wC\u0011\"!9N\u0003\u0003%)%a9\t\u0013\t]S*!A\u0005\u0002\nu\u0006\"\u0003Bc\u001b\u0006\u0005I\u0011\u0011Bd\u0011\u001d\u0011)\u000e\u0003D\t\u0005/D\u0011Ba7\t\u0005\u0004%\tB!8\t\u0011\t\u0015\b\u0002)A\u0005\u0005?DqAa:\t\t#\u0011I\u000fC\u0004\u0003v\"!\tBa>\t\u000f\tu\b\u0002\"\u0003\u0003\u0000\"91\u0011\u0002\u0005\u0005\u0002\r-\u0001bBB\u000e\u0011\u0011\u00051QD\u0001\r%VdW-\u0012=fGV$xN\u001d\u0006\u00039v\u000bQA];mKNT!AX0\u0002\u0011\r\fG/\u00197zgRT!\u0001Y1\u0002\u0007M\fHN\u0003\u0002cG\u0006)1\u000f]1sW*\u0011A-Z\u0001\u0007CB\f7\r[3\u000b\u0003\u0019\f1a\u001c:h\u0007\u0001\u0001\"![\u0001\u000e\u0003m\u0013ABU;mK\u0016CXmY;u_J\u001c\"!\u00017\u0011\u00055\u0004X\"\u00018\u000b\u0003=\fQa]2bY\u0006L!!\u001d8\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0001.A\nrk\u0016\u0014\u00180\u0012=fGV$\u0018n\u001c8NKR,'/F\u0001w!\tIw/\u0003\u0002y7\n1\u0012+^3ss\u0016CXmY;uS>tW*\u001a;fe&tw-\u0001\u000brk\u0016\u0014\u00180\u0012=fGV$\u0018n\u001c8NKR,'\u000fI\u0001\u000eIVl\u0007\u000fV5nKN\u0003XM\u001c;\u0015\u0003q\u00042!`A\u0005\u001d\rq\u0018Q\u0001\t\u0003\u007f:l!!!\u0001\u000b\u0007\u0005\rq-\u0001\u0004=e>|GOP\u0005\u0004\u0003\u000fq\u0017A\u0002)sK\u0012,g-\u0003\u0003\u0002\f\u00055!AB*ue&twMC\u0002\u0002\b9\fAB]3tKRlU\r\u001e:jGN$\"!a\u0005\u0011\u00075\f)\"C\u0002\u0002\u00189\u0014A!\u00168ji\u0006\tr-\u001a;DkJ\u0014XM\u001c;NKR\u0014\u0018nY:\u0015\u0005\u0005u\u0001cA5\u0002 %\u0019\u0011\u0011E.\u0003+E+XM]=Fq\u0016\u001cW\u000f^5p]6+GO]5dgV!\u0011QEA\u001e'\u0011AA.a\n\u0011\t\u0005%\u0012qF\u0007\u0003\u0003WQ1!!\fb\u0003!Ig\u000e^3s]\u0006d\u0017\u0002BA\u0019\u0003W\u0011q\u0001T8hO&tw\r\u0006\u0002\u00026A!\u0011\u000eCA\u001c!\u0011\tI$a\u000f\r\u0001\u00119\u0011Q\b\u0005C\u0002\u0005}\"\u0001\u0003+sK\u0016$\u0016\u0010]3\u0012\t\u0005\u0005\u0013q\t\t\u0004[\u0006\r\u0013bAA#]\n9aj\u001c;iS:<\u0007\u0007BA%\u0003/\u0002b!a\u0013\u0002R\u0005USBAA'\u0015\r\ty%X\u0001\u0006iJ,Wm]\u0005\u0005\u0003'\niE\u0001\u0005Ue\u0016,gj\u001c3f!\u0011\tI$a\u0016\u0005\u0019\u0005e\u00131HA\u0001\u0002\u0003\u0015\t!a\u0017\u0003\u0007}##'\u0005\u0003\u0002B\u0005u\u0003cA7\u0002`%\u0019\u0011\u0011\r8\u0003\u0007\u0005s\u00170\u0001\u0003oC6,W#\u0001?\u0003\u0011M#(/\u0019;fOf\u001c\"a\u00037\u0015\u0005\u00055\u0004cAA8\u00175\t\u0001\"A\u0007nCbLE/\u001a:bi&|gn]\u000b\u0003\u0003k\u00022!\\A<\u0013\r\tIH\u001c\u0002\u0004\u0013:$\u0018!D3se>\u0014xJ\\#yG\u0016,G-\u0006\u0002\u0002\u0000A\u0019Q.!!\n\u0007\u0005\reNA\u0004C_>dW-\u00198\u0002)5\f\u00070\u0013;fe\u0006$\u0018n\u001c8t'\u0016$H/\u001b8h\u0003\u0011yenY3\u0011\u0007\u0005=\u0014C\u0001\u0003P]\u000e,7cB\t\u0002n\u0005=\u0015Q\u0013\t\u0004[\u0006E\u0015bAAJ]\n9\u0001K]8ek\u000e$\b\u0003BAL\u0003CsA!!'\u0002\u001e:\u0019q0a'\n\u0003=L1!a(o\u0003\u001d\u0001\u0018mY6bO\u0016LA!a)\u0002&\na1+\u001a:jC2L'0\u00192mK*\u0019\u0011q\u00148\u0015\u0005\u0005%\u0015AD7bq&#XM]1uS>t7\u000fI\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005=\u0006\u0003BAY\u0003wk!!a-\u000b\t\u0005U\u0016qW\u0001\u0005Y\u0006twM\u0003\u0002\u0002:\u0006!!.\u0019<b\u0013\u0011\tY!a-\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011QLAb\u0011%\t)mFA\u0001\u0002\u0004\t)(A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003\u0017\u0004b!!4\u0002T\u0006uSBAAh\u0015\r\t\tN\\\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAk\u0003\u001f\u0014\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011qPAn\u0011%\t)-GA\u0001\u0002\u0004\ti&\u0001\u0005iCND7i\u001c3f)\t\t)(\u0001\u0005u_N#(/\u001b8h)\t\tyK\u0001\u0006GSb,G\rU8j]R\u001cr\u0001HA7\u0003\u001f\u000b)*\u0001\bfeJ|'o\u00148Fq\u000e,W\r\u001a\u0011\u0002+5\f\u00070\u0013;fe\u0006$\u0018n\u001c8t'\u0016$H/\u001b8hAQA\u0011q^Ay\u0003g\f)\u0010E\u0002\u0002pqAq!!\u001d$\u0001\u0004\t)\bC\u0005\u0002|\r\u0002\n\u00111\u0001\u0002\u0000!A\u0011QQ\u0012\u0011\u0002\u0003\u0007A0\u0001\u0003d_BLH\u0003CAx\u0003w\fi0a@\t\u0013\u0005ED\u0005%AA\u0002\u0005U\u0004\"CA>IA\u0005\t\u0019AA@\u0011!\t)\t\nI\u0001\u0002\u0004a\u0018AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0005\u000bQC!!\u001e\u0003\b-\u0012!\u0011\u0002\t\u0005\u0005\u0017\u0011)\"\u0004\u0002\u0003\u000e)!!q\u0002B\t\u0003%)hn\u00195fG.,GMC\u0002\u0003\u00149\f!\"\u00198o_R\fG/[8o\u0013\u0011\u00119B!\u0004\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\tu!\u0006BA@\u0005\u000f\tabY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0003$)\u001aAPa\u0002\u0015\t\u0005u#q\u0005\u0005\n\u0003\u000bT\u0013\u0011!a\u0001\u0003k\"B!a \u0003,!I\u0011Q\u0019\u0017\u0002\u0002\u0003\u0007\u0011QL\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u00020\nE\u0002\"CAc[\u0005\u0005\t\u0019AA;\u0003\u0019)\u0017/^1mgR!\u0011q\u0010B\u001c\u0011%\t)\rMA\u0001\u0002\u0004\ti&\u0001\u0006GSb,G\rU8j]R\u00042!a\u001c3'\u0015\u0011$q\bB&!-\u0011\tEa\u0012\u0002v\u0005}D0a<\u000e\u0005\t\r#b\u0001B#]\u00069!/\u001e8uS6,\u0017\u0002\u0002B%\u0005\u0007\u0012\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c84!\u0011\u0011iEa\u0015\u000e\u0005\t=#\u0002\u0002B)\u0003o\u000b!![8\n\t\u0005\r&q\n\u000b\u0003\u0005w\tQ!\u00199qYf$\u0002\"a<\u0003\\\tu#q\f\u0005\b\u0003c*\u0004\u0019AA;\u0011%\tY(\u000eI\u0001\u0002\u0004\ty\b\u0003\u0005\u0002\u0006V\u0002\n\u00111\u0001}\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u0012\u0014aD1qa2LH\u0005Z3gCVdG\u000fJ\u001a\u0002\u000fUt\u0017\r\u001d9msR!!\u0011\u000eB;!\u0015i'1\u000eB8\u0013\r\u0011iG\u001c\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u00115\u0014\t(!\u001e\u0002\u0000qL1Aa\u001do\u0005\u0019!V\u000f\u001d7fg!I!q\u000f\u001d\u0002\u0002\u0003\u0007\u0011q^\u0001\u0004q\u0012\u0002\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$He\r\u0002\u0006\u0005\u0006$8\r[\n\u0007w1\fy)!&\u0002\u000b9\fW.\u001a\u0011\u0002\u0011M$(/\u0019;fOf,\"!!\u001c\u0002\u0013M$(/\u0019;fOf\u0004SC\u0001BF!\u0015i'Q\u0012BI\u0013\r\u0011yI\u001c\u0002\u000byI,\u0007/Z1uK\u0012t\u0004#B5\u0003\u0014\u0006]\u0012b\u0001BK7\n!!+\u001e7f\u0003\u0019\u0011X\u000f\\3tAQA!1\u0014BO\u0005?\u0013\t\u000bE\u0002\u0002pmBa!a\u0019C\u0001\u0004a\bb\u0002BB\u0005\u0002\u0007\u0011Q\u000e\u0005\u00079\n\u0003\rAa#\u0015\t\u0005u#Q\u0015\u0005\n\u0003\u000b,\u0015\u0011!a\u0001\u0003k\"B!a \u0003*\"I\u0011QY$\u0002\u0002\u0003\u0007\u0011Q\f\u000b\u0005\u0003_\u0013i\u000bC\u0005\u0002F\"\u000b\t\u00111\u0001\u0002vQ!\u0011q\u0010BY\u0011%\t)mSA\u0001\u0002\u0004\ti&A\u0003CCR\u001c\u0007\u000eE\u0002\u0002p5\u001bR!\u0014B]\u0005\u0017\u00022B!\u0011\u0003Hq\fiGa#\u0003\u001cR\u0011!Q\u0017\u000b\t\u00057\u0013yL!1\u0003D\"1\u00111\r)A\u0002qDqAa!Q\u0001\u0004\ti\u0007\u0003\u0004]!\u0002\u0007!1R\u0001\u000bk:\f\u0007\u000f\u001d7z'\u0016\fH\u0003\u0002Be\u0005'\u0004R!\u001cB6\u0005\u0017\u0004\u0002\"\u001cB9y\u00065$Q\u001a\t\u0007\u0003/\u0013yM!%\n\t\tE\u0017Q\u0015\u0002\u0004'\u0016\f\b\"\u0003B<#\u0006\u0005\t\u0019\u0001BN\u0003\u001d\u0011\u0017\r^2iKN,\"A!7\u0011\r\u0005]%q\u001aBN\u0003M)\u0007p\u00197vI\u0016$wJ\\2f\u0005\u0006$8\r[3t+\t\u0011y\u000e\u0005\u0003~\u0005Cd\u0018\u0002\u0002Br\u0003\u001b\u00111aU3u\u0003Q)\u0007p\u00197vI\u0016$wJ\\2f\u0005\u0006$8\r[3tA\u0005\u0019b/\u00197jI\u0006$X\r\u00157b]\u000eC\u0017M\\4fgR1!1\u001eBw\u0005c\u0004B!\u001cB6y\"9!q^+A\u0002\u0005]\u0012\u0001\u00049sKZLw.^:QY\u0006t\u0007b\u0002Bz+\u0002\u0007\u0011qG\u0001\fGV\u0014(/\u001a8u!2\fg.\u0001\u0010wC2LG-\u0019;f!2\fgn\u00115b]\u001e,7\u000fT5hQR<X-[4iiR1!1\u001eB}\u0005wDqAa<W\u0001\u0004\t9\u0004C\u0004\u0003tZ\u0003\r!a\u000e\u0002+\rDWmY6CCR\u001c\u0007.\u00133f[B|G/\u001a8dKR1\u00111CB\u0001\u0007\u000bAqaa\u0001X\u0001\u0004\u0011Y*A\u0003cCR\u001c\u0007\u000eC\u0004\u0004\b]\u0003\r!a\u000e\u0002\tAd\u0017M\\\u0001\u0010Kb,7-\u001e;f\u0003:$GK]1dWR1\u0011qGB\u0007\u0007\u001fAqaa\u0002Y\u0001\u0004\t9\u0004C\u0004\u0004\u0012a\u0003\raa\u0005\u0002\u000fQ\u0014\u0018mY6feB!1QCB\f\u001b\u0005i\u0016bAB\r;\n!\u0012+^3ssBc\u0017M\u001c8j]\u001e$&/Y2lKJ\fq!\u001a=fGV$X\r\u0006\u0003\u00028\r}\u0001bBB\u00043\u0002\u0007\u0011q\u0007")
public abstract class RuleExecutor<TreeType extends TreeNode<?>>
implements Logging {
    private volatile RuleExecutor$Once$ Once$module;
    private volatile RuleExecutor$FixedPoint$ FixedPoint$module;
    private volatile RuleExecutor$Batch$ Batch$module;
    private final Set<String> excludedOnceBatches;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static QueryExecutionMetrics getCurrentMetrics() {
        return RuleExecutor$.MODULE$.getCurrentMetrics();
    }

    public static void resetMetrics() {
        RuleExecutor$.MODULE$.resetMetrics();
    }

    public static String dumpTimeSpent() {
        return RuleExecutor$.MODULE$.dumpTimeSpent();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public RuleExecutor$Once$ Once() {
        if (this.Once$module == null) {
            this.Once$lzycompute$1();
        }
        return this.Once$module;
    }

    public RuleExecutor$FixedPoint$ FixedPoint() {
        if (this.FixedPoint$module == null) {
            this.FixedPoint$lzycompute$1();
        }
        return this.FixedPoint$module;
    }

    public RuleExecutor$Batch$ Batch() {
        if (this.Batch$module == null) {
            this.Batch$lzycompute$1();
        }
        return this.Batch$module;
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String name() {
        String className = this.getClass().getName();
        if (className.endsWith("$")) {
            return StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(className), 1);
        }
        return className;
    }

    public abstract Seq<Batch> batches();

    public Set<String> excludedOnceBatches() {
        return this.excludedOnceBatches;
    }

    public Option<String> validatePlanChanges(TreeType previousPlan, TreeType currentPlan) {
        return None$.MODULE$;
    }

    public Option<String> validatePlanChangesLightweight(TreeType previousPlan, TreeType currentPlan) {
        return None$.MODULE$;
    }

    private void checkBatchIdempotence(Batch batch, TreeType plan2) {
        TreeNode reOptimized = (TreeNode)batch.rules().foldLeft(plan2, (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                TreeNode p = (TreeNode)tuple2._1();
                Rule rule = (Rule)tuple2._2();
                return rule.apply(p);
            }
            throw new MatchError((Object)tuple2);
        });
        if (!((TreeNode)plan2).fastEquals(reOptimized)) {
            throw QueryExecutionErrors$.MODULE$.onceStrategyIdempotenceIsBrokenForBatchError(batch.name(), plan2, reOptimized);
        }
    }

    public TreeType executeAndTrack(TreeType plan2, QueryPlanningTracker tracker) {
        return (TreeType)((TreeNode)QueryPlanningTracker$.MODULE$.withTracker(tracker, (Function0 & Serializable)() -> this.execute(plan2)));
    }

    public TreeType execute(TreeType plan2) {
        LazyBoolean lightweightValidation$lzy = new LazyBoolean();
        ObjectRef curPlan = ObjectRef.create(plan2);
        QueryExecutionMetering queryExecutionMetrics = RuleExecutor$.MODULE$.queryExecutionMeter();
        PlanChangeLogger planChangeLogger = new PlanChangeLogger();
        Option<QueryPlanningTracker> tracker = QueryPlanningTracker$.MODULE$.get();
        QueryExecutionMetrics beforeMetrics = RuleExecutor$.MODULE$.getCurrentMetrics();
        boolean fullValidation = BoxesRunTime.unboxToBoolean((Object)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.PLAN_CHANGE_VALIDATION()));
        if (fullValidation) {
            Option<String> option = this.validatePlanChanges(plan2, plan2);
            if (option instanceof Some) {
                Some some = (Some)option;
                String msg = (String)some.value();
                String ruleExecutorName = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(this.getClass().getName()), "$");
                throw new SparkException("PLAN_VALIDATION_FAILED_RULE_EXECUTOR", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ruleExecutor"), (Object)ruleExecutorName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"reason"), (Object)msg)})), null);
            }
        }
        this.batches().foreach((Function1 & Serializable)batch -> {
            RuleExecutor.$anonfun$execute$1(this, curPlan, queryExecutionMetrics, planChangeLogger, fullValidation, tracker, lightweightValidation$lzy, batch);
            return BoxedUnit.UNIT;
        });
        planChangeLogger.logMetrics(this.name(), RuleExecutor$.MODULE$.getCurrentMetrics().$minus(beforeMetrics));
        return (TreeType)((TreeNode)curPlan.elem);
    }

    private final void Once$lzycompute$1() {
        RuleExecutor ruleExecutor = this;
        synchronized (ruleExecutor) {
            if (this.Once$module == null) {
                this.Once$module = new RuleExecutor$Once$(this);
            }
        }
    }

    private final void FixedPoint$lzycompute$1() {
        RuleExecutor ruleExecutor = this;
        synchronized (ruleExecutor) {
            if (this.FixedPoint$module == null) {
                this.FixedPoint$module = new RuleExecutor$FixedPoint$(this);
            }
        }
    }

    private final void Batch$lzycompute$1() {
        RuleExecutor ruleExecutor = this;
        synchronized (ruleExecutor) {
            if (this.Batch$module == null) {
                this.Batch$module = new RuleExecutor$Batch$(this);
            }
        }
    }

    private static final /* synthetic */ boolean lightweightValidation$lzycompute$1(LazyBoolean lightweightValidation$lzy$1) {
        boolean bl;
        LazyBoolean lazyBoolean = lightweightValidation$lzy$1;
        synchronized (lazyBoolean) {
            bl = lightweightValidation$lzy$1.initialized() ? lightweightValidation$lzy$1.value() : lightweightValidation$lzy$1.initialize(BoxesRunTime.unboxToBoolean((Object)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.LIGHTWEIGHT_PLAN_CHANGE_VALIDATION())));
        }
        return bl;
    }

    private static final boolean lightweightValidation$1(LazyBoolean lightweightValidation$lzy$1) {
        if (lightweightValidation$lzy$1.initialized()) {
            return lightweightValidation$lzy$1.value();
        }
        return RuleExecutor.lightweightValidation$lzycompute$1(lightweightValidation$lzy$1);
    }

    public static final /* synthetic */ void $anonfun$execute$1(RuleExecutor $this, ObjectRef curPlan$1, QueryExecutionMetering queryExecutionMetrics$1, PlanChangeLogger planChangeLogger$1, boolean fullValidation$1, Option tracker$1, LazyBoolean lightweightValidation$lzy$1, Batch batch) {
        TreeNode batchStartPlan = (TreeNode)curPlan$1.elem;
        IntRef iteration = IntRef.create((int)1);
        TreeNode lastPlan = (TreeNode)curPlan$1.elem;
        boolean bl = true;
        while (bl) {
            curPlan$1.elem = (TreeNode)batch.rules().foldLeft((Object)((TreeNode)curPlan$1.elem), (Function2 & Serializable)(x0$1, x1$1) -> {
                Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                if (tuple2 != null) {
                    boolean effective;
                    TreeNode plan2 = (TreeNode)tuple2._1();
                    Rule rule = (Rule)tuple2._2();
                    long startTime = System.nanoTime();
                    TreeNode result = rule.apply(plan2);
                    long runTime = System.nanoTime() - startTime;
                    boolean bl = effective = !result.fastEquals(plan2);
                    if (effective) {
                        queryExecutionMetrics$1.incNumEffectiveExecution(rule.ruleName());
                        queryExecutionMetrics$1.incTimeEffectiveExecutionBy(rule.ruleName(), runTime);
                        planChangeLogger$1.logRule(rule.ruleName(), plan2, result);
                        if (fullValidation$1 || RuleExecutor.lightweightValidation$1(lightweightValidation$lzy$1)) {
                            Option<String> validationResult = fullValidation$1 ? $this.validatePlanChanges(plan2, result) : $this.validatePlanChangesLightweight(plan2, result);
                            Option<String> option = validationResult;
                            if (option instanceof Some) {
                                Some some = (Some)option;
                                String msg = (String)some.value();
                                throw new SparkException("PLAN_VALIDATION_FAILED_RULE_IN_BATCH", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rule"), (Object)rule.ruleName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"batch"), (Object)batch.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"reason"), (Object)msg)})), null);
                            }
                        }
                    }
                    queryExecutionMetrics$1.incExecutionTimeBy(rule.ruleName(), runTime);
                    queryExecutionMetrics$1.incNumExecution(rule.ruleName());
                    tracker$1.foreach((Function1 & Serializable)x$1 -> {
                        x$1.recordRuleInvocation(rule.ruleName(), runTime, effective);
                        return BoxedUnit.UNIT;
                    });
                    return result;
                }
                throw new MatchError((Object)tuple2);
            });
            ++iteration.elem;
            if (iteration.elem > batch.strategy().maxIterations()) {
                if (iteration.elem != 2) {
                    MessageWithContext endingMsg = batch.strategy().maxIterationsSetting() == null ? $this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"."}))).log((Seq)Nil$.MODULE$) : $this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{", please set '", "' "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_ITERATIONS$.MODULE$, (Object)batch.strategy().maxIterationsSetting())})).$plus($this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"to a larger value."}))).log((Seq)Nil$.MODULE$));
                    MessageWithContext log = $this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Max iterations (", ") "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_ITERATIONS$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)(iteration.elem - 1)))})).$plus($this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"reached for batch ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.BATCH_NAME$.MODULE$, (Object)batch.name())}))).$plus(endingMsg);
                    if (Utils$.MODULE$.isTesting() || batch.strategy().errorOnExceed()) {
                        throw new RuntimeException(log.message());
                    }
                    $this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> log));
                }
                Strategy strategy = batch.strategy();
                RuleExecutor$Once$ ruleExecutor$Once$ = $this.Once();
                if (!(strategy != null ? !strategy.equals(ruleExecutor$Once$) : ruleExecutor$Once$ != null)) {
                    if (Utils$.MODULE$.isTesting() && !$this.excludedOnceBatches().contains((Object)batch.name())) {
                        $this.checkBatchIdempotence(batch, (TreeNode)curPlan$1.elem);
                    }
                }
                bl = false;
            }
            if (((TreeNode)curPlan$1.elem).fastEquals(lastPlan)) {
                $this.logTrace((Function0<String>)(Function0 & Serializable)() -> "Fixed point reached for batch " + batch.name() + " after " + (iteration$1.elem - 1) + " iterations.");
                bl = false;
            }
            lastPlan = (TreeNode)curPlan$1.elem;
        }
        planChangeLogger$1.logBatch(batch.name(), batchStartPlan, (TreeNode)curPlan$1.elem);
    }

    public RuleExecutor() {
        Logging.$init$((Logging)this);
        this.excludedOnceBatches = Predef$.MODULE$.Set().empty();
    }

    public class Batch
    implements Product,
    Serializable {
        private final String name;
        private final Strategy strategy;
        private final Seq<Rule<TreeType>> rules;
        public final /* synthetic */ RuleExecutor $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String name() {
            return this.name;
        }

        public Strategy strategy() {
            return this.strategy;
        }

        public Seq<Rule<TreeType>> rules() {
            return this.rules;
        }

        public String productPrefix() {
            return "Batch";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.name();
                }
                case 1: {
                    return this.strategy();
                }
                case 2: {
                    return this.rules();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Batch;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "name";
                }
                case 1: {
                    return "strategy";
                }
                case 2: {
                    return "rules";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Batch)) return false;
            if (((Batch)object).org$apache$spark$sql$catalyst$rules$RuleExecutor$Batch$$$outer() != this.org$apache$spark$sql$catalyst$rules$RuleExecutor$Batch$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            Batch batch = (Batch)x$1;
            String string = this.name();
            String string2 = batch.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Strategy strategy = this.strategy();
            Strategy strategy2 = batch.strategy();
            if (strategy == null) {
                if (strategy2 != null) {
                    return false;
                }
            } else if (!strategy.equals(strategy2)) return false;
            Seq seq = this.rules();
            Seq seq2 = batch.rules();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            if (!batch.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ RuleExecutor org$apache$spark$sql$catalyst$rules$RuleExecutor$Batch$$$outer() {
            return this.$outer;
        }

        public Batch(RuleExecutor $outer, String name, Strategy strategy, Seq<Rule<TreeType>> rules) {
            this.name = name;
            this.strategy = strategy;
            this.rules = rules;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }

    public class FixedPoint
    extends Strategy
    implements Product,
    Serializable {
        private final int maxIterations;
        private final boolean errorOnExceed;
        private final String maxIterationsSetting;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        @Override
        public int maxIterations() {
            return this.maxIterations;
        }

        @Override
        public boolean errorOnExceed() {
            return this.errorOnExceed;
        }

        @Override
        public String maxIterationsSetting() {
            return this.maxIterationsSetting;
        }

        public FixedPoint copy(int maxIterations, boolean errorOnExceed, String maxIterationsSetting) {
            return new FixedPoint(this.org$apache$spark$sql$catalyst$rules$RuleExecutor$FixedPoint$$$outer(), maxIterations, errorOnExceed, maxIterationsSetting);
        }

        public int copy$default$1() {
            return this.maxIterations();
        }

        public boolean copy$default$2() {
            return this.errorOnExceed();
        }

        public String copy$default$3() {
            return this.maxIterationsSetting();
        }

        public String productPrefix() {
            return "FixedPoint";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return BoxesRunTime.boxToInteger((int)this.maxIterations());
                }
                case 1: {
                    return BoxesRunTime.boxToBoolean((boolean)this.errorOnExceed());
                }
                case 2: {
                    return this.maxIterationsSetting();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof FixedPoint;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "maxIterations";
                }
                case 1: {
                    return "errorOnExceed";
                }
                case 2: {
                    return "maxIterationsSetting";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.maxIterations());
            n = Statics.mix((int)n, (int)(this.errorOnExceed() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.maxIterationsSetting()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof FixedPoint)) return false;
            if (((FixedPoint)object).org$apache$spark$sql$catalyst$rules$RuleExecutor$FixedPoint$$$outer() != this.org$apache$spark$sql$catalyst$rules$RuleExecutor$FixedPoint$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            FixedPoint fixedPoint = (FixedPoint)x$1;
            if (this.maxIterations() != fixedPoint.maxIterations()) return false;
            if (this.errorOnExceed() != fixedPoint.errorOnExceed()) return false;
            String string = this.maxIterationsSetting();
            String string2 = fixedPoint.maxIterationsSetting();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!fixedPoint.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ RuleExecutor org$apache$spark$sql$catalyst$rules$RuleExecutor$FixedPoint$$$outer() {
            return this.$outer;
        }

        public FixedPoint(RuleExecutor $outer, int maxIterations, boolean errorOnExceed, String maxIterationsSetting) {
            this.maxIterations = maxIterations;
            this.errorOnExceed = errorOnExceed;
            this.maxIterationsSetting = maxIterationsSetting;
            Product.$init$((Product)this);
        }
    }

    public abstract class Strategy {
        public abstract int maxIterations();

        public boolean errorOnExceed() {
            return false;
        }

        public String maxIterationsSetting() {
            return null;
        }

        public /* synthetic */ RuleExecutor org$apache$spark$sql$catalyst$rules$RuleExecutor$Strategy$$$outer() {
            return RuleExecutor.this;
        }

        public Strategy() {
            if (RuleExecutor.this == null) {
                throw null;
            }
        }
    }
}

