/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.metrics;

import java.util.concurrent.TimeUnit;
import org.apache.spark.SparkConf;
import org.apache.spark.metrics.MetricsSystem;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.util.matching.Regex;

public final class MetricsSystem$ {
    public static final MetricsSystem$ MODULE$ = new MetricsSystem$();
    private static final Regex SINK_REGEX = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^sink\\.(.+)\\.(.+)"));
    private static final Regex SOURCE_REGEX = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^source\\.(.+)\\.(.+)"));
    private static final TimeUnit MINIMAL_POLL_UNIT = TimeUnit.SECONDS;
    private static final int MINIMAL_POLL_PERIOD = 1;

    public Regex SINK_REGEX() {
        return SINK_REGEX;
    }

    public Regex SOURCE_REGEX() {
        return SOURCE_REGEX;
    }

    public void checkMinimalPollingPeriod(TimeUnit pollUnit, int pollPeriod) {
        long period = MINIMAL_POLL_UNIT.convert(pollPeriod, pollUnit);
        if (period < (long)MINIMAL_POLL_PERIOD) {
            throw new IllegalArgumentException(new StringBuilder(51).append("Polling period ").append(pollPeriod).append(" ").append((Object)pollUnit).append(" below than minimal polling period ").toString());
        }
    }

    public MetricsSystem createMetricsSystem(String instance, SparkConf conf) {
        return new MetricsSystem(instance, conf);
    }

    private MetricsSystem$() {
    }
}

