/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.thriftserver;

import java.io.Serializable;
import java.util.Collections;
import org.apache.hive.service.rpc.thrift.TColumnDesc;
import org.apache.hive.service.rpc.thrift.TPrimitiveTypeEntry;
import org.apache.hive.service.rpc.thrift.TTableSchema;
import org.apache.hive.service.rpc.thrift.TTypeDesc;
import org.apache.hive.service.rpc.thrift.TTypeEntry;
import org.apache.hive.service.rpc.thrift.TTypeId;
import org.apache.hive.service.rpc.thrift.TTypeQualifierValue;
import org.apache.hive.service.rpc.thrift.TTypeQualifiers;
import org.apache.spark.sql.catalyst.util.CharVarcharUtils$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.CharType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.VarcharType;
import org.apache.spark.sql.types.YearMonthIntervalType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

public final class SparkExecuteStatementOperation$ {
    public static final SparkExecuteStatementOperation$ MODULE$ = new SparkExecuteStatementOperation$();

    public boolean $lessinit$greater$default$5() {
        return true;
    }

    public TTypeId toTTypeId(DataType typ) {
        TTypeId tTypeId;
        DataType dataType = typ;
        if (NullType$.MODULE$.equals(dataType)) {
            tTypeId = TTypeId.NULL_TYPE;
        } else if (BooleanType$.MODULE$.equals(dataType)) {
            tTypeId = TTypeId.BOOLEAN_TYPE;
        } else if (ByteType$.MODULE$.equals(dataType)) {
            tTypeId = TTypeId.TINYINT_TYPE;
        } else if (ShortType$.MODULE$.equals(dataType)) {
            tTypeId = TTypeId.SMALLINT_TYPE;
        } else if (IntegerType$.MODULE$.equals(dataType)) {
            tTypeId = TTypeId.INT_TYPE;
        } else if (LongType$.MODULE$.equals(dataType)) {
            tTypeId = TTypeId.BIGINT_TYPE;
        } else if (FloatType$.MODULE$.equals(dataType)) {
            tTypeId = TTypeId.FLOAT_TYPE;
        } else if (DoubleType$.MODULE$.equals(dataType)) {
            tTypeId = TTypeId.DOUBLE_TYPE;
        } else if (StringType$.MODULE$.equals(dataType)) {
            tTypeId = TTypeId.STRING_TYPE;
        } else if (dataType instanceof DecimalType) {
            tTypeId = TTypeId.DECIMAL_TYPE;
        } else if (DateType$.MODULE$.equals(dataType)) {
            tTypeId = TTypeId.DATE_TYPE;
        } else if (TimestampType$.MODULE$.equals(dataType)) {
            tTypeId = TTypeId.TIMESTAMP_TYPE;
        } else if (TimestampNTZType$.MODULE$.equals(dataType)) {
            tTypeId = TTypeId.TIMESTAMP_TYPE;
        } else if (BinaryType$.MODULE$.equals(dataType)) {
            tTypeId = TTypeId.BINARY_TYPE;
        } else if (CalendarIntervalType$.MODULE$.equals(dataType)) {
            tTypeId = TTypeId.STRING_TYPE;
        } else if (dataType instanceof DayTimeIntervalType) {
            tTypeId = TTypeId.INTERVAL_DAY_TIME_TYPE;
        } else if (dataType instanceof YearMonthIntervalType) {
            tTypeId = TTypeId.INTERVAL_YEAR_MONTH_TYPE;
        } else if (dataType instanceof ArrayType) {
            tTypeId = TTypeId.ARRAY_TYPE;
        } else if (dataType instanceof MapType) {
            tTypeId = TTypeId.MAP_TYPE;
        } else if (dataType instanceof StructType) {
            tTypeId = TTypeId.STRUCT_TYPE;
        } else if (dataType instanceof CharType) {
            tTypeId = TTypeId.CHAR_TYPE;
        } else if (dataType instanceof VarcharType) {
            tTypeId = TTypeId.VARCHAR_TYPE;
        } else {
            throw new IllegalArgumentException(new StringBuilder(24).append("Unrecognized type name: ").append(dataType.catalogString()).toString());
        }
        return tTypeId;
    }

    private TTypeQualifiers toTTypeQualifiers(DataType typ) {
        java.util.Map map;
        TTypeQualifiers ret = new TTypeQualifiers();
        DataType dataType = typ;
        if (dataType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType;
            map = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"precision"), (Object)TTypeQualifierValue.i32Value((int)decimalType.precision())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"scale"), (Object)TTypeQualifierValue.i32Value((int)decimalType.scale()))}))).asJava();
        } else {
            boolean bl = dataType instanceof VarcharType ? true : dataType instanceof CharType;
            map = bl ? (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"characterMaximumLength"), (Object)TTypeQualifierValue.i32Value((int)typ.defaultSize()))}))).asJava() : Collections.emptyMap();
        }
        java.util.Map qualifiers = map;
        ret.setQualifiers(qualifiers);
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    private TTypeDesc toTTypeDesc(DataType typ) {
        void var3_3;
        TPrimitiveTypeEntry typeEntry = new TPrimitiveTypeEntry(this.toTTypeId(typ));
        typeEntry.setTypeQualifiers(this.toTTypeQualifiers(typ));
        TTypeDesc tTypeDesc = new TTypeDesc();
        tTypeDesc.addToTypes(TTypeEntry.primitiveEntry((TPrimitiveTypeEntry)typeEntry));
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private TColumnDesc toTColumnDesc(StructField field, int pos) {
        void var3_3;
        TColumnDesc tColumnDesc = new TColumnDesc();
        tColumnDesc.setColumnName(field.name());
        tColumnDesc.setTypeDesc(this.toTTypeDesc(field.dataType()));
        tColumnDesc.setComment((String)field.getComment().getOrElse((Function0 & Serializable)() -> ""));
        tColumnDesc.setPosition(pos);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public TTableSchema toTTableSchema(StructType schema) {
        void var2_2;
        TTableSchema tTableSchema = new TTableSchema();
        ((IterableOnceOps)CharVarcharUtils$.MODULE$.getRawSchema(schema).zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
            SparkExecuteStatementOperation$.$anonfun$toTTableSchema$1(tTableSchema, x0$1);
            return BoxedUnit.UNIT;
        });
        return var2_2;
    }

    public static final /* synthetic */ void $anonfun$toTTableSchema$1(TTableSchema tTableSchema$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        StructField f = (StructField)tuple2._1();
        int i = tuple2._2$mcI$sp();
        tTableSchema$1.addToColumns(MODULE$.toTColumnDesc(f, i));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private SparkExecuteStatementOperation$() {
    }
}

