/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.dsl.package$expressions$;
import org.apache.spark.sql.catalyst.expressions.Add;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.BinaryOperator;
import org.apache.spark.sql.catalyst.expressions.CheckOverflowInSum;
import org.apache.spark.sql.catalyst.expressions.DecimalAddNoOverflowCheck;
import org.apache.spark.sql.catalyst.expressions.EvalMode$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.KnownNotNull;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Predicate;
import org.apache.spark.sql.catalyst.expressions.SupportQueryContext;
import org.apache.spark.sql.catalyst.expressions.aggregate.DeclarativeAggregate;
import org.apache.spark.sql.catalyst.expressions.aggregate.Sum$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.trees.SQLQueryContext;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.catalyst.trees.UnaryLike;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AnsiIntervalType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.NumericType$;
import org.apache.spark.sql.types.TypeCollection;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import scala.Enumeration;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(expr) - Returns the sum calculated from values of a group.", examples="\n    Examples:\n      > SELECT _FUNC_(col) FROM VALUES (5), (10), (15) AS tab(col);\n       30\n      > SELECT _FUNC_(col) FROM VALUES (NULL), (10), (15) AS tab(col);\n       25\n      > SELECT _FUNC_(col) FROM VALUES (NULL), (NULL) AS tab(col);\n       NULL\n  ", group="agg_funcs", since="1.0.0")
@ScalaSignature(bytes="\u0006\u0005\t}e\u0001\u0002\u00180\u0001zB\u0001\"\u001a\u0001\u0003\u0016\u0004%\tA\u001a\u0005\tO\u0002\u0011\t\u0012)A\u0005\u001b\"A\u0001\u000e\u0001BK\u0002\u0013\u0005\u0011\u000e\u0003\u0005s\u0001\tE\t\u0015!\u0003k\u0011\u0015\u0019\b\u0001\"\u0001u\u0011\u0015\u0019\b\u0001\"\u0001y\u0011\u0015Q\b\u0001\"\u0003|\u0011\u0015y\b\u0001\"\u0011|\u0011\u001d\t\t\u0001\u0001C!\u0003\u0007Aq!!\u0005\u0001\t\u0003\n\u0019\u0002C\u0004\u0002\"\u0001!\t%a\t\t\u0013\u0005E\u0002A1A\u0005F\u0005M\u0002\u0002CA/\u0001\u0001\u0006i!!\u000e\t\u0015\u0005}\u0003\u0001#b\u0001\n\u0013\t\t\u0007\u0003\u0006\u0002~\u0001A)\u0019!C\u0005\u0003\u007fB!\"a\"\u0001\u0011\u000b\u0007I\u0011BA@\u0011)\tI\t\u0001EC\u0002\u0013%\u00111\u0012\u0005\b\u0003'\u0003A\u0011BAK\u0011)\ty\n\u0001EC\u0002\u0013\u0005\u0013\u0011\u0015\u0005\u000b\u0003K\u0003\u0001R1A\u0005B\u0005\u001d\u0006BCAV\u0001!\u0015\r\u0011\"\u0011\u0002(\"Q\u0011Q\u0016\u0001\t\u0006\u0004%\t%a*\t\u0013\u0005=\u0006\u0001#b\u0001\n\u00032\u0007bBAY\u0001\u0011\u0005\u00131\u0017\u0005\b\u0003\u0003\u0004A\u0011IAb\u0011\u001d\t\t\u000e\u0001C)\u0003'D\u0011\"!7\u0001\u0003\u0003%\t!a7\t\u0013\u0005\u0005\b!%A\u0005\u0002\u0005\r\b\"CA}\u0001E\u0005I\u0011AA~\u0011%\ty\u0010AA\u0001\n\u0003\u0012\t\u0001C\u0005\u0003\u0010\u0001\t\t\u0011\"\u0001\u0003\u0012!I!\u0011\u0004\u0001\u0002\u0002\u0013\u0005!1\u0004\u0005\n\u0005C\u0001\u0011\u0011!C!\u0005GA\u0011Ba\f\u0001\u0003\u0003%\tA!\r\t\u0013\tU\u0002!!A\u0005B\t]\u0002\"\u0003B\u001e\u0001\u0005\u0005I\u0011\tB\u001f\u000f%\u0011\tgLA\u0001\u0012\u0003\u0011\u0019G\u0002\u0005/_\u0005\u0005\t\u0012\u0001B3\u0011\u0019\u0019h\u0005\"\u0001\u0003t!I!Q\u000f\u0014\u0002\u0002\u0013\u0015#q\u000f\u0005\n\u0005s2\u0013\u0011!CA\u0005wB\u0011B!!'#\u0003%\t!a?\t\u0013\t\re%!A\u0005\u0002\n\u0015\u0005\"\u0003BJME\u0005I\u0011AA~\u0011%\u0011)JJA\u0001\n\u0013\u00119JA\u0002Tk6T!\u0001M\u0019\u0002\u0013\u0005<wM]3hCR,'B\u0001\u001a4\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005Q*\u0014\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005Y:\u0014aA:rY*\u0011\u0001(O\u0001\u0006gB\f'o\u001b\u0006\u0003um\na!\u00199bG\",'\"\u0001\u001f\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000f\u0001y4i\u0012)T3B\u0011\u0001)Q\u0007\u0002_%\u0011!i\f\u0002\u0015\t\u0016\u001cG.\u0019:bi&4X-Q4he\u0016<\u0017\r^3\u0011\u0005\u0011+U\"A\u0019\n\u0005\u0019\u000b$AF%na2L7-\u001b;DCN$\u0018J\u001c9viRK\b/Z:\u0011\u0007![U*D\u0001J\u0015\tQ5'A\u0003ue\u0016,7/\u0003\u0002M\u0013\nIQK\\1ss2K7.\u001a\t\u0003\t:K!aT\u0019\u0003\u0015\u0015C\bO]3tg&|g\u000e\u0005\u0002E#&\u0011!+\r\u0002\u0014'V\u0004\bo\u001c:u#V,'/_\"p]R,\u0007\u0010\u001e\t\u0003)^k\u0011!\u0016\u0006\u0002-\u0006)1oY1mC&\u0011\u0001,\u0016\u0002\b!J|G-^2u!\tQ&M\u0004\u0002\\A:\u0011AlX\u0007\u0002;*\u0011a,P\u0001\u0007yI|w\u000e\u001e \n\u0003YK!!Y+\u0002\u000fA\f7m[1hK&\u00111\r\u001a\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003CV\u000bQa\u00195jY\u0012,\u0012!T\u0001\u0007G\"LG\u000e\u001a\u0011\u0002\u0011\u00154\u0018\r\\'pI\u0016,\u0012A\u001b\t\u0003W:t!\u0001\u00127\n\u00055\f\u0014\u0001C#wC2lu\u000eZ3\n\u0005=\u0004(!\u0002,bYV,\u0017BA9V\u0005-)e.^7fe\u0006$\u0018n\u001c8\u0002\u0013\u00154\u0018\r\\'pI\u0016\u0004\u0013A\u0002\u001fj]&$h\bF\u0002vm^\u0004\"\u0001\u0011\u0001\t\u000b\u0015,\u0001\u0019A'\t\u000f!,\u0001\u0013!a\u0001UR\u0011Q/\u001f\u0005\u0006K\u001a\u0001\r!T\u0001\u0013g\"|W\u000f\u001c3Ue\u0006\u001c7.S:F[B$\u00180F\u0001}!\t!V0\u0003\u0002\u007f+\n9!i\\8mK\u0006t\u0017\u0001\u00038vY2\f'\r\\3\u0002\u0011\u0011\fG/\u0019+za\u0016,\"!!\u0002\u0011\t\u0005\u001d\u0011QB\u0007\u0003\u0003\u0013Q1!a\u00036\u0003\u0015!\u0018\u0010]3t\u0013\u0011\ty!!\u0003\u0003\u0011\u0011\u000bG/\u0019+za\u0016\f!\"\u001b8qkR$\u0016\u0010]3t+\t\t)\u0002E\u0003[\u0003/\tY\"C\u0002\u0002\u001a\u0011\u00141aU3r!\u0011\t9!!\b\n\t\u0005}\u0011\u0011\u0002\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016\f1c\u00195fG.Le\u000e];u\t\u0006$\u0018\rV=qKN$\"!!\n\u0011\t\u0005\u001d\u0012QF\u0007\u0003\u0003SQ1!a\u000b4\u0003!\tg.\u00197zg&\u001c\u0018\u0002BA\u0018\u0003S\u0011q\u0002V=qK\u000eCWmY6SKN,H\u000e^\u0001\r]>$W\rU1ui\u0016\u0014hn]\u000b\u0003\u0003k\u0001RAWA\f\u0003o\u0001B!!\u000f\u0002X9!\u00111HA*\u001d\u0011\ti$!\u0015\u000f\t\u0005}\u0012q\n\b\u0005\u0003\u0003\niE\u0004\u0003\u0002D\u0005-c\u0002BA#\u0003\u0013r1\u0001XA$\u0013\u0005a\u0014B\u0001\u001e<\u0013\tA\u0014(\u0003\u00027o%\u0011A'N\u0005\u0003\u0015NJ1!!\u0016J\u0003-!&/Z3QCR$XM\u001d8\n\t\u0005e\u00131\f\u0002\f)J,W\rU1ui\u0016\u0014hNC\u0002\u0002V%\u000bQB\\8eKB\u000bG\u000f^3s]N\u0004\u0013A\u0003:fgVdG\u000fV=qKV\u0011\u00111\r\n\b\u0003K\nIgUA8\r\u0019\t9\u0007\u0001\u0001\u0002d\taAH]3gS:,W.\u001a8u}A!\u0011qAA6\u0013\u0011\ti'!\u0003\u0003\u0015\u0005#x.\\5d)f\u0004X\r\u0005\u0003\u0002r\u0005mTBAA:\u0015\u0011\t)(a\u001e\u0002\u0005%|'BAA=\u0003\u0011Q\u0017M^1\n\u0007\r\f\u0019(A\u0002tk6,\"!!!\u0011\u0007\u0011\u000b\u0019)C\u0002\u0002\u0006F\u0012!#\u0011;ue&\u0014W\u000f^3SK\u001a,'/\u001a8dK\u00069\u0011n]#naRL\u0018\u0001\u0002>fe>,\"!!$\u0011\u0007\u0011\u000by)C\u0002\u0002\u0012F\u0012q\u0001T5uKJ\fG.A\u0002bI\u0012$R!TAL\u00037Ca!!'\u0013\u0001\u0004i\u0015\u0001\u00027fMRDa!!(\u0013\u0001\u0004i\u0015!\u0002:jO\"$\u0018aE1hO\n+hMZ3s\u0003R$(/\u001b2vi\u0016\u001cXCAAR!\u0015Q\u0016qCAA\u00035Ig.\u001b;jC24\u0016\r\\;fgV\u0011\u0011\u0011\u0016\t\u00055\u0006]Q*A\tva\u0012\fG/Z#yaJ,7o]5p]N\f\u0001#\\3sO\u0016,\u0005\u0010\u001d:fgNLwN\\:\u0002%\u00154\u0018\r\\;bi\u0016,\u0005\u0010\u001d:fgNLwN\\\u0001\u000eM2\fG/\u0011:hk6,g\u000e^:\u0016\u0005\u0005U\u0006#\u0002.\u00028\u0006m\u0016bAA]I\nA\u0011\n^3sCR|'\u000fE\u0002U\u0003{K1!a0V\u0005\r\te._\u0001\u0011S:LG/U;fef\u001cuN\u001c;fqR$\"!!2\u0011\u000bQ\u000b9-a3\n\u0007\u0005%WK\u0001\u0004PaRLwN\u001c\t\u0004\u0011\u00065\u0017bAAh\u0013\ny1+\u0015'Rk\u0016\u0014\u0018pQ8oi\u0016DH/\u0001\u000bxSRDg*Z<DQ&dG-\u00138uKJt\u0017\r\u001c\u000b\u0004\u001b\u0006U\u0007BBAl5\u0001\u0007Q*\u0001\u0005oK^\u001c\u0005.\u001b7e\u0003\u0011\u0019w\u000e]=\u0015\u000bU\fi.a8\t\u000f\u0015\\\u0002\u0013!a\u0001\u001b\"9\u0001n\u0007I\u0001\u0002\u0004Q\u0017AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003KT3!TAtW\t\tI\u000f\u0005\u0003\u0002l\u0006UXBAAw\u0015\u0011\ty/!=\u0002\u0013Ut7\r[3dW\u0016$'bAAz+\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005]\u0018Q\u001e\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003{T3A[At\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011!1\u0001\t\u0005\u0005\u000b\u0011Y!\u0004\u0002\u0003\b)!!\u0011BA<\u0003\u0011a\u0017M\\4\n\t\t5!q\u0001\u0002\u0007'R\u0014\u0018N\\4\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\tM\u0001c\u0001+\u0003\u0016%\u0019!qC+\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005m&Q\u0004\u0005\n\u0005?\u0001\u0013\u0011!a\u0001\u0005'\t1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001B\u0013!\u0019\u00119C!\f\u0002<6\u0011!\u0011\u0006\u0006\u0004\u0005W)\u0016AC2pY2,7\r^5p]&!\u0011\u0011\u0018B\u0015\u0003!\u0019\u0017M\\#rk\u0006dGc\u0001?\u00034!I!q\u0004\u0012\u0002\u0002\u0003\u0007\u00111X\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0003\u0004\te\u0002\"\u0003B\u0010G\u0005\u0005\t\u0019\u0001B\n\u0003\u0019)\u0017/^1mgR\u0019APa\u0010\t\u0013\t}A%!AA\u0002\u0005m\u0006f\u0005\u0001\u0003D\t%#1\nB(\u0005#\u0012)Fa\u0016\u0003\\\tu\u0003c\u0001#\u0003F%\u0019!qI\u0019\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012!QJ\u0001B?\u001a+fjQ0)Kb\u0004(/\u000b\u0011.AI+G/\u001e:og\u0002\"\b.\u001a\u0011tk6\u00043-\u00197dk2\fG/\u001a3!MJ|W\u000e\t<bYV,7\u000fI8gA\u0005\u0004sM]8va:\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0005'\n\u0011q \u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)G>d\u0017\u0006\t$S\u001f6\u0003c+\u0011'V\u000bN\u0003\u0003&N\u0015-A!\n\u0004'\u000b\u0017!QE*\u0014\u0006I!TAQ\f'\rK2pY&Z$\u0002\t\u0011!A\u0001\u0002\u0003e\r\u0019\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\r|G.\u000b\u0011G%>k\u0005EV!M+\u0016\u001b\u0006\u0005\u000b(V\u00192KC\u0006\t\u00152a%b\u0003\u0005K\u00196S\u0001\n5\u000b\t;bE\"\u001aw\u000e\\\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AI*$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK2pY&\u0002cIU(NAY\u000bE*V#TA!rU\u000b\u0014'*Y\u0001Bc*\u0016'MS\u0001\n5\u000b\t;bE\"\u001aw\u000e\\\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A9+F\n\u0014\u0006!A\u0005)qM]8va\u0006\u0012!\u0011L\u0001\nC\u001e<wLZ;oGN\fQa]5oG\u0016\f#Aa\u0018\u0002\u000bEr\u0003G\f\u0019\u0002\u0007M+X\u000e\u0005\u0002AMM)aEa\u001a\u0002pA9!\u0011\u000eB8\u001b*,XB\u0001B6\u0015\r\u0011i'V\u0001\beVtG/[7f\u0013\u0011\u0011\tHa\u001b\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0006\u0002\u0003d\u0005AAo\\*ue&tw\r\u0006\u0002\u0003\u0004\u0005)\u0011\r\u001d9msR)QO! \u0003\u0000!)Q-\u000ba\u0001\u001b\"9\u0001.\u000bI\u0001\u0002\u0004Q\u0017aD1qa2LH\u0005Z3gCVdG\u000f\n\u001a\u0002\u000fUt\u0017\r\u001d9msR!!q\u0011BH!\u0015!\u0016q\u0019BE!\u0015!&1R'k\u0013\r\u0011i)\u0016\u0002\u0007)V\u0004H.\u001a\u001a\t\u0011\tE5&!AA\u0002U\f1\u0001\u001f\u00131\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%e\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011!\u0011\u0014\t\u0005\u0005\u000b\u0011Y*\u0003\u0003\u0003\u001e\n\u001d!AB(cU\u0016\u001cG\u000f")
public class Sum
extends DeclarativeAggregate
implements ImplicitCastInputTypes,
UnaryLike<Expression>,
SupportQueryContext {
    private AtomicType resultType;
    private AttributeReference sum;
    private AttributeReference isEmpty;
    private Literal zero;
    private Seq<AttributeReference> aggBufferAttributes;
    private Seq<Expression> initialValues;
    private Seq<Expression> updateExpressions;
    private Seq<Expression> mergeExpressions;
    private Expression evaluateExpression;
    private final Expression child;
    private final Enumeration.Value evalMode;
    private final Seq<Enumeration.Value> nodePatterns;
    private Option<SQLQueryContext> queryContext;
    private transient Seq<Expression> children;
    private volatile transient boolean bitmap$trans$0;
    private volatile int bitmap$0;

    public static Enumeration.Value $lessinit$greater$default$2() {
        return Sum$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Enumeration.Value>> unapply(Sum x$0) {
        return Sum$.MODULE$.unapply(x$0);
    }

    public static Enumeration.Value apply$default$2() {
        return Sum$.MODULE$.apply$default$2();
    }

    public static Function1<Tuple2<Expression, Enumeration.Value>, Sum> tupled() {
        return Sum$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Enumeration.Value, Sum>> curried() {
        return Sum$.MODULE$.curried();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$catalyst$expressions$SupportQueryContext$$super$copyTagsFrom(Expression other) {
        super.copyTagsFrom(other);
    }

    @Override
    public SQLQueryContext getContextOrNull() {
        return SupportQueryContext.getContextOrNull$(this);
    }

    @Override
    public String getContextOrNullCode(CodegenContext ctx, boolean withErrorContext) {
        return SupportQueryContext.getContextOrNullCode$(this, ctx, withErrorContext);
    }

    @Override
    public boolean getContextOrNullCode$default$2() {
        return SupportQueryContext.getContextOrNullCode$default$2$(this);
    }

    @Override
    public void copyTagsFrom(Expression other) {
        SupportQueryContext.copyTagsFrom$(this, other);
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return UnaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return UnaryLike.withNewChildrenInternal$(this, newChildren);
    }

    @Override
    public Option<SQLQueryContext> queryContext() {
        return this.queryContext;
    }

    @Override
    public void queryContext_$eq(Option<SQLQueryContext> x$1) {
        this.queryContext = x$1;
    }

    private Seq<Expression> children$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if (!this.bitmap$trans$0) {
                this.children = UnaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        return !this.bitmap$trans$0 ? this.children$lzycompute() : this.children;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public Enumeration.Value evalMode() {
        return this.evalMode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean shouldTrackIsEmpty() {
        boolean bl;
        AtomicType atomicType = this.resultType();
        if (atomicType instanceof DecimalType) {
            return true;
        }
        if (atomicType instanceof IntegralType) {
            bl = true;
        } else {
            if (!(atomicType instanceof AnsiIntervalType)) return false;
            bl = true;
        }
        if (!bl) return false;
        Enumeration.Value value = this.evalMode();
        Enumeration.Value value2 = EvalMode$.MODULE$.TRY();
        if (value != null) {
            if (!value.equals(value2)) return false;
            return true;
        }
        if (value2 == null) return true;
        return false;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public DataType dataType() {
        return this.resultType();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TypeCollection[]{TypeCollection$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{NumericType$.MODULE$, YearMonthIntervalType$.MODULE$, DayTimeIntervalType$.MODULE$}))}));
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return TypeUtils$.MODULE$.checkForAnsiIntervalOrNumericType(this.child());
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private AtomicType resultType$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if ((this.bitmap$0 & 1) == 0) {
                LongType$ longType$;
                DecimalType decimalType;
                Option option;
                DataType dataType = this.child().dataType();
                if (dataType instanceof DecimalType && !(option = DecimalType.Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType)).isEmpty()) {
                    int precision = ((Tuple2)option.get())._1$mcI$sp();
                    int scale = ((Tuple2)option.get())._2$mcI$sp();
                    longType$ = DecimalType$.MODULE$.bounded(precision + 10, scale);
                } else if (dataType instanceof IntegralType) {
                    longType$ = LongType$.MODULE$;
                } else if (dataType instanceof YearMonthIntervalType) {
                    YearMonthIntervalType yearMonthIntervalType = (YearMonthIntervalType)dataType;
                    longType$ = yearMonthIntervalType;
                } else if (dataType instanceof DayTimeIntervalType) {
                    DayTimeIntervalType dayTimeIntervalType = (DayTimeIntervalType)dataType;
                    longType$ = dayTimeIntervalType;
                } else {
                    longType$ = DoubleType$.MODULE$;
                }
                this.resultType = longType$;
                this.bitmap$0 |= 1;
            }
        }
        return this.resultType;
    }

    private AtomicType resultType() {
        return (this.bitmap$0 & 1) == 0 ? this.resultType$lzycompute() : this.resultType;
    }

    private AttributeReference sum$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if ((this.bitmap$0 & 2) == 0) {
                String x$1 = "sum";
                AtomicType x$2 = this.resultType();
                boolean x$3 = AttributeReference$.MODULE$.apply$default$3();
                Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
                ExprId x$5 = AttributeReference$.MODULE$.apply$default$5("sum", (DataType)x$2, x$3, x$4);
                Seq<String> x$6 = AttributeReference$.MODULE$.apply$default$6("sum", (DataType)x$2, x$3, x$4);
                this.sum = new AttributeReference("sum", (DataType)x$2, x$3, x$4, x$5, x$6);
                this.bitmap$0 |= 2;
            }
        }
        return this.sum;
    }

    private AttributeReference sum() {
        return (this.bitmap$0 & 2) == 0 ? this.sum$lzycompute() : this.sum;
    }

    private AttributeReference isEmpty$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if ((this.bitmap$0 & 4) == 0) {
                String x$1 = "isEmpty";
                BooleanType$ x$2 = BooleanType$.MODULE$;
                boolean x$3 = false;
                Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
                ExprId x$5 = AttributeReference$.MODULE$.apply$default$5("isEmpty", (DataType)x$2, false, x$4);
                Seq<String> x$6 = AttributeReference$.MODULE$.apply$default$6("isEmpty", (DataType)x$2, false, x$4);
                this.isEmpty = new AttributeReference("isEmpty", (DataType)x$2, false, x$4, x$5, x$6);
                this.bitmap$0 |= 4;
            }
        }
        return this.isEmpty;
    }

    private AttributeReference isEmpty() {
        return (this.bitmap$0 & 4) == 0 ? this.isEmpty$lzycompute() : this.isEmpty;
    }

    private Literal zero$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if ((this.bitmap$0 & 8) == 0) {
                this.zero = Literal$.MODULE$.default((DataType)this.resultType());
                this.bitmap$0 |= 8;
            }
        }
        return this.zero;
    }

    private Literal zero() {
        return (this.bitmap$0 & 8) == 0 ? this.zero$lzycompute() : this.zero;
    }

    private Expression add(Expression left, Expression right) {
        DataType dataType = left.dataType();
        BinaryOperator binaryOperator = dataType instanceof DecimalType ? new DecimalAddNoOverflowCheck(left, right, left.dataType()) : new Add(left, right, this.evalMode());
        return binaryOperator;
    }

    private Seq<AttributeReference> aggBufferAttributes$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if ((this.bitmap$0 & 0x10) == 0) {
                List list;
                if (this.shouldTrackIsEmpty()) {
                    AttributeReference attributeReference = this.sum();
                    AttributeReference attributeReference2 = this.isEmpty();
                    list = package$.MODULE$.Nil().$colon$colon((Object)attributeReference2).$colon$colon((Object)attributeReference);
                } else {
                    AttributeReference attributeReference = this.sum();
                    list = package$.MODULE$.Nil().$colon$colon((Object)attributeReference);
                }
                this.aggBufferAttributes = list;
                this.bitmap$0 |= 0x10;
            }
        }
        return this.aggBufferAttributes;
    }

    @Override
    public Seq<AttributeReference> aggBufferAttributes() {
        return (this.bitmap$0 & 0x10) == 0 ? this.aggBufferAttributes$lzycompute() : this.aggBufferAttributes;
    }

    private Seq<Expression> initialValues$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.initialValues = this.shouldTrackIsEmpty() ? (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Literal[]{this.zero(), new Literal(BoxesRunTime.boxToBoolean((boolean)true), (DataType)BooleanType$.MODULE$)})) : (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Literal[]{new Literal(null, (DataType)this.resultType())}));
                this.bitmap$0 |= 0x20;
            }
        }
        return this.initialValues;
    }

    @Override
    public Seq<Expression> initialValues() {
        return (this.bitmap$0 & 0x20) == 0 ? this.initialValues$lzycompute() : this.initialValues;
    }

    private Seq<Expression> updateExpressions$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if ((this.bitmap$0 & 0x40) == 0) {
                Seq seq;
                if (this.shouldTrackIsEmpty()) {
                    Expression sumExpr = this.child().nullable() ? new If((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.child()).isNull()), this.sum(), this.add(this.sum(), package$expressions$.MODULE$.DslExpression(new KnownNotNull(this.child())).cast((DataType)this.resultType()))) : this.add(this.sum(), package$expressions$.MODULE$.DslExpression(this.child()).cast((DataType)this.resultType()));
                    Literal isEmptyExpr = this.child().nullable() ? (Expression)((Object)package$expressions$.MODULE$.DslExpression(this.isEmpty()).$amp$amp((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.child()).isNull()))) : new Literal(BoxesRunTime.boxToBoolean((boolean)false), (DataType)BooleanType$.MODULE$);
                    seq = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{sumExpr, isEmptyExpr}));
                } else {
                    seq = this.child().nullable() ? (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package$expressions$.MODULE$.coalesce((Seq<Expression>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{this.add(package$expressions$.MODULE$.coalesce((Seq<Expression>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{this.sum(), this.zero()})), package$expressions$.MODULE$.DslExpression(this.child()).cast((DataType)this.resultType())), this.sum()}))})) : (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{this.add(package$expressions$.MODULE$.coalesce((Seq<Expression>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{this.sum(), this.zero()})), package$expressions$.MODULE$.DslExpression(this.child()).cast((DataType)this.resultType()))}));
                }
                this.updateExpressions = seq;
                this.bitmap$0 |= 0x40;
            }
        }
        return this.updateExpressions;
    }

    @Override
    public Seq<Expression> updateExpressions() {
        return (this.bitmap$0 & 0x40) == 0 ? this.updateExpressions$lzycompute() : this.updateExpressions;
    }

    private Seq<Expression> mergeExpressions$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if ((this.bitmap$0 & 0x80) == 0) {
                Seq seq;
                if (this.shouldTrackIsEmpty()) {
                    Predicate bufferOverflow = package$expressions$.MODULE$.DslExpression((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.RichAttribute(this.isEmpty()).left()).unary_$bang())).$amp$amp((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.RichAttribute(this.sum()).left()).isNull()));
                    Predicate inputOverflow = package$expressions$.MODULE$.DslExpression((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.RichAttribute(this.isEmpty()).right()).unary_$bang())).$amp$amp((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.RichAttribute(this.sum()).right()).isNull()));
                    seq = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{new If((Expression)((Object)package$expressions$.MODULE$.DslExpression((Expression)((Object)bufferOverflow)).$bar$bar((Expression)((Object)inputOverflow))), Literal$.MODULE$.create(null, (DataType)this.resultType()), this.add(new KnownNotNull(this.RichAttribute(this.sum()).left()), new KnownNotNull(this.RichAttribute(this.sum()).right()))), (Expression)((Object)package$expressions$.MODULE$.DslExpression(this.RichAttribute(this.isEmpty()).left()).$amp$amp(this.RichAttribute(this.isEmpty()).right()))}));
                } else {
                    seq = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package$expressions$.MODULE$.coalesce((Seq<Expression>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{this.add(package$expressions$.MODULE$.coalesce((Seq<Expression>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{this.RichAttribute(this.sum()).left(), this.zero()})), this.RichAttribute(this.sum()).right()), this.RichAttribute(this.sum()).left()}))}));
                }
                this.mergeExpressions = seq;
                this.bitmap$0 |= 0x80;
            }
        }
        return this.mergeExpressions;
    }

    @Override
    public Seq<Expression> mergeExpressions() {
        return (this.bitmap$0 & 0x80) == 0 ? this.mergeExpressions$lzycompute() : this.mergeExpressions;
    }

    private Expression evaluateExpression$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if ((this.bitmap$0 & 0x100) == 0) {
                Expression expression;
                AtomicType atomicType = this.resultType();
                if (atomicType instanceof DecimalType) {
                    DecimalType decimalType = (DecimalType)atomicType;
                    Enumeration.Value value = this.evalMode();
                    Enumeration.Value value2 = EvalMode$.MODULE$.ANSI();
                    CheckOverflowInSum checkOverflowInSum = new CheckOverflowInSum(this.sum(), decimalType, value == null ? value2 != null : !value.equals(value2), this.getContextOrNull());
                    expression = new If(this.isEmpty(), Literal$.MODULE$.create(null, (DataType)this.resultType()), checkOverflowInSum);
                } else {
                    expression = this.shouldTrackIsEmpty() ? new If(this.isEmpty(), Literal$.MODULE$.create(null, (DataType)this.resultType()), this.sum()) : this.sum();
                }
                this.evaluateExpression = expression;
                this.bitmap$0 |= 0x100;
            }
        }
        return this.evaluateExpression;
    }

    @Override
    public Expression evaluateExpression() {
        return (this.bitmap$0 & 0x100) == 0 ? this.evaluateExpression$lzycompute() : this.evaluateExpression;
    }

    @Override
    public Iterator<Object> flatArguments() {
        return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{this.child()}));
    }

    @Override
    public Option<SQLQueryContext> initQueryContext() {
        Enumeration.Value value = this.evalMode();
        Enumeration.Value value2 = EvalMode$.MODULE$.ANSI();
        return !(value != null ? !value.equals(value2) : value2 != null) ? new Some((Object)this.origin().context()) : None$.MODULE$;
    }

    @Override
    public Expression withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2());
    }

    public Sum copy(Expression child, Enumeration.Value evalMode) {
        return new Sum(child, evalMode);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Enumeration.Value copy$default$2() {
        return this.evalMode();
    }

    @Override
    public String productPrefix() {
        return "Sum";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.child();
                break;
            }
            case 1: {
                object = this.evalMode();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Sum;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "child";
                break;
            }
            case 1: {
                string = "evalMode";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Sum)) return false;
        boolean bl = true;
        if (!bl) return false;
        Sum sum = (Sum)x$1;
        Expression expression = this.child();
        Expression expression2 = sum.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Enumeration.Value value = this.evalMode();
        Enumeration.Value value2 = sum.evalMode();
        if (value == null) {
            if (value2 != null) {
                return false;
            }
        } else if (!value.equals(value2)) return false;
        if (!sum.canEqual(this)) return false;
        return true;
    }

    public Sum(Expression child, Enumeration.Value evalMode) {
        this.child = child;
        this.evalMode = evalMode;
        ExpectsInputTypes.$init$(this);
        UnaryLike.$init$(this);
        SupportQueryContext.$init$(this);
        this.nodePatterns = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{TreePattern$.MODULE$.SUM()}));
    }

    public Sum(Expression child) {
        this(child, EvalMode$.MODULE$.fromSQLConf(SQLConf$.MODULE$.get()));
    }
}

