/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.HashSet;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ArraysOverlap$;
import org.apache.spark.sql.catalyst.expressions.BinaryArrayExpressionWithImplicitCast;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Predicate;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.trees.SQLQueryContext;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(a1, a2) - Returns true if a1 contains at least a non-null element present also in a2. If the arrays have no common element and they are both non-empty and either of them contains a null element null is returned, false otherwise.", examples="\n    Examples:\n      > SELECT _FUNC_(array(1, 2, 3), array(3, 4, 5));\n       true\n  ", group="array_funcs", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0005\t5d\u0001\u0002\u0013&\u0001JB\u0001\"\u0016\u0001\u0003\u0016\u0004%\tA\u0016\u0005\t5\u0002\u0011\t\u0012)A\u0005/\"A1\f\u0001BK\u0002\u0013\u0005a\u000b\u0003\u0005]\u0001\tE\t\u0015!\u0003X\u0011\u0015i\u0006\u0001\"\u0001_\u0011\u0015\u0011\u0007\u0001\"\u0011d\u0011!Q\u0007\u0001#b\u0001\n\u0013Y\u0007\u0002\u0003<\u0001\u0011\u000b\u0007I\u0011B<\t\u000f\u0005\u0015\u0001\u0001\"\u0011\u0002\b!9\u0011q\u0002\u0001\u0005B\u0005E\u0001bBA\u000e\u0001\u0011%\u0011Q\u0004\u0005\b\u0003O\u0001A\u0011BA\u0015\u0011\u001d\ty\u0003\u0001C!\u0003cAq!!\u0014\u0001\t\u0013\ty\u0005C\u0004\u0002n\u0001!I!a\u001c\t\u000f\u0005e\u0004\u0001\"\u0001\u0002|!9\u0011Q\u0012\u0001\u0005B\u0005=\u0005bBAI\u0001\u0011E\u00131\u0013\u0005\n\u0003;\u0003\u0011\u0011!C\u0001\u0003?C\u0011\"!*\u0001#\u0003%\t!a*\t\u0013\u0005u\u0006!%A\u0005\u0002\u0005\u001d\u0006\"CA`\u0001\u0005\u0005I\u0011IAa\u0011%\t\t\u000eAA\u0001\n\u0003\t\u0019\u000eC\u0005\u0002\\\u0002\t\t\u0011\"\u0001\u0002^\"I\u00111\u001d\u0001\u0002\u0002\u0013\u0005\u0013Q\u001d\u0005\n\u0003g\u0004\u0011\u0011!C\u0001\u0003kD\u0011\"!?\u0001\u0003\u0003%\t%a?\t\u0013\u0005}\b!!A\u0005B\t\u0005q!\u0003B\u0013K\u0005\u0005\t\u0012\u0001B\u0014\r!!S%!A\t\u0002\t%\u0002BB/\u001f\t\u0003\u0011\t\u0005C\u0005\u0003Dy\t\t\u0011\"\u0012\u0003F!I!q\t\u0010\u0002\u0002\u0013\u0005%\u0011\n\u0005\n\u0005\u001fr\u0012\u0011!CA\u0005#B\u0011Ba\u0019\u001f\u0003\u0003%IA!\u001a\u0003\u001b\u0005\u0013(/Y=t\u001fZ,'\u000f\\1q\u0015\t1s%A\u0006fqB\u0014Xm]:j_:\u001c(B\u0001\u0015*\u0003!\u0019\u0017\r^1msN$(B\u0001\u0016,\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003Y5\nQa\u001d9be.T!AL\u0018\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0014aA8sO\u000e\u00011c\u0002\u00014oi\nEI\u0013\t\u0003iUj\u0011!J\u0005\u0003m\u0015\u0012\u0001CQ5oCJLX\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005QB\u0014BA\u001d&\u0005\u0015\u0012\u0015N\\1ss\u0006\u0013(/Y=FqB\u0014Xm]:j_:<\u0016\u000e\u001e5J[Bd\u0017nY5u\u0007\u0006\u001cH\u000f\u0005\u0002<}9\u0011A\u0007P\u0005\u0003{\u0015\nq\u0001]1dW\u0006<W-\u0003\u0002@\u0001\nqa*\u001e7m\u0013:$x\u000e\\3sC:$(BA\u001f&!\t!$)\u0003\u0002DK\tI\u0001K]3eS\u000e\fG/\u001a\t\u0003\u000b\"k\u0011A\u0012\u0006\u0002\u000f\u0006)1oY1mC&\u0011\u0011J\u0012\u0002\b!J|G-^2u!\tY%K\u0004\u0002M#:\u0011Q\nU\u0007\u0002\u001d*\u0011q*M\u0001\u0007yI|w\u000e\u001e \n\u0003\u001dK!!\u0010$\n\u0005M#&\u0001D*fe&\fG.\u001b>bE2,'BA\u001fG\u0003\u0011aWM\u001a;\u0016\u0003]\u0003\"\u0001\u000e-\n\u0005e+#AC#yaJ,7o]5p]\u0006)A.\u001a4uA\u0005)!/[4ii\u00061!/[4ii\u0002\na\u0001P5oSRtDcA0aCB\u0011A\u0007\u0001\u0005\u0006+\u0016\u0001\ra\u0016\u0005\u00067\u0016\u0001\raV\u0001\u0014G\",7m[%oaV$H)\u0019;b)f\u0004Xm\u001d\u000b\u0002IB\u0011Q\r[\u0007\u0002M*\u0011qmJ\u0001\tC:\fG._:jg&\u0011\u0011N\u001a\u0002\u0010)f\u0004Xm\u00115fG.\u0014Vm];mi\u0006AqN\u001d3fe&tw-F\u0001m!\rYUn\\\u0005\u0003]R\u0013\u0001b\u0014:eKJLgn\u001a\t\u0003\u000bBL!!\u001d$\u0003\u0007\u0005s\u0017\u0010\u000b\u0002\bgB\u0011Q\t^\u0005\u0003k\u001a\u0013\u0011\u0002\u001e:b]NLWM\u001c;\u0002\u0019\u0011|WI^1mk\u0006$\u0018n\u001c8\u0016\u0003a\u0004R!R=|w>L!A\u001f$\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004C\u0001?\u0000\u001b\u0005i(B\u0001@(\u0003\u0011)H/\u001b7\n\u0007\u0005\u0005QPA\u0005BeJ\f\u0017\u0010R1uC\"\u0012\u0001b]\u0001\t]VdG.\u00192mKV\u0011\u0011\u0011\u0002\t\u0004\u000b\u0006-\u0011bAA\u0007\r\n9!i\\8mK\u0006t\u0017\u0001\u00048vY2\u001c\u0016MZ3Fm\u0006dG#B8\u0002\u0014\u0005]\u0001BBA\u000b\u0015\u0001\u0007q.\u0001\u0002bc!1\u0011\u0011\u0004\u0006A\u0002=\f!!\u0019\u001a\u0002\u0011\u0019\f7\u000f^#wC2$Ra\\A\u0010\u0003GAa!!\t\f\u0001\u0004Y\u0018\u0001B1seFBa!!\n\f\u0001\u0004Y\u0018\u0001B1seJ\naB\u0019:vi\u00164uN]2f\u000bZ\fG\u000eF\u0003p\u0003W\ti\u0003\u0003\u0004\u0002\"1\u0001\ra\u001f\u0005\u0007\u0003Ka\u0001\u0019A>\u0002\u0013\u0011|w)\u001a8D_\u0012,GCBA\u001a\u0003\u007f\tI\u0005\u0005\u0003\u00026\u0005mRBAA\u001c\u0015\r\tI$J\u0001\bG>$WmZ3o\u0013\u0011\ti$a\u000e\u0003\u0011\u0015C\bO]\"pI\u0016Dq!!\u0011\u000e\u0001\u0004\t\u0019%A\u0002dib\u0004B!!\u000e\u0002F%!\u0011qIA\u001c\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDq!a\u0013\u000e\u0001\u0004\t\u0019$\u0001\u0002fm\u0006Ya-Y:u\u0007>$WmZ3o))\t\t&!\u0019\u0002d\u0005\u0015\u0014\u0011\u000e\t\u0005\u0003'\nYF\u0004\u0003\u0002V\u0005]\u0003CA'G\u0013\r\tIFR\u0001\u0007!J,G-\u001a4\n\t\u0005u\u0013q\f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005ec\tC\u0004\u0002B9\u0001\r!a\u0011\t\u000f\u0005-c\u00021\u0001\u00024!9\u0011q\r\bA\u0002\u0005E\u0013aB:nC2dWM\u001d\u0005\b\u0003Wr\u0001\u0019AA)\u0003\u0019\u0011\u0017nZ4fe\u0006\t\"M];uK\u001a{'oY3D_\u0012,w-\u001a8\u0015\u0015\u0005E\u0013\u0011OA:\u0003k\n9\bC\u0004\u0002B=\u0001\r!a\u0011\t\u000f\u0005-s\u00021\u0001\u00024!9\u0011qM\bA\u0002\u0005E\u0003bBA6\u001f\u0001\u0007\u0011\u0011K\u0001\u0017]VdGnU1gK\u0016cW-\\3oi\u000e{G-Z4f]RQ\u0011\u0011KA?\u0003\u0003\u000b))!#\t\u000f\u0005}\u0004\u00031\u0001\u0002R\u0005A\u0011M\u001d:bsZ\u000b'\u000fC\u0004\u0002\u0004B\u0001\r!!\u0015\u0002\u000b%tG-\u001a=\t\u000f\u0005\u001d\u0005\u00031\u0001\u0002R\u0005!1m\u001c3f\u0011\u001d\tY\t\u0005a\u0001\u0003#\n!\"[:Ok2d7i\u001c3f\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0003\u0003#\nqc^5uQ:+wo\u00115jY\u0012\u0014XM\\%oi\u0016\u0014h.\u00197\u0015\u000b}\u000b)*!'\t\r\u0005]%\u00031\u0001X\u0003\u001dqWm\u001e'fMRDa!a'\u0013\u0001\u00049\u0016\u0001\u00038foJKw\r\u001b;\u0002\t\r|\u0007/\u001f\u000b\u0006?\u0006\u0005\u00161\u0015\u0005\b+N\u0001\n\u00111\u0001X\u0011\u001dY6\u0003%AA\u0002]\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002**\u001aq+a+,\u0005\u00055\u0006\u0003BAX\u0003sk!!!-\u000b\t\u0005M\u0016QW\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a.G\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003w\u000b\tLA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003\u0007\u0004B!!2\u0002P6\u0011\u0011q\u0019\u0006\u0005\u0003\u0013\fY-\u0001\u0003mC:<'BAAg\u0003\u0011Q\u0017M^1\n\t\u0005u\u0013qY\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003+\u00042!RAl\u0013\r\tIN\u0012\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004_\u0006}\u0007\"CAq1\u0005\u0005\t\u0019AAk\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011q\u001d\t\u0006\u0003S\fyo\\\u0007\u0003\u0003WT1!!<G\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003c\fYO\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA\u0005\u0003oD\u0001\"!9\u001b\u0003\u0003\u0005\ra\\\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002D\u0006u\b\"CAq7\u0005\u0005\t\u0019AAk\u0003\u0019)\u0017/^1mgR!\u0011\u0011\u0002B\u0002\u0011!\t\t\u000fHA\u0001\u0002\u0004y\u0007f\u0005\u0001\u0003\b\t5!q\u0002B\n\u0005+\u0011IBa\u0007\u0003 \t\u0005\u0002c\u0001\u001b\u0003\n%\u0019!1B\u0013\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012!\u0011C\u0001\u0002X~3UKT\"`Q\u0005\fD\u0006I13S\u0001j\u0003EU3ukJt7\u000f\t;sk\u0016\u0004\u0013N\u001a\u0011bc\u0001\u001awN\u001c;bS:\u001c\b%\u0019;!Y\u0016\f7\u000f\u001e\u0011bA9|g.\f8vY2\u0004S\r\\3nK:$\b\u0005\u001d:fg\u0016tG\u000fI1mg>\u0004\u0013N\u001c\u0011be9\u0002\u0013J\u001a\u0011uQ\u0016\u0004\u0013M\u001d:bsN\u0004\u0003.\u0019<fA9|\u0007eY8n[>t\u0007%\u001a7f[\u0016tG\u000fI1oI\u0002\"\b.Z=!CJ,\u0007EY8uQ\u0002rwN\\\u0017f[B$\u0018\u0010I1oI\u0002*\u0017\u000e\u001e5fe\u0002zg\r\t;iK6\u00043m\u001c8uC&t7\u000fI1!]VdG\u000eI3mK6,g\u000e\u001e\u0011ok2d\u0007%[:!e\u0016$XO\u001d8fI2\u0002c-\u00197tK\u0002zG\u000f[3so&\u001cXML\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012!qC\u0001U\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\n'O]1zQEb\u0003E\r\u0017!g%b\u0003%\u0019:sCfD3\u0007\f\u00115Y\u0001*\u0014&K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!iJ,XM\u0003\u0011!\u0003\u00159'o\\;qC\t\u0011i\"A\u0006beJ\f\u0017p\u00184v]\u000e\u001c\u0018!B:j]\u000e,\u0017E\u0001B\u0012\u0003\u0015\u0011d\u0006\u000e\u00181\u00035\t%O]1zg>3XM\u001d7baB\u0011AGH\n\u0006=\t-\"q\u0007\t\b\u0005[\u0011\u0019dV,`\u001b\t\u0011yCC\u0002\u00032\u0019\u000bqA];oi&lW-\u0003\u0003\u00036\t=\"!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeA!!\u0011\bB \u001b\t\u0011YD\u0003\u0003\u0003>\u0005-\u0017AA5p\u0013\r\u0019&1\b\u000b\u0003\u0005O\t\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003\u0007\fQ!\u00199qYf$Ra\u0018B&\u0005\u001bBQ!V\u0011A\u0002]CQaW\u0011A\u0002]\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003T\t}\u0003#B#\u0003V\te\u0013b\u0001B,\r\n1q\n\u001d;j_:\u0004R!\u0012B./^K1A!\u0018G\u0005\u0019!V\u000f\u001d7fe!A!\u0011\r\u0012\u0002\u0002\u0003\u0007q,A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"Aa\u001a\u0011\t\u0005\u0015'\u0011N\u0005\u0005\u0005W\n9M\u0001\u0004PE*,7\r\u001e")
public class ArraysOverlap
extends BinaryExpression
implements BinaryArrayExpressionWithImplicitCast,
package.NullIntolerant,
Predicate,
Serializable {
    private transient Ordering<Object> ordering;
    private transient Function2<ArrayData, ArrayData, Object> doEvaluation;
    private final Expression left;
    private final Expression right;
    private transient DataType elementType;
    private volatile transient byte bitmap$trans$0;

    public static Option<Tuple2<Expression, Expression>> unapply(ArraysOverlap x$0) {
        return ArraysOverlap$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, ArraysOverlap> tupled() {
        return ArraysOverlap$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, ArraysOverlap>> curried() {
        return ArraysOverlap$.MODULE$.curried();
    }

    @Override
    public DataType dataType() {
        return Predicate.dataType$(this);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return BinaryArrayExpressionWithImplicitCast.inputTypes$(this);
    }

    @Override
    public boolean leftArrayElementNullable() {
        return BinaryArrayExpressionWithImplicitCast.leftArrayElementNullable$(this);
    }

    @Override
    public boolean rightArrayElementNullable() {
        return BinaryArrayExpressionWithImplicitCast.rightArrayElementNullable$(this);
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toDSOption(String option) {
        return QueryErrorsBase.toDSOption$(this, option);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLSchema(String schema) {
        return QueryErrorsBase.toSQLSchema$(this, schema);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    @Override
    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    @Override
    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    @Override
    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    @Override
    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    @Override
    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    @Override
    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    @Override
    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    @Override
    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    @Override
    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    @Override
    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    @Override
    public String getSummary(SQLQueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (SQLQueryContext)sqlContext);
    }

    @Override
    public QueryContext[] getQueryContext(SQLQueryContext sqlContext) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (SQLQueryContext)sqlContext);
    }

    private DataType elementType$lzycompute() {
        ArraysOverlap arraysOverlap = this;
        synchronized (arraysOverlap) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.elementType = BinaryArrayExpressionWithImplicitCast.elementType$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.elementType;
    }

    @Override
    public DataType elementType() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.elementType$lzycompute() : this.elementType;
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult typeCheckResult = BinaryArrayExpressionWithImplicitCast.checkInputDataTypes$(this);
        TypeCheckResult typeCheckResult2 = TypeCheckResult$TypeCheckSuccess$.MODULE$.equals(typeCheckResult) ? TypeUtils$.MODULE$.checkForOrderingExpr(this.elementType(), this.prettyName()) : typeCheckResult;
        return typeCheckResult2;
    }

    private Ordering<Object> ordering$lzycompute() {
        ArraysOverlap arraysOverlap = this;
        synchronized (arraysOverlap) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.ordering = TypeUtils$.MODULE$.getInterpretedOrdering(this.elementType());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.ordering;
    }

    private Ordering<Object> ordering() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.ordering$lzycompute() : this.ordering;
    }

    private Function2<ArrayData, ArrayData, Object> doEvaluation$lzycompute() {
        ArraysOverlap arraysOverlap = this;
        synchronized (arraysOverlap) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.doEvaluation = TypeUtils$.MODULE$.typeWithProperEquals(this.elementType()) ? (Function2 & Serializable)(arr1, arr2) -> this.fastEval((ArrayData)arr1, (ArrayData)arr2) : (Function2 & Serializable)(arr1, arr2) -> this.bruteForceEval((ArrayData)arr1, (ArrayData)arr2);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.doEvaluation;
    }

    private Function2<ArrayData, ArrayData, Object> doEvaluation() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.doEvaluation$lzycompute() : this.doEvaluation;
    }

    @Override
    public boolean nullable() {
        return this.left().nullable() || this.right().nullable() || this.leftArrayElementNullable() || this.rightArrayElementNullable();
    }

    @Override
    public Object nullSafeEval(Object a1, Object a2) {
        return this.doEvaluation().apply((Object)((ArrayData)a1), (Object)((ArrayData)a2));
    }

    private Object fastEval(ArrayData arr1, ArrayData arr2) {
        Object object;
        Object object2 = new Object();
        try {
            Tuple2 tuple2;
            BooleanRef hasNull = BooleanRef.create((boolean)false);
            Tuple2 tuple22 = tuple2 = arr1.numElements() > arr2.numElements() ? new Tuple2((Object)arr1, (Object)arr2) : new Tuple2((Object)arr2, (Object)arr1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ArrayData bigger = (ArrayData)tuple2._1();
            ArrayData smaller = (ArrayData)tuple2._2();
            Tuple2 tuple23 = new Tuple2((Object)bigger, (Object)smaller);
            Tuple2 tuple24 = tuple23;
            ArrayData bigger2 = (ArrayData)tuple24._1();
            ArrayData smaller2 = (ArrayData)tuple24._2();
            if (smaller2.numElements() > 0) {
                HashSet smallestSet = new HashSet();
                smaller2.foreach(this.elementType(), (Function2<Object, Object, BoxedUnit>)(Function2 & Serializable)(x$21, v) -> {
                    ArraysOverlap.$anonfun$fastEval$1(hasNull, smallestSet, BoxesRunTime.unboxToInt((Object)x$21), v);
                    return BoxedUnit.UNIT;
                });
                bigger2.foreach(this.elementType(), (Function2<Object, Object, BoxedUnit>)(Function2 & Serializable)(x$22, v1) -> {
                    ArraysOverlap.$anonfun$fastEval$2(hasNull, smallestSet, object2, BoxesRunTime.unboxToInt((Object)x$22), v1);
                    return BoxedUnit.UNIT;
                });
            }
            object = hasNull.elem ? null : BoxesRunTime.boxToBoolean((boolean)false);
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object2) {
                object = ex.value();
            }
            throw ex;
        }
        return object;
    }

    private Object bruteForceEval(ArrayData arr1, ArrayData arr2) {
        Object object;
        Object object2 = new Object();
        try {
            BooleanRef hasNull = BooleanRef.create((boolean)false);
            if (arr1.numElements() > 0 && arr2.numElements() > 0) {
                arr1.foreach(this.elementType(), (Function2<Object, Object, BoxedUnit>)(Function2 & Serializable)(x$23, v1) -> {
                    ArraysOverlap.$anonfun$bruteForceEval$1(this, hasNull, arr2, object2, BoxesRunTime.unboxToInt((Object)x$23), v1);
                    return BoxedUnit.UNIT;
                });
            }
            object = hasNull.elem ? null : BoxesRunTime.boxToBoolean((boolean)false);
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object2) {
                object = ex.value();
            }
            throw ex;
        }
        return object;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(a1, a2) -> {
            String smaller = ctx.freshName("smallerArray");
            String bigger = ctx.freshName("biggerArray");
            String comparisonCode = TypeUtils$.MODULE$.typeWithProperEquals(this.elementType()) ? this.fastCodegen(ctx, ev, smaller, bigger) : this.bruteForceCodegen(ctx, ev, smaller, bigger);
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(261).append("\n         |ArrayData ").append(smaller).append(";\n         |ArrayData ").append(bigger).append(";\n         |if (").append((String)a1).append(".numElements() > ").append((String)a2).append(".numElements()) {\n         |  ").append(bigger).append(" = ").append((String)a1).append(";\n         |  ").append(smaller).append(" = ").append((String)a2).append(";\n         |} else {\n         |  ").append(smaller).append(" = ").append((String)a1).append(";\n         |  ").append(bigger).append(" = ").append((String)a2).append(";\n         |}\n         |if (").append(smaller).append(".numElements() > 0) {\n         |  ").append(comparisonCode).append("\n         |}\n       ").toString()));
        });
    }

    private String fastCodegen(CodegenContext ctx, ExprCode ev, String smaller, String bigger) {
        String i = ctx.freshName("i");
        String getFromSmaller = CodeGenerator$.MODULE$.getValue(smaller, this.elementType(), i);
        String getFromBigger = CodeGenerator$.MODULE$.getValue(bigger, this.elementType(), i);
        String javaElementClass = CodeGenerator$.MODULE$.boxedType(this.elementType());
        String javaSet = HashSet.class.getName();
        String set = ctx.freshName("set");
        String addToSetFromSmallerCode = this.nullSafeElementCodegen(smaller, i, new StringBuilder(7).append(set).append(".add(").append(getFromSmaller).append(");").toString(), new StringBuilder(8).append(ev.isNull()).append(" = true;").toString());
        String setIsNullCode = this.nullable() ? new StringBuilder(9).append(ev.isNull()).append(" = false;").toString() : "";
        String elementIsInSetCode = this.nullSafeElementCodegen(bigger, i, StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(102).append("\n         |if (").append(set).append(".contains(").append(getFromBigger).append(")) {\n         |  ").append(setIsNullCode).append("\n         |  ").append(ev.value()).append(" = true;\n         |  break;\n         |}\n       ").toString())), new StringBuilder(8).append(ev.isNull()).append(" = true;").toString());
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(170).append("\n       |").append(javaSet).append("<").append(javaElementClass).append("> ").append(set).append(" = new ").append(javaSet).append("<").append(javaElementClass).append(">();\n       |for (int ").append(i).append(" = 0; ").append(i).append(" < ").append(smaller).append(".numElements(); ").append(i).append(" ++) {\n       |  ").append(addToSetFromSmallerCode).append("\n       |}\n       |for (int ").append(i).append(" = 0; ").append(i).append(" < ").append(bigger).append(".numElements(); ").append(i).append(" ++) {\n       |  ").append(elementIsInSetCode).append("\n       |}\n     ").toString()));
    }

    private String bruteForceCodegen(CodegenContext ctx, ExprCode ev, String smaller, String bigger) {
        String i = ctx.freshName("i");
        String j = ctx.freshName("j");
        String getFromSmaller = CodeGenerator$.MODULE$.getValue(smaller, this.elementType(), j);
        String getFromBigger = CodeGenerator$.MODULE$.getValue(bigger, this.elementType(), i);
        String setIsNullCode = this.nullable() ? new StringBuilder(9).append(ev.isNull()).append(" = false;").toString() : "";
        String compareValues = this.nullSafeElementCodegen(smaller, j, StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(72).append("\n         |if (").append(ctx.genEqual(this.elementType(), getFromSmaller, getFromBigger)).append(") {\n         |  ").append(setIsNullCode).append("\n         |  ").append(ev.value()).append(" = true;\n         |}\n       ").toString())), new StringBuilder(8).append(ev.isNull()).append(" = true;").toString());
        String isInSmaller = this.nullSafeElementCodegen(bigger, i, StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(89).append("\n         |for (int ").append(j).append(" = 0; ").append(j).append(" < ").append(smaller).append(".numElements() && !").append(ev.value()).append("; ").append(j).append(" ++) {\n         |  ").append(compareValues).append("\n         |}\n       ").toString())), new StringBuilder(8).append(ev.isNull()).append(" = true;").toString());
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(81).append("\n       |for (int ").append(i).append(" = 0; ").append(i).append(" < ").append(bigger).append(".numElements() && !").append(ev.value()).append("; ").append(i).append(" ++) {\n       |  ").append(isInSmaller).append("\n       |}\n     ").toString()));
    }

    public String nullSafeElementCodegen(String arrayVar, String index, String code, String isNullCode) {
        return this.inputTypes().exists((Function1 & Serializable)x$25 -> BoxesRunTime.boxToBoolean((boolean)ArraysOverlap.$anonfun$nullSafeElementCodegen$1(x$25))) ? StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(94).append("\n         |if (").append(arrayVar).append(".isNullAt(").append(index).append(")) {\n         |  ").append(isNullCode).append("\n         |} else {\n         |  ").append(code).append("\n         |}\n       ").toString())) : code;
    }

    @Override
    public String prettyName() {
        return "arrays_overlap";
    }

    @Override
    public ArraysOverlap withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public ArraysOverlap copy(Expression left, Expression right) {
        return new ArraysOverlap(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "ArraysOverlap";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.left();
                break;
            }
            case 1: {
                object = this.right();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArraysOverlap;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "left";
                break;
            }
            case 1: {
                string = "right";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ArraysOverlap)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArraysOverlap arraysOverlap = (ArraysOverlap)x$1;
        Expression expression = this.left();
        Expression expression2 = arraysOverlap.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = arraysOverlap.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!arraysOverlap.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$fastEval$1(BooleanRef hasNull$2, HashSet smallestSet$1, int x$21, Object v) {
        if (v == null) {
            hasNull$2.elem = true;
        } else {
            smallestSet$1.add(v);
        }
    }

    public static final /* synthetic */ void $anonfun$fastEval$2(BooleanRef hasNull$2, HashSet smallestSet$1, Object nonLocalReturnKey2$1, int x$22, Object v1) {
        if (v1 == null) {
            hasNull$2.elem = true;
        } else if (smallestSet$1.contains(v1)) {
            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey2$1, true);
        }
    }

    public static final /* synthetic */ void $anonfun$bruteForceEval$2(ArraysOverlap $this, BooleanRef hasNull$3, Object v1$1, Object nonLocalReturnKey3$1, int x$24, Object v2) {
        if (v2 == null) {
            hasNull$3.elem = true;
        } else if ($this.ordering().equiv(v1$1, v2)) {
            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey3$1, true);
        }
    }

    public static final /* synthetic */ void $anonfun$bruteForceEval$1(ArraysOverlap $this, BooleanRef hasNull$3, ArrayData arr2$1, Object nonLocalReturnKey3$1, int x$23, Object v1) {
        if (v1 == null) {
            hasNull$3.elem = true;
        } else {
            arr2$1.foreach($this.elementType(), (Function2<Object, Object, BoxedUnit>)(Function2 & Serializable)(x$24, v2) -> {
                ArraysOverlap.$anonfun$bruteForceEval$2($this, hasNull$3, v1, nonLocalReturnKey3$1, BoxesRunTime.unboxToInt((Object)x$24), v2);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ boolean $anonfun$nullSafeElementCodegen$1(AbstractDataType x$25) {
        return ((ArrayType)x$25).containsNull();
    }

    public ArraysOverlap(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
        BinaryArrayExpressionWithImplicitCast.$init$(this);
        Predicate.$init$(this);
    }
}

