/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.sql.streaming;

import java.io.Serializable;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.streaming.StreamingQuery;
import scala.Function1;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;

public final class StructuredNetworkWordCount$ {
    public static final StructuredNetworkWordCount$ MODULE$ = new StructuredNetworkWordCount$();

    public void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Usage: StructuredNetworkWordCount <hostname> <port>");
            System.exit(1);
        }
        String host = args[0];
        int port = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(args[1]));
        SparkSession spark = SparkSession$.MODULE$.builder().appName("StructuredNetworkWordCount").getOrCreate();
        Dataset lines = spark.readStream().format("socket").option("host", host).option("port", (long)port).load();
        Dataset words = lines.as(spark.implicits().newStringEncoder()).flatMap((Function1 & Serializable)x$1 -> Predef$.MODULE$.wrapRefArray((Object[])x$1.split(" ")), spark.implicits().newStringEncoder());
        Dataset wordCounts = words.groupBy("value", (Seq)Nil$.MODULE$).count();
        StreamingQuery query = wordCounts.writeStream().outputMode("complete").format("console").start();
        query.awaitTermination();
    }

    private StructuredNetworkWordCount$() {
    }
}

