/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.sql.streaming;

import java.io.Serializable;
import java.sql.Timestamp;
import org.apache.spark.examples.sql.streaming.EventTypes$;
import org.apache.spark.examples.sql.streaming.Session;
import org.apache.spark.examples.sql.streaming.SessionAcc;
import org.apache.spark.examples.sql.streaming.SessionEvent;
import org.apache.spark.examples.sql.streaming.SessionEvent$;
import org.apache.spark.examples.sql.streaming.StructuredComplexSessionization$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.streaming.GroupState;
import org.apache.spark.sql.streaming.GroupStateTimeout;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.streaming.StreamingQuery;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Enumeration;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

public final class StructuredComplexSessionization$ {
    public static final StructuredComplexSessionization$ MODULE$ = new StructuredComplexSessionization$();

    public void main(String[] args) {
        public final class Org_apache_spark_examples_sql_streaming_StructuredComplexSessionization$$typecreator18$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.examples.sql.streaming.Session").asType().toTypeConstructor();
            }

            public Org_apache_spark_examples_sql_streaming_StructuredComplexSessionization$$typecreator18$1() {
            }
        }
        public final class Org_apache_spark_examples_sql_streaming_StructuredComplexSessionization$$typecreator12$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("scala")), (Symbols.SymbolApi)$m.staticModule("scala.package")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.package").asModule().moduleClass(), "List"), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.examples.sql.streaming.SessionAcc").asType().toTypeConstructor(), (List)Nil$.MODULE$));
            }

            public Org_apache_spark_examples_sql_streaming_StructuredComplexSessionization$$typecreator12$1() {
            }
        }
        if (args.length < 2) {
            System.err.println("Usage: StructuredComplexSessionization <hostname> <port>");
            System.exit(1);
        }
        String host = args[0];
        int port = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(args[1]));
        SparkSession spark = SparkSession$.MODULE$.builder().appName("StructuredComplexSessionization").getOrCreate();
        Dataset lines = spark.readStream().format("socket").option("host", host).option("port", (long)port).load();
        StructType jsonSchema = new StructType().add("user_id", (DataType)StringType$.MODULE$, false).add("event_type", (DataType)StringType$.MODULE$, false).add("timestamp", (DataType)TimestampType$.MODULE$, false);
        long gapDuration = 5000L;
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_examples_sql_streaming_StructuredComplexSessionization$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$m.staticClass("java.sql.Timestamp").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
            }

            public Org_apache_spark_examples_sql_streaming_StructuredComplexSessionization$$typecreator5$1() {
            }
        }
        Dataset events = lines.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.from_json(functions$.MODULE$.col("value"), jsonSchema).as("event")})).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"event.user_id AS user_id", "event.event_type AS event_type", "event.timestamp AS timestamp"})).withWatermark("timestamp", "10 seconds").as(spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_examples_sql_streaming_StructuredComplexSessionization$$typecreator5$1())));
        JavaUniverse $u2 = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u3 = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m3 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        Dataset sessionUpdates = events.groupByKey((Function1 & Serializable)event -> (String)event._1(), spark.implicits().newStringEncoder()).flatMapGroupsWithState(OutputMode.Append(), GroupStateTimeout.EventTimeTimeout(), (Function3 & Serializable)(x0$1, x1$1, x2$1) -> {
            Iterator iterator;
            Tuple3 tuple3 = new Tuple3(x0$1, x1$1, x2$1);
            if (tuple3 == null) throw new MatchError((Object)tuple3);
            String userId = (String)tuple3._1();
            Iterator events = (Iterator)tuple3._2();
            GroupState state = (GroupState)tuple3._3();
            if (userId == null) throw new MatchError((Object)tuple3);
            String string = userId;
            if (events == null) throw new MatchError((Object)tuple3);
            Iterator iterator2 = events;
            if (state == null) throw new MatchError((Object)tuple3);
            GroupState groupState = state;
            if (groupState.hasTimedOut() && groupState.exists()) {
                iterator = StructuredComplexSessionization$.handleEvict$1((List)((SeqOps)groupState.get()).sortBy((Function1 & Serializable)x$3 -> BoxesRunTime.boxToLong((long)StructuredComplexSessionization$.$anonfun$main$7(x$3)), (Ordering)Ordering.Long$.MODULE$), groupState, string);
                return iterator;
            } else {
                List sessionsFromEvents = iterator2.map((Function1 & Serializable)x0$2 -> {
                    Tuple3 tuple3 = x0$2;
                    if (tuple3 == null) {
                        throw new MatchError((Object)tuple3);
                    }
                    String userId = (String)tuple3._1();
                    String eventType = (String)tuple3._2();
                    Timestamp timestamp = (Timestamp)tuple3._3();
                    SessionEvent e = SessionEvent$.MODULE$.apply(userId, eventType, timestamp, gapDuration);
                    SessionAcc sessionAcc = new SessionAcc((List<SessionEvent>)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SessionEvent[]{e}))));
                    return sessionAcc;
                }).toList();
                if (sessionsFromEvents.nonEmpty()) {
                    List sessionsFromState = groupState.exists() ? (List)groupState.get() : package$.MODULE$.List().empty();
                    StructuredComplexSessionization$.mergeSessions$1((List)((SeqOps)sessionsFromEvents.$plus$plus((IterableOnce)sessionsFromState)).sortBy((Function1 & Serializable)x$4 -> BoxesRunTime.boxToLong((long)StructuredComplexSessionization$.$anonfun$main$9(x$4)), (Ordering)Ordering.Long$.MODULE$), groupState);
                    iterator = StructuredComplexSessionization$.handleEvict$1((List)((SeqOps)groupState.get()).sortBy((Function1 & Serializable)x$5 -> BoxesRunTime.boxToLong((long)StructuredComplexSessionization$.$anonfun$main$10(x$5)), (Ordering)Ordering.Long$.MODULE$), groupState, string);
                    return iterator;
                } else {
                    iterator = package$.MODULE$.Iterator().empty();
                }
            }
            return iterator;
        }, spark.implicits().newSequenceEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_examples_sql_streaming_StructuredComplexSessionization$$typecreator12$1())), spark.implicits().newProductEncoder(((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_spark_examples_sql_streaming_StructuredComplexSessionization$$typecreator18$1())));
        StreamingQuery query = sessionUpdates.writeStream().outputMode("append").format("console").start();
        query.awaitTermination();
    }

    public static final /* synthetic */ boolean $anonfun$main$3(GroupState x4$1, SessionAcc s) {
        return s.endTime().getTime() < x4$1.getCurrentWatermarkMs();
    }

    private static final Iterator handleEvict$1(List sessions, GroupState x4$1, String x2$1) {
        Tuple2 tuple2 = sessions.span((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)StructuredComplexSessionization$.$anonfun$main$3(x4$1, s)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        List evicted = (List)tuple2._1();
        List kept = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)evicted, (Object)kept);
        Tuple2 tuple23 = tuple22;
        List evicted2 = (List)tuple23._1();
        List kept2 = (List)tuple23._2();
        if (kept2.isEmpty()) {
            x4$1.remove();
        } else {
            x4$1.update((Object)kept2);
            x4$1.setTimeoutTimestamp(((SessionAcc)kept2.head()).endTime().getTime());
        }
        return evicted2.map((Function1 & Serializable)sessionAcc -> new Session(x2$1, sessionAcc.endTime().getTime() - sessionAcc.startTime().getTime(), sessionAcc.events().length())).iterator();
    }

    public static final /* synthetic */ long $anonfun$main$5(SessionEvent x$2) {
        return x$2.startTimestamp().getTime();
    }

    public static final /* synthetic */ void $anonfun$main$6(ObjectRef eventsForCurSession$1, ArrayBuffer newSessions$1, SessionEvent event) {
        block0: {
            ((ArrayBuffer)eventsForCurSession$1.elem).$plus$eq((Object)event);
            Enumeration.Value value = event.eventType();
            Enumeration.Value value2 = EventTypes$.MODULE$.CLOSE_SESSION();
            if (value != null ? !value.equals(value2) : value2 != null) break block0;
            newSessions$1.$plus$eq((Object)new SessionAcc((List<SessionEvent>)((ArrayBuffer)eventsForCurSession$1.elem).toList()));
            eventsForCurSession$1.elem = new ArrayBuffer();
        }
    }

    private static final void mergeSessions$1(List sessions, GroupState x4$1) {
        ArrayBuffer updatedSessions = new ArrayBuffer();
        updatedSessions.$plus$plus$eq((IterableOnce)sessions);
        int curIdx = 0;
        while (curIdx < updatedSessions.length() - 1) {
            SessionAcc curSession = (SessionAcc)updatedSessions.apply(curIdx);
            SessionAcc nextSession = (SessionAcc)updatedSessions.apply(curIdx + 1);
            if (curSession.endTime().getTime() > nextSession.startTime().getTime()) {
                List accumulatedEvents = (List)((SeqOps)curSession.events().$plus$plus(nextSession.events())).sortBy((Function1 & Serializable)x$2 -> BoxesRunTime.boxToLong((long)StructuredComplexSessionization$.$anonfun$main$5(x$2)), (Ordering)Ordering.Long$.MODULE$);
                ArrayBuffer newSessions = new ArrayBuffer();
                ObjectRef eventsForCurSession = ObjectRef.create((Object)new ArrayBuffer());
                accumulatedEvents.foreach((Function1 & Serializable)event -> {
                    StructuredComplexSessionization$.$anonfun$main$6(eventsForCurSession, newSessions, event);
                    return BoxedUnit.UNIT;
                });
                Object object = ((ArrayBuffer)eventsForCurSession.elem).nonEmpty() ? newSessions.$plus$eq((Object)new SessionAcc((List<SessionEvent>)((ArrayBuffer)eventsForCurSession.elem).toList())) : BoxedUnit.UNIT;
                updatedSessions.remove(curIdx + 1);
                updatedSessions.update(curIdx, newSessions.head());
                if (newSessions.length() > 1) {
                    updatedSessions.insertAll(curIdx + 1, (IterableOnce)newSessions.tail());
                }
                curIdx += newSessions.length() - 1;
                continue;
            }
            ++curIdx;
        }
        x4$1.update((Object)updatedSessions.toList());
    }

    public static final /* synthetic */ long $anonfun$main$7(SessionAcc x$3) {
        return x$3.startTime().getTime();
    }

    public static final /* synthetic */ long $anonfun$main$9(SessionAcc x$4) {
        return x$4.startTime().getTime();
    }

    public static final /* synthetic */ long $anonfun$main$10(SessionAcc x$5) {
        return x$5.startTime().getTime();
    }

    private StructuredComplexSessionization$() {
    }
}

