/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.mllib.classification.LogisticRegressionModel;
import org.apache.spark.mllib.evaluation.BinaryClassificationMetrics;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors;
import org.apache.spark.mllib.optimization.Gradient;
import org.apache.spark.mllib.optimization.LBFGS;
import org.apache.spark.mllib.optimization.LogisticGradient;
import org.apache.spark.mllib.optimization.SquaredL2Updater;
import org.apache.spark.mllib.optimization.Updater;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.util.MLUtils;
import org.apache.spark.rdd.RDD;
import scala.Tuple2;

public class JavaLBFGSExample {
    public static void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("L-BFGS Example");
        SparkContext sc = new SparkContext(conf);
        String path = "data/mllib/sample_libsvm_data.txt";
        JavaRDD data = MLUtils.loadLibSVMFile((SparkContext)sc, (String)path).toJavaRDD();
        int numFeatures = ((LabeledPoint)data.take(1).get(0)).features().size();
        JavaRDD trainingInit = data.sample(false, 0.6, 11L);
        JavaRDD test = data.subtract(trainingInit);
        JavaPairRDD training = data.mapToPair((PairFunction & Serializable)p -> new Tuple2((Object)p.label(), (Object)MLUtils.appendBias((Vector)p.features())));
        training.cache();
        int numCorrections = 10;
        double convergenceTol = 1.0E-4;
        int maxNumIterations = 20;
        double regParam = 0.1;
        Vector initialWeightsWithIntercept = Vectors.dense((double[])new double[numFeatures + 1]);
        Tuple2 result = LBFGS.runLBFGS((RDD)training.rdd(), (Gradient)new LogisticGradient(), (Updater)new SquaredL2Updater(), (int)numCorrections, (double)convergenceTol, (int)maxNumIterations, (double)regParam, (Vector)initialWeightsWithIntercept);
        Vector weightsWithIntercept = (Vector)result._1();
        double[] loss = (double[])result._2();
        LogisticRegressionModel model = new LogisticRegressionModel(Vectors.dense((double[])Arrays.copyOf(weightsWithIntercept.toArray(), weightsWithIntercept.size() - 1)), weightsWithIntercept.toArray()[weightsWithIntercept.size() - 1]);
        model.clearThreshold();
        JavaPairRDD scoreAndLabels = test.mapToPair((PairFunction & Serializable)p -> new Tuple2((Object)model.predict(p.features()), (Object)p.label()));
        BinaryClassificationMetrics metrics = new BinaryClassificationMetrics(scoreAndLabels.rdd());
        double auROC = metrics.areaUnderROC();
        System.out.println("Loss of each step in training process");
        for (double l : loss) {
            System.out.println(l);
        }
        System.out.println("Area under ROC = " + auROC);
        sc.stop();
    }
}

